/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.stacks.AEKeyType;
import appeng.api.storage.AEKeyFilter;
import appeng.parts.automation.ExternalStorageStrategy;
import appeng.parts.automation.FabricExternalStorageStrategy;
import appeng.parts.automation.FluidPickupStrategy;
import appeng.parts.automation.FluidPlacementStrategy;
import appeng.parts.automation.ItemPickupStrategy;
import appeng.parts.automation.ItemPlacementStrategy;
import appeng.parts.automation.PickupStrategy;
import appeng.parts.automation.PlacementStrategy;
import appeng.parts.automation.PlacementStrategyFacade;
import appeng.parts.automation.StackExportFacade;
import appeng.parts.automation.StackExportStrategy;
import appeng.parts.automation.StackImportFacade;
import appeng.parts.automation.StackImportStrategy;
import appeng.parts.automation.StorageExportStrategy;
import appeng.parts.automation.StorageImportStrategy;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public final class StackWorldBehaviors {
    private static final Map<AEKeyType, ImportStrategyFactory> importStrategies = new IdentityHashMap<AEKeyType, ImportStrategyFactory>();
    private static final Map<AEKeyType, ExportStrategyFactory> exportStrategies = new IdentityHashMap<AEKeyType, ExportStrategyFactory>();
    private static final Map<AEKeyType, ExternalStorageStrategyFactory> externalStorageStrategies = new IdentityHashMap<AEKeyType, ExternalStorageStrategyFactory>();
    private static final Map<AEKeyType, PlacementStrategyFactory> placementStrategies = new IdentityHashMap<AEKeyType, PlacementStrategyFactory>();
    private static final Map<AEKeyType, PickupStrategyFactory> pickupStrategies = new IdentityHashMap<AEKeyType, PickupStrategyFactory>();

    private StackWorldBehaviors() {
    }

    public static AEKeyFilter hasImportStrategyFilter() {
        return what -> importStrategies.containsKey(what.getType());
    }

    public static AEKeyFilter hasExportStrategyFilter() {
        return what -> exportStrategies.containsKey(what.getType());
    }

    public static AEKeyFilter hasPlacementStrategy() {
        return what -> placementStrategies.containsKey(what.getType());
    }

    public static StackImportStrategy createImportFacade(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        ArrayList<StackImportStrategy> strategies = new ArrayList<StackImportStrategy>(importStrategies.size());
        for (ImportStrategyFactory supplier : importStrategies.values()) {
            strategies.add(supplier.create(level, fromPos, fromSide));
        }
        return new StackImportFacade(strategies);
    }

    public static StackExportStrategy createExportFacade(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        ArrayList<StackExportStrategy> strategies = new ArrayList<StackExportStrategy>(exportStrategies.size());
        for (ExportStrategyFactory supplier : exportStrategies.values()) {
            strategies.add(supplier.create(level, fromPos, fromSide));
        }
        return new StackExportFacade(strategies);
    }

    public static Map<AEKeyType, ExternalStorageStrategy> createExternalStorageStrategies(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        IdentityHashMap<AEKeyType, ExternalStorageStrategy> strategies = new IdentityHashMap<AEKeyType, ExternalStorageStrategy>(externalStorageStrategies.size());
        for (Map.Entry<AEKeyType, ExternalStorageStrategyFactory> entry : externalStorageStrategies.entrySet()) {
            strategies.put(entry.getKey(), entry.getValue().create(level, fromPos, fromSide));
        }
        return strategies;
    }

    public static PlacementStrategy createPlacementStrategies(class_3218 level, class_2338 fromPos, class_2350 fromSide, class_2586 host) {
        IdentityHashMap<AEKeyType, PlacementStrategy> strategies = new IdentityHashMap<AEKeyType, PlacementStrategy>(placementStrategies.size());
        for (Map.Entry<AEKeyType, PlacementStrategyFactory> entry : placementStrategies.entrySet()) {
            strategies.put(entry.getKey(), entry.getValue().create(level, fromPos, fromSide, host));
        }
        return new PlacementStrategyFacade(strategies);
    }

    public static List<PickupStrategy> createPickupStrategies(class_3218 level, class_2338 fromPos, class_2350 fromSide, class_2586 host, boolean allowSilkTouch) {
        return pickupStrategies.values().stream().map(f -> f.create(level, fromPos, fromSide, host, allowSilkTouch)).toList();
    }

    static {
        importStrategies.put(AEKeyType.items(), StorageImportStrategy::createItem);
        importStrategies.put(AEKeyType.fluids(), StorageImportStrategy::createFluid);
        exportStrategies.put(AEKeyType.items(), StorageExportStrategy::createItem);
        exportStrategies.put(AEKeyType.fluids(), StorageExportStrategy::createFluid);
        externalStorageStrategies.put(AEKeyType.items(), FabricExternalStorageStrategy::createItem);
        externalStorageStrategies.put(AEKeyType.fluids(), FabricExternalStorageStrategy::createFluid);
        placementStrategies.put(AEKeyType.fluids(), FluidPlacementStrategy::new);
        placementStrategies.put(AEKeyType.items(), ItemPlacementStrategy::new);
        pickupStrategies.put(AEKeyType.fluids(), FluidPickupStrategy::new);
        pickupStrategies.put(AEKeyType.items(), ItemPickupStrategy::new);
    }

    @FunctionalInterface
    static interface ImportStrategyFactory {
        public StackImportStrategy create(class_3218 var1, class_2338 var2, class_2350 var3);
    }

    @FunctionalInterface
    static interface ExportStrategyFactory {
        public StackExportStrategy create(class_3218 var1, class_2338 var2, class_2350 var3);
    }

    @FunctionalInterface
    static interface ExternalStorageStrategyFactory {
        public ExternalStorageStrategy create(class_3218 var1, class_2338 var2, class_2350 var3);
    }

    @FunctionalInterface
    static interface PlacementStrategyFactory {
        public PlacementStrategy create(class_3218 var1, class_2338 var2, class_2350 var3, class_2586 var4);
    }

    @FunctionalInterface
    static interface PickupStrategyFactory {
        public PickupStrategy create(class_3218 var1, class_2338 var2, class_2350 var3, class_2586 var4, boolean var5);
    }
}

