/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.entropy.EntropyRecipeBuilder;
import appeng.recipes.entropy.MultipleValuesMatcher;
import appeng.recipes.entropy.RangeValueMatcher;
import appeng.recipes.entropy.SingleValueMatcher;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;

public class EntropyRecipeSerializer
implements class_1865<EntropyRecipe> {
    public static final EntropyRecipeSerializer INSTANCE = new EntropyRecipeSerializer();

    private EntropyRecipeSerializer() {
    }

    public EntropyRecipe fromJson(class_2960 recipeId, JsonObject json) {
        JsonObject outputFluidObject;
        String outputFluidId;
        JsonObject outputJson;
        JsonObject outputBlockObject;
        String outputBlockId;
        JsonObject inputFluidObject;
        String inputFluidId;
        EntropyRecipeBuilder builder = new EntropyRecipeBuilder();
        builder.setId(recipeId);
        builder.setMode(EntropyMode.valueOf(class_3518.method_15265((JsonObject)json, (String)"mode").toUpperCase(Locale.ROOT)));
        JsonObject inputJson = class_3518.method_15296((JsonObject)json, (String)"input");
        JsonObject inputBlockObject = class_3518.method_15281((JsonObject)inputJson, (String)"block", (JsonObject)new JsonObject());
        String inputBlockId = class_3518.method_15253((JsonObject)inputBlockObject, (String)"id", null);
        if (inputBlockId != null) {
            class_2248 block = (class_2248)EntropyRecipeSerializer.getRequiredEntry(class_2378.field_11146, inputBlockId);
            builder.setInputBlock(block);
            EntropyRecipeSerializer.parseStateMatchers(block.method_9595(), inputBlockObject, builder::addBlockStateMatcher);
        }
        if ((inputFluidId = class_3518.method_15253((JsonObject)(inputFluidObject = class_3518.method_15281((JsonObject)inputJson, (String)"fluid", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            class_3611 fluid = (class_3611)EntropyRecipeSerializer.getRequiredEntry(class_2378.field_11154, inputFluidId);
            builder.setInputFluid(fluid);
            EntropyRecipeSerializer.parseStateMatchers(fluid.method_15783(), inputFluidObject, builder::addFluidStateMatcher);
        }
        if ((outputBlockId = class_3518.method_15253((JsonObject)(outputBlockObject = class_3518.method_15281((JsonObject)(outputJson = class_3518.method_15296((JsonObject)json, (String)"output")), (String)"block", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            class_2248 block = (class_2248)EntropyRecipeSerializer.getRequiredEntry(class_2378.field_11146, outputBlockId);
            builder.setOutputBlock(block);
            boolean outputBlockKeep = class_3518.method_15258((JsonObject)outputBlockObject, (String)"keep", (boolean)false);
            builder.setOutputBlockKeep(outputBlockKeep);
            EntropyRecipeSerializer.parseStateAppliers(block.method_9595(), outputBlockObject, builder::addBlockStateAppliers);
        }
        if ((outputFluidId = class_3518.method_15253((JsonObject)(outputFluidObject = class_3518.method_15281((JsonObject)outputJson, (String)"fluid", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            class_3611 fluid = (class_3611)EntropyRecipeSerializer.getRequiredEntry(class_2378.field_11154, outputFluidId);
            builder.setOutputFluid(fluid);
            boolean outputFluidKeep = class_3518.method_15258((JsonObject)outputFluidObject, (String)"keep", (boolean)false);
            builder.setOutputFluidKeep(outputFluidKeep);
            EntropyRecipeSerializer.parseStateAppliers(fluid.method_15783(), outputFluidObject, builder::addFluidStateAppliers);
        }
        if (outputJson.has("drops")) {
            JsonArray dropList = class_3518.method_15261((JsonObject)outputJson, (String)"drops");
            ArrayList<class_1799> drops = new ArrayList<class_1799>(dropList.size());
            for (JsonElement jsonElement : dropList) {
                JsonObject object = jsonElement.getAsJsonObject();
                String itemid = class_3518.method_15265((JsonObject)object, (String)"item");
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(itemid));
                int count = class_3518.method_15282((JsonObject)object, (String)"count", (int)1);
                drops.add(new class_1799((class_1935)item, count));
            }
            builder.setDrops(drops);
        }
        return builder.build();
    }

    private static <T> T getRequiredEntry(class_2378<T> registry, String id) {
        T entry = registry.method_17966(new class_2960(id)).orElse(null);
        if (entry == null) {
            throw new IllegalArgumentException("Unknown id " + id + " for " + registry);
        }
        return entry;
    }

    @Nullable
    public EntropyRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
        int dropSize;
        int appliersSize;
        class_3611 fluid;
        int i;
        int matcherSize;
        EntropyRecipeBuilder builder = new EntropyRecipeBuilder();
        builder.setId(recipeId);
        builder.setMode((EntropyMode)buffer.method_10818(EntropyMode.class));
        if (buffer.readBoolean()) {
            class_2248 inputBlock = (class_2248)class_2378.field_11146.method_10200(buffer.method_10816());
            builder.setInputBlock(inputBlock);
            matcherSize = buffer.readInt();
            for (i = 0; i < matcherSize; ++i) {
                builder.addBlockStateMatcher(StateMatcher.read(inputBlock.method_9595(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            fluid = (class_3611)class_2378.field_11154.method_10200(buffer.method_10816());
            builder.setInputFluid(fluid);
            matcherSize = buffer.readInt();
            for (i = 0; i < matcherSize; ++i) {
                builder.addFluidStateMatcher(StateMatcher.read(fluid.method_15783(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            class_2248 block = (class_2248)class_2378.field_11146.method_10200(buffer.method_10816());
            builder.setOutputBlock(block);
            builder.setOutputBlockKeep(buffer.readBoolean());
            appliersSize = buffer.readInt();
            for (i = 0; i < appliersSize; ++i) {
                builder.addBlockStateAppliers(StateApplier.readFromPacket(block.method_9595(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            fluid = (class_3611)class_2378.field_11154.method_10200(buffer.method_10816());
            builder.setOutputFluid(fluid);
            builder.setOutputFluidKeep(buffer.readBoolean());
            appliersSize = buffer.readInt();
            for (i = 0; i < appliersSize; ++i) {
                builder.addFluidStateAppliers(StateApplier.readFromPacket(fluid.method_15783(), buffer));
            }
        }
        if ((dropSize = buffer.readInt()) > 0) {
            ArrayList<class_1799> drops = new ArrayList<class_1799>(dropSize);
            for (i = 0; i < dropSize; ++i) {
                drops.add(buffer.method_10819());
            }
            builder.setDrops(drops);
        }
        return builder.build();
    }

    public void toNetwork(class_2540 buffer, EntropyRecipe recipe) {
        List<StateApplier<?>> appliers;
        buffer.method_10817((Enum)recipe.getMode());
        buffer.writeBoolean(recipe.getInputBlock() != null);
        if (recipe.getInputBlock() != null) {
            buffer.method_10804(class_2378.field_11146.method_10206((Object)recipe.getInputBlock()));
            List<StateMatcher> inputBlockMatchers = recipe.getInputBlockMatchers();
            buffer.writeInt(inputBlockMatchers.size());
            for (StateMatcher stateMatcher : inputBlockMatchers) {
                stateMatcher.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getInputFluid() != null);
        if (recipe.getInputFluid() != null) {
            buffer.method_10804(class_2378.field_11154.method_10206((Object)recipe.getInputFluid()));
            List<StateMatcher> inputFluidMatchers = recipe.getInputFluidMatchers();
            buffer.writeInt(inputFluidMatchers.size());
            for (StateMatcher stateMatcher : inputFluidMatchers) {
                stateMatcher.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getOutputBlock() != null);
        if (recipe.getOutputBlock() != null) {
            buffer.method_10804(class_2378.field_11146.method_10206((Object)recipe.getOutputBlock()));
            buffer.writeBoolean(recipe.getOutputBlockKeep());
            appliers = recipe.getOutputBlockStateAppliers();
            buffer.writeInt(appliers.size());
            for (StateApplier stateApplier : appliers) {
                stateApplier.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getOutputFluid() != null);
        if (recipe.getOutputFluid() != null) {
            buffer.method_10804(class_2378.field_11154.method_10206((Object)recipe.getOutputFluid()));
            buffer.writeBoolean(recipe.getOutputFluidKeep());
            appliers = recipe.getOutputFluidStateAppliers();
            buffer.writeInt(appliers.size());
            for (StateApplier stateApplier : appliers) {
                stateApplier.writeToPacket(buffer);
            }
        }
        buffer.writeInt(recipe.getDrops().size());
        for (class_1799 itemStack : recipe.getDrops()) {
            buffer.method_10793(itemStack);
        }
    }

    private static void parseStateMatchers(class_2689<?, ?> stateDefinition, JsonObject propertiesContainer, Consumer<StateMatcher> consumer) {
        JsonObject properties = class_3518.method_15281((JsonObject)propertiesContainer, (String)"properties", (JsonObject)new JsonObject());
        properties.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value == null) {
                return;
            }
            if (value.isJsonPrimitive()) {
                consumer.accept(SingleValueMatcher.create(stateDefinition, key, value.getAsString()));
            } else if (value.isJsonArray()) {
                JsonArray array = value.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (JsonElement e : array) {
                    list.add(e.getAsString());
                }
                consumer.accept(MultipleValuesMatcher.create(stateDefinition, key, list));
            } else if (value.isJsonObject() && value.getAsJsonObject().has("min") && value.getAsJsonObject().has("max")) {
                String min = value.getAsJsonObject().get("min").getAsString();
                String max = value.getAsJsonObject().get("max").getAsString();
                consumer.accept(RangeValueMatcher.create(stateDefinition, key, min, max));
            } else {
                throw new IllegalArgumentException("Invalid matcher: " + value);
            }
        });
    }

    private static void parseStateAppliers(class_2689<?, ?> stateDefinition, JsonObject propertiesContainer, Consumer<StateApplier<?>> consumer) {
        JsonObject properties = class_3518.method_15281((JsonObject)propertiesContainer, (String)"properties", (JsonObject)new JsonObject());
        properties.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(StateApplier.create(stateDefinition, key, value));
        });
    }

    public void toJson(EntropyRecipe recipe, JsonObject json) {
        json.addProperty("mode", recipe.getMode().name().toLowerCase(Locale.ROOT));
        json.add("input", (JsonElement)this.serializeInput(recipe));
        json.add("output", this.serializeOutput(recipe));
    }

    private JsonObject serializeInput(EntropyRecipe recipe) {
        JsonObject input = new JsonObject();
        if (recipe.getInputBlock() != null) {
            JsonObject jsonBlock = new JsonObject();
            jsonBlock.addProperty("id", class_2378.field_11146.method_10221((Object)recipe.getInputBlock()).toString());
            this.serializeStateMatchers(recipe.getInputBlockMatchers(), jsonBlock);
            input.add("block", (JsonElement)jsonBlock);
        }
        if (recipe.getInputFluid() != null) {
            JsonObject jsonFluid = new JsonObject();
            jsonFluid.addProperty("id", class_2378.field_11154.method_10221((Object)recipe.getInputFluid()).toString());
            this.serializeStateMatchers(recipe.getInputFluidMatchers(), jsonFluid);
            input.add("fluid", (JsonElement)jsonFluid);
        }
        return input;
    }

    private JsonElement serializeOutput(EntropyRecipe recipe) {
        JsonObject output = new JsonObject();
        if (recipe.getOutputBlock() != null) {
            JsonObject jsonBlock = new JsonObject();
            jsonBlock.addProperty("id", class_2378.field_11146.method_10221((Object)recipe.getOutputBlock()).toString());
            if (recipe.getOutputBlockKeep()) {
                jsonBlock.addProperty("keep", Boolean.valueOf(true));
            }
            this.serializeStateAppliers(recipe.getOutputBlockStateAppliers(), jsonBlock);
            output.add("block", (JsonElement)jsonBlock);
        }
        if (recipe.getOutputFluid() != null) {
            JsonObject jsonFluid = new JsonObject();
            jsonFluid.addProperty("id", class_2378.field_11154.method_10221((Object)recipe.getOutputFluid()).toString());
            if (recipe.getOutputFluidKeep()) {
                jsonFluid.addProperty("keep", Boolean.valueOf(true));
            }
            this.serializeStateAppliers(recipe.getOutputFluidStateAppliers(), jsonFluid);
            output.add("fluid", (JsonElement)jsonFluid);
        }
        if (!recipe.getDrops().isEmpty()) {
            JsonArray jsonDrops = new JsonArray();
            for (class_1799 drop : recipe.getDrops()) {
                JsonObject jsonDrop = new JsonObject();
                jsonDrop.addProperty("item", class_2378.field_11142.method_10221((Object)drop.method_7909()).toString());
                if (drop.method_7947() > 1) {
                    jsonDrop.addProperty("count", (Number)drop.method_7947());
                }
                jsonDrops.add((JsonElement)jsonDrop);
            }
            output.add("drops", (JsonElement)jsonDrops);
        }
        return output;
    }

    private void serializeStateMatchers(List<StateMatcher> matchers, JsonObject json) {
        if (matchers.isEmpty()) {
            return;
        }
        JsonObject properties = new JsonObject();
        for (StateMatcher matcher : matchers) {
            JsonPrimitive serializedMatcher;
            if (matcher instanceof SingleValueMatcher) {
                SingleValueMatcher singleMatcher = (SingleValueMatcher)matcher;
                serializedMatcher = new JsonPrimitive(singleMatcher.getValueName());
            } else if (matcher instanceof MultipleValuesMatcher) {
                MultipleValuesMatcher multiMatcher = (MultipleValuesMatcher)matcher;
                JsonArray values = new JsonArray();
                for (String valueName : multiMatcher.getValueNames()) {
                    values.add(valueName);
                }
                serializedMatcher = values;
            } else if (matcher instanceof RangeValueMatcher) {
                RangeValueMatcher rangeMatcher = (RangeValueMatcher)matcher;
                JsonObject range = new JsonObject();
                range.addProperty("min", rangeMatcher.getMinValueName());
                range.addProperty("max", rangeMatcher.getMaxValueName());
                serializedMatcher = range;
            } else {
                throw new IllegalStateException("Don't know how to serialize state matcher " + matcher);
            }
            String propertyName = matcher.getProperty().method_11899();
            properties.add(propertyName, (JsonElement)serializedMatcher);
        }
        json.add("properties", (JsonElement)properties);
    }

    private void serializeStateAppliers(List<StateApplier<?>> appliers, JsonObject json) {
        if (appliers.isEmpty()) {
            return;
        }
        JsonObject properties = new JsonObject();
        for (StateApplier<?> applier : appliers) {
            class_2769<?> property = applier.getProperty();
            properties.addProperty(property.method_11899(), applier.getValueName());
        }
        json.add("properties", (JsonElement)properties);
    }
}

