/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.server.ISubCommand;
import appeng.worldgen.meteorite.MeteoriteStructure;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import com.google.common.math.StatsAccumulator;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class TestMeteoritesCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"force").executes(ctx -> {
            TestMeteoritesCommand.test(((class_2168)ctx.getSource()).method_9211(), (class_2168)ctx.getSource(), true);
            return 1;
        }));
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<class_2168> ctx, class_2168 sender) {
        TestMeteoritesCommand.test(srv, sender, false);
    }

    private static void test(MinecraftServer srv, class_2168 sender, boolean force) {
        class_2338 centerBlock;
        class_3218 level;
        int radius = 100;
        class_3222 player = null;
        try {
            player = sender.method_9207();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (player != null) {
            level = player.method_14220();
            centerBlock = new class_2338(player.method_23317(), 0.0, player.method_23321());
        } else {
            level = srv.method_3847(class_1937.field_25179);
            centerBlock = level.method_27911();
        }
        class_1923 center = new class_1923(centerBlock);
        class_2794 generator = level.method_14178().method_12129();
        ArrayList<PlacedMeteoriteSettings> found = new ArrayList<PlacedMeteoriteSettings>();
        int chunksChecked = 0;
        for (int cx = center.field_9181 - radius; cx <= center.field_9181 + radius; ++cx) {
            for (int cz = center.field_9180 - radius; cz <= center.field_9180 + radius; ++cz) {
                class_2791 chunk;
                MeteoriteStructurePiece piece;
                ++chunksChecked;
                class_1923 cp = new class_1923(cx, cz);
                class_2338 p = new class_2338(cp.method_8326(), 0, cp.method_8328());
                class_2338 nearest = generator.method_12103(level, MeteoriteStructure.INSTANCE, p, 0, false);
                if (nearest == null || (piece = TestMeteoritesCommand.getMeteoritePieceFromChunk(chunk = level.method_22342(cx, cz, class_2806.field_16423))) == null) continue;
                found.add(piece.getSettings());
            }
        }
        StatsAccumulator stats = new StatsAccumulator();
        for (PlacedMeteoriteSettings settings2 : found) {
            double closestOther = Double.NaN;
            for (PlacedMeteoriteSettings otherSettings : found) {
                if (otherSettings == settings2) continue;
                double d = settings2.getPos().method_10262((class_2382)otherSettings.getPos());
                if (!Double.isNaN(closestOther) && !(d < closestOther)) continue;
                closestOther = d;
            }
            if (Double.isNaN(closestOther)) continue;
            stats.add(Math.sqrt(closestOther));
        }
        found.sort(Comparator.comparingDouble(settings -> settings.getPos().method_10262((class_2382)centerBlock)));
        TestMeteoritesCommand.sendLine(sender, "Chunks checked: %d", chunksChecked);
        TestMeteoritesCommand.sendLine(sender, "Meteorites found: %d", found.size());
        if (stats.count() > 0L) {
            TestMeteoritesCommand.sendLine(sender, "Closest: min=%.2f max=%.2f mean=%.2f stddev=%.2f", stats.min(), stats.max(), stats.mean(), stats.populationStandardDeviation());
        }
        int closestCount = Math.min(10, found.size());
        for (int i = 0; i < closestCount; ++i) {
            PlacedMeteoriteSettings settings3 = (PlacedMeteoriteSettings)found.get(i);
            class_2338 pos = settings3.getPos();
            String state = "not final";
            if (force && settings3.getFallout() == null) {
                class_2791 chunk = level.method_22350(pos);
                MeteoriteStructurePiece piece = TestMeteoritesCommand.getMeteoritePieceFromChunk(chunk);
                if (piece == null) {
                    state = "removed";
                } else {
                    settings3 = piece.getSettings();
                    pos = settings3.getPos();
                }
            }
            class_2585 restOfLine = settings3.getFallout() == null ? new class_2585(String.format(Locale.ROOT, ", radius=%.2f [%s]", Float.valueOf(settings3.getMeteoriteRadius()), state)) : new class_2585(String.format(Locale.ROOT, ", radius=%.2f, crater=%s, fallout=%s", Float.valueOf(settings3.getMeteoriteRadius()), settings3.getCraterType().name().toLowerCase(), settings3.getFallout().name().toLowerCase()));
            class_2585 msg = new class_2585(" #" + (i + 1) + " ");
            msg.method_10852(TestMeteoritesCommand.getClickablePosition(level, settings3, pos)).method_10852((class_2561)restOfLine);
            String biomeId = level.method_31081(pos).map(bk -> bk.method_29177().toString()).orElse("unknown");
            class_5250 tooltip = new class_2585(settings3 + "\nBiome: ").method_27661().method_27693(biomeId);
            msg.method_27694(arg_0 -> TestMeteoritesCommand.lambda$test$3((class_2561)tooltip, arg_0));
            sender.method_9226((class_2561)msg, true);
        }
    }

    private static class_2561 getClickablePosition(class_3218 level, PlacedMeteoriteSettings settings, class_2338 pos) {
        class_2338 tpPos = pos.method_10086((int)Math.ceil(settings.getMeteoriteRadius()));
        int surfaceY = level.method_8598(class_2902.class_2903.field_13202, tpPos).method_10264();
        if (surfaceY > tpPos.method_10264()) {
            tpPos = new class_2338(tpPos.method_10263(), surfaceY, tpPos.method_10260());
        }
        String displayText = String.format(Locale.ROOT, "pos=%d,%d,%d", tpPos.method_10263(), tpPos.method_10264(), tpPos.method_10260());
        String tpCommand = String.format(Locale.ROOT, "/tp @s %d %d %d", tpPos.method_10263(), tpPos.method_10264(), tpPos.method_10260());
        return new class_2585(displayText).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, tpCommand)));
    }

    private static MeteoriteStructurePiece getMeteoritePieceFromChunk(class_2791 chunk) {
        class_3449 start = chunk.method_12181(MeteoriteStructure.INSTANCE);
        if (start != null && start.method_14963().size() > 0 && start.method_14963().get(0) instanceof MeteoriteStructurePiece) {
            return (MeteoriteStructurePiece)((Object)start.method_14963().get(0));
        }
        return null;
    }

    private static void sendLine(class_2168 sender, String text, Object ... args) {
        sender.method_9226((class_2561)new class_2585(String.format(Locale.ROOT, text, args)), true);
    }

    private static /* synthetic */ class_2583 lambda$test$3(class_2561 tooltip, class_2583 style) {
        return style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)tooltip));
    }
}

