/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.file.Path;
import net.minecraft.class_1011;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_308;
import net.minecraft.class_4587;
import net.minecraft.class_6367;
import net.minecraft.class_758;

public class OffScreenRenderer
implements AutoCloseable {
    private final class_1011 nativeImage;
    private final class_6367 fb;
    private final int width;
    private final int height;

    public OffScreenRenderer(int width, int height) {
        this.width = width;
        this.height = height;
        this.nativeImage = new class_1011(width, height, true);
        this.fb = new class_6367(width, height, true, true);
        this.fb.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.fb.method_1230(true);
    }

    @Override
    public void close() {
        this.nativeImage.close();
        this.fb.method_1238();
    }

    public void captureAsPng(Runnable r, Path path) throws IOException {
        this.fb.method_1235(true);
        GlStateManager._clear((int)16640, (boolean)false);
        r.run();
        this.fb.method_1240();
        this.fb.method_35610();
        this.nativeImage.method_4327(0, false);
        this.nativeImage.method_4319();
        this.fb.method_1242();
        this.nativeImage.method_4314(path);
    }

    public void setupItemRendering() {
        RenderSystem.setProjectionMatrix((class_1159)class_1159.method_34239((float)0.0f, (float)16.0f, (float)0.0f, (float)16.0f, (float)1000.0f, (float)3000.0f));
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_34426();
        poseStack.method_22904(0.0, 0.0, -2000.0);
        class_308.method_24210();
        RenderSystem.applyModelViewMatrix();
        class_758.method_23792();
    }

    public void setupOrtographicRendering() {
        float angle = 36.0f;
        float renderHeight = 0.0f;
        float renderScale = 100.0f;
        float rotation = 45.0f;
        RenderSystem.setProjectionMatrix((class_1159)class_1159.method_34239((float)-1.0f, (float)1.0f, (float)1.0f, (float)-1.0f, (float)1000.0f, (float)3000.0f));
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_34426();
        poseStack.method_22904(0.0, 0.0, -2000.0);
        class_758.method_23792();
        poseStack.method_22905(1.0f, -1.0f, -1.0f);
        poseStack.method_22907(class_1160.field_20705.method_23214(-180.0f));
        class_1158 flip = class_1160.field_20707.method_23214(180.0f);
        flip.method_4925(class_1160.field_20703.method_23214(angle));
        poseStack.method_22904(0.0, (double)renderHeight / -300.0, 0.0);
        poseStack.method_22905(renderScale * 0.004f, renderScale * 0.004f, 1.0f);
        class_1158 rotate = class_1160.field_20705.method_23214(rotation);
        poseStack.method_22907(flip);
        poseStack.method_22907(rotate);
        RenderSystem.applyModelViewMatrix();
        class_308.method_27869((class_1159)poseStack.method_23760().method_23761());
    }

    public void setupPerspectiveRendering(float zoom, float fov, class_1160 eyePos, class_1160 lookAt) {
        float aspectRatio = (float)this.width / (float)this.height;
        class_4587 projMat = new class_4587();
        if (zoom != 1.0f) {
            projMat.method_22905(zoom, zoom, 1.0f);
        }
        projMat.method_34425(class_1159.method_4929((double)fov, (float)aspectRatio, (float)0.05f, (float)16.0f));
        RenderSystem.setProjectionMatrix((class_1159)projMat.method_23760().method_23761());
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_34426();
        class_1159 vm = OffScreenRenderer.createViewMatrix(eyePos, lookAt);
        poseStack.method_34425(vm);
        RenderSystem.applyModelViewMatrix();
        class_308.method_27869((class_1159)poseStack.method_23760().method_23761());
    }

    private static class_1159 createViewMatrix(class_1160 eyePos, class_1160 lookAt) {
        class_1160 dir = lookAt.method_23850();
        dir.method_4944(eyePos);
        class_1160 up = new class_1160(0.0f, 1.0f, 0.0f);
        dir.method_4952();
        class_1160 right = dir.method_23850();
        right.method_4951(up);
        right.method_4952();
        up = right.method_23850();
        up.method_4951(dir);
        up.method_4952();
        class_1159 viewMatrix = new class_1159();
        viewMatrix.method_35438(FloatBuffer.wrap(new float[]{right.method_4943(), right.method_4945(), right.method_4947(), 0.0f, up.method_4943(), up.method_4945(), up.method_4947(), 0.0f, -dir.method_4943(), -dir.method_4945(), -dir.method_4947(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}));
        viewMatrix.method_31544(-eyePos.method_4943(), -eyePos.method_4945(), -eyePos.method_4947());
        return viewMatrix;
    }
}

