/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.inventories.BaseInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;

public class AppEngInternalInventory
extends BaseInternalInventory {
    private boolean enableClientEvents = false;
    private InternalInventoryHost host;
    private final class_2371<class_1799> stacks;
    private final int[] maxStack;
    private IAEItemFilter filter;
    private boolean notifyingChanges = false;

    public AppEngInternalInventory(InternalInventoryHost host, int size, int maxStack, IAEItemFilter filter) {
        this.setHost(host);
        this.setFilter(filter);
        this.maxStack = new int[size];
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        Arrays.fill(this.maxStack, maxStack);
    }

    public AppEngInternalInventory(@Nullable InternalInventoryHost inventory, int size, int maxStack) {
        this(inventory, size, maxStack, null);
    }

    public AppEngInternalInventory(int size) {
        this(null, size, 64);
    }

    public AppEngInternalInventory(@Nullable InternalInventoryHost inventory, int size) {
        this(inventory, size, 64);
    }

    public void setFilter(IAEItemFilter filter) {
        this.filter = filter;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.maxStack[slot];
    }

    @Override
    public class_1799 getStackInSlot(int slotIndex) {
        return (class_1799)this.stacks.get(slotIndex);
    }

    @Override
    public void setItemDirect(int slot, class_1799 stack) {
        this.stacks.set(slot, (Object)stack);
        this.notifyContentsChanged(slot);
    }

    private void notifyContentsChanged(int slot) {
        if (Transaction.isOpen()) {
            return;
        }
        this.onContentsChanged(slot);
    }

    @Override
    public void sendChangeNotification(int slot) {
        this.onContentsChanged(slot);
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        Preconditions.checkArgument((slot >= 0 && slot < this.size() ? 1 : 0) != 0, (Object)"slot out of range");
        if (this.filter != null && !this.filter.allowExtract(this, slot, amount)) {
            return class_1799.field_8037;
        }
        class_1799 stack = (class_1799)this.stacks.get(slot);
        int toExtract = Math.min(stack.method_7947(), Math.min(amount, stack.method_7914()));
        if (toExtract <= 0) {
            return class_1799.field_8037;
        }
        if (stack.method_7947() <= toExtract) {
            if (!simulate) {
                this.setItemDirect(slot, class_1799.field_8037);
                this.notifyContentsChanged(slot);
                return stack;
            }
            return stack.method_7972();
        }
        class_1799 result = stack.method_7972();
        if (!simulate) {
            stack.method_7934(toExtract);
            this.notifyContentsChanged(slot);
        }
        result.method_7939(toExtract);
        return result;
    }

    protected void onContentsChanged(int slot) {
        if (this.host != null && this.eventsEnabled() && !this.notifyingChanges) {
            this.notifyingChanges = true;
            this.host.onChangeInventory(this, slot);
            this.host.saveChanges();
            this.notifyingChanges = false;
        }
    }

    protected boolean eventsEnabled() {
        return this.host != null && !this.host.isClientSide() || this.isEnableClientEvents();
    }

    public void setMaxStackSize(int slot, int size) {
        this.maxStack[slot] = size;
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        if (this.maxStack[slot] == 0) {
            return false;
        }
        if (this.filter != null) {
            return this.filter.allowInsert(this, slot, stack);
        }
        return true;
    }

    public void writeToNBT(class_2487 data, String name) {
        if (this.isEmpty()) {
            data.method_10551(name);
            return;
        }
        class_2499 items = new class_2499();
        for (int i = 0; i < this.stacks.size(); ++i) {
            class_1799 stack = (class_1799)this.stacks.get(i);
            if (stack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            items.add((Object)stack.method_7953(itemTag));
        }
        data.method_10566(name, (class_2520)items);
    }

    public void readFromNBT(class_2487 data, String name) {
        if (data.method_10573(name, 9)) {
            class_2499 tagList = data.method_10554(name, 10);
            for (class_2520 itemTag : tagList) {
                class_2487 itemCompound = (class_2487)itemTag;
                int slot = itemCompound.method_10550("Slot");
                if (slot < 0 || slot >= this.stacks.size()) continue;
                this.stacks.set(slot, (Object)class_1799.method_7915((class_2487)itemCompound));
            }
        }
    }

    private boolean isEnableClientEvents() {
        return this.enableClientEvents;
    }

    public void setEnableClientEvents(boolean enableClientEvents) {
        this.enableClientEvents = enableClientEvents;
    }

    @ApiStatus.Internal
    public InternalInventoryHost getHost() {
        return this.host;
    }

    protected final void setHost(InternalInventoryHost host) {
        this.host = host;
    }

    @Override
    public int size() {
        return this.stacks.size();
    }
}

