/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.hookshot.common.entity;

import dev.cammiescorner.hookshot.Hookshot;
import dev.cammiescorner.hookshot.common.item.HookshotItem;
import dev.cammiescorner.hookshot.core.registry.ModDamageSource;
import dev.cammiescorner.hookshot.core.registry.ModEntities;
import dev.cammiescorner.hookshot.core.registry.ModSoundEvents;
import dev.cammiescorner.hookshot.core.util.PlayerProperties;
import dev.cammiescorner.hookshot.core.util.UpgradesHelper;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class HookshotEntity
extends class_1665 {
    private static final class_3494<class_2248> UNHOOKABLE = TagRegistry.block((class_2960)new class_2960("hookshot", "unhookable"));
    private static final class_2940<Integer> HOOKED_ENTITY_ID = class_2945.method_12791(HookshotEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Float> FORCED_YAW = class_2945.method_12791(HookshotEntity.class, (class_2941)class_2943.field_13320);
    private double maxRange = 0.0;
    private double maxSpeed = 0.0;
    private boolean isPulling = false;
    private class_1297 hookedEntity;
    private class_1799 stack;

    public HookshotEntity(class_1299<? extends class_1665> type, class_1657 owner, class_1937 world) {
        super(type, (class_1309)owner, world);
        this.method_5875(true);
        this.method_7438(0.0);
    }

    public HookshotEntity(class_1937 world, double x, double y, double z) {
        super(ModEntities.HOOKSHOT_ENTITY, x, y, z, world);
        this.method_5875(true);
        this.method_7438(0.0);
    }

    public HookshotEntity(class_1937 world) {
        super(ModEntities.HOOKSHOT_ENTITY, world);
        this.method_5875(true);
        this.method_7438(0.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(HOOKED_ENTITY_ID, (Object)0);
        this.method_5841().method_12784(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public void method_5773() {
        super.method_5773();
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            class_1657 owner = (class_1657)class_12972;
            this.method_36456(((Float)this.field_6011.method_12789(FORCED_YAW)).floatValue());
            if (this.isPulling && this.field_6012 % 2 == 0) {
                this.field_6002.method_8396(null, this.method_24921().method_24515(), ModSoundEvents.HOOKSHOT_REEL, class_3419.field_15248, 1.0f, 1.0f);
            }
            if (!this.field_6002.field_9236) {
                if (owner.method_29504() || !((PlayerProperties)owner).hasHook() || !((PlayerProperties)owner).hasHook() || (double)owner.method_5739((class_1297)this) > this.maxRange || !(owner.method_6047().method_7909() instanceof HookshotItem) && !(owner.method_6079().method_7909() instanceof HookshotItem) || !((PlayerProperties)owner).hasHook()) {
                    this.method_5768();
                }
                if (this.hookedEntity != null) {
                    if (this.hookedEntity.method_31481()) {
                        this.hookedEntity = null;
                        this.method_36209();
                    } else {
                        if (UpgradesHelper.hasBleedUpgrade(this.stack) && this.field_6012 % 20 == 0) {
                            this.hookedEntity.method_5643(ModDamageSource.bleed(this, (class_1297)owner), 1.0f);
                        }
                        this.method_30634(this.hookedEntity.method_23317(), this.hookedEntity.method_23323(0.8), this.hookedEntity.method_23321());
                    }
                }
                if (owner.method_6047() == this.stack || owner.method_6079() == this.stack) {
                    if (this.isPulling) {
                        class_1657 target = owner;
                        HookshotEntity origin = this;
                        if (owner.method_5715() && this.hookedEntity != null) {
                            target = this.hookedEntity;
                            origin = owner;
                        }
                        double brakeZone = 6.0 * ((Hookshot.config.quickModAffectsPullSpeed ? this.maxSpeed : Hookshot.config.defaultMaxSpeed) / Hookshot.config.defaultMaxSpeed);
                        double pullSpeed = (Hookshot.config.quickModAffectsPullSpeed ? this.maxSpeed : Hookshot.config.defaultMaxSpeed) / 6.0;
                        class_243 distance = origin.method_19538().method_1020(target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0));
                        class_243 motion = distance.method_1029().method_1021(distance.method_1033() < brakeZone && !UpgradesHelper.hasAutomaticUpgrade(this.stack) ? pullSpeed * distance.method_1033() / brakeZone : pullSpeed);
                        if (Math.abs(distance.field_1351) < 0.1) {
                            motion = new class_243(motion.field_1352, 0.0, motion.field_1350);
                        }
                        class_243 class_2432 = new class_243(distance.field_1352, 0.0, distance.field_1350);
                        class_243 class_2433 = new class_243((double)(target.method_17681() / 2.0f), 0.0, (double)(target.method_17681() / 2.0f));
                        if (class_2432.method_1033() < class_2433.method_1033() / 1.4) {
                            motion = new class_243(0.0, motion.field_1351, 0.0);
                        }
                        if (Hookshot.config.hookshotCancelsFallDamage) {
                            target.field_6017 = 0.0f;
                        }
                        target.method_18799(motion);
                        target.field_6037 = true;
                        if (UpgradesHelper.hasAutomaticUpgrade(this.stack) && (double)owner.method_5739((class_1297)this) <= 3.0) {
                            this.method_5768();
                        }
                        if (this.stack.method_7936() > 0 && this.field_6012 % 20 == 0) {
                            this.stack.method_7956(1, (class_1309)owner, entity -> entity.method_20236(owner.method_6058()));
                        }
                    }
                } else {
                    this.method_5768();
                }
            }
        } else {
            this.method_5768();
        }
    }

    public void method_5768() {
        class_1297 class_12972;
        if (!this.field_6002.field_9236 && (class_12972 = this.method_24921()) instanceof class_1657) {
            class_1657 owner = (class_1657)class_12972;
            ((PlayerProperties)owner).setHasHook(false);
            owner.method_5875(false);
        }
        super.method_5768();
    }

    public boolean method_5640(double distance) {
        return true;
    }

    protected float method_7436() {
        if (!this.field_6002.field_9236) {
            if (UpgradesHelper.hasAquaticUpgrade(this.stack)) {
                return 0.99f;
            }
            return super.method_7436();
        }
        return super.method_7436();
    }

    public boolean method_5822() {
        return false;
    }

    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    protected void method_24920(class_3965 blockHitResult) {
        class_1297 class_12972;
        super.method_24920(blockHitResult);
        this.isPulling = true;
        if (!this.field_6002.field_9236 && (class_12972 = this.method_24921()) instanceof class_1657) {
            class_1657 owner = (class_1657)class_12972;
            if (this.hookedEntity == null) {
                owner.method_5875(true);
                if (Hookshot.config.unhookableBlacklist) {
                    if (UNHOOKABLE.method_15141((Object)this.field_6002.method_8320(blockHitResult.method_17777()).method_26204())) {
                        ((PlayerProperties)owner).setHasHook(false);
                        this.isPulling = false;
                        this.method_36209();
                    } else if (UpgradesHelper.hasEndericUpgrade(this.stack)) {
                        owner.method_5859(this.method_23317(), this.method_23318(), this.method_23321());
                        ((PlayerProperties)owner).setHasHook(false);
                        owner.field_6017 = 0.0f;
                        this.isPulling = false;
                        this.method_36209();
                    }
                } else if (!UNHOOKABLE.method_15141((Object)this.field_6002.method_8320(blockHitResult.method_17777()).method_26204())) {
                    ((PlayerProperties)owner).setHasHook(false);
                    this.isPulling = false;
                    this.method_36209();
                } else if (UpgradesHelper.hasEndericUpgrade(this.stack)) {
                    owner.method_5859(this.method_23317(), this.method_23318(), this.method_23321());
                    ((PlayerProperties)owner).setHasHook(false);
                    owner.field_6017 = 0.0f;
                    this.isPulling = false;
                    this.method_36209();
                }
            }
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 class_12972;
        if (!this.field_6002.field_9236 && (class_12972 = this.method_24921()) instanceof class_1657) {
            class_1657 owner = (class_1657)class_12972;
            if (entityHitResult.method_17782() != owner) {
                if ((entityHitResult.method_17782() instanceof class_1309 || entityHitResult.method_17782() instanceof class_1508) && this.hookedEntity == null) {
                    this.hookedEntity = entityHitResult.method_17782();
                    this.field_6011.method_12778(HOOKED_ENTITY_ID, (Object)(this.hookedEntity.method_5628() + 1));
                    this.isPulling = true;
                }
                if (this.hookedEntity != null && UpgradesHelper.hasBleedUpgrade(this.stack)) {
                    this.hookedEntity.method_5643(ModDamageSource.bleed(this, (class_1297)owner), 1.0f);
                }
                if (UpgradesHelper.hasEndericUpgrade(this.stack)) {
                    owner.method_5859(this.method_23317(), this.method_23318(), this.method_23321());
                    owner.field_6017 = 0.0f;
                    ((PlayerProperties)owner).setHasHook(false);
                    this.isPulling = false;
                    this.method_36209();
                }
            }
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.field_6011.method_12778(FORCED_YAW, (Object)Float.valueOf(tag.method_10583("ForcedYaw")));
        this.maxRange = tag.method_10574("maxRange");
        this.maxSpeed = tag.method_10574("maxSpeed");
        this.isPulling = tag.method_10577("isPulling");
        this.stack = class_1799.method_7915((class_2487)tag.method_10562("hookshotItem"));
        class_1297 class_12972 = this.field_6002.method_8469(tag.method_10550("owner"));
        if (class_12972 instanceof class_1657) {
            class_1657 owner = (class_1657)class_12972;
            this.method_7432((class_1297)owner);
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("ForcedYaw", ((Float)this.field_6011.method_12789(FORCED_YAW)).floatValue());
        tag.method_10549("maxRange", this.maxRange);
        tag.method_10549("maxSpeed", this.maxSpeed);
        tag.method_10556("isPulling", this.isPulling);
        tag.method_10566("hookshotItem", (class_2520)this.stack.method_7953(new class_2487()));
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            class_1657 owner = (class_1657)class_12972;
            tag.method_10569("owner", owner.method_5628());
        }
    }

    public void setProperties(class_1799 stack, double maxRange, double maxVelocity, float pitch, float yaw, float roll, float modifierZ) {
        float f = (float)Math.PI / 180;
        float x = -class_3532.method_15374((float)(yaw * f)) * class_3532.method_15362((float)(pitch * f));
        float y = -class_3532.method_15374((float)((pitch + roll) * f));
        float z = class_3532.method_15362((float)(yaw * f)) * class_3532.method_15362((float)(pitch * f));
        this.method_7485(x, y, z, modifierZ, 0.0f);
        this.stack = stack;
        this.maxRange = maxRange;
        this.maxSpeed = maxVelocity;
    }
}

