/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.impl.ordering;

import de.odysseus.ithaka.digraph.Digraph;
import de.odysseus.ithaka.digraph.Digraphs;
import de.odysseus.ithaka.digraph.MapDigraph;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSet;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSetPolicy;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSetProvider;
import de.odysseus.ithaka.digraph.util.fas.SimpleFeedbackArcSetProvider;
import java.util.ArrayList;
import java.util.EnumMap;
import net.coderbot.batchedentityrendering.impl.BlendingStateHolder;
import net.coderbot.batchedentityrendering.impl.TransparencyType;
import net.coderbot.batchedentityrendering.impl.WrappableRenderType;
import net.coderbot.batchedentityrendering.impl.ordering.RenderOrderManager;
import net.minecraft.class_1921;

public class GraphTranslucencyRenderOrderManager
implements RenderOrderManager {
    private final FeedbackArcSetProvider feedbackArcSetProvider = new SimpleFeedbackArcSetProvider();
    private final EnumMap<TransparencyType, Digraph<class_1921>> types = new EnumMap(TransparencyType.class);
    private boolean inGroup = false;
    private final EnumMap<TransparencyType, class_1921> currentTypes = new EnumMap(TransparencyType.class);

    public GraphTranslucencyRenderOrderManager() {
        for (TransparencyType type : TransparencyType.values()) {
            this.types.put(type, new MapDigraph());
        }
    }

    private static TransparencyType getTransparencyType(class_1921 type) {
        while (type instanceof WrappableRenderType) {
            type = ((WrappableRenderType)type).unwrap();
        }
        if (type instanceof BlendingStateHolder) {
            return ((BlendingStateHolder)type).getTransparencyType();
        }
        return TransparencyType.GENERAL_TRANSPARENT;
    }

    @Override
    public void begin(class_1921 renderType) {
        TransparencyType transparencyType = GraphTranslucencyRenderOrderManager.getTransparencyType(renderType);
        Digraph<class_1921> graph = this.types.get((Object)transparencyType);
        graph.add(renderType);
        if (this.inGroup) {
            class_1921 previous = this.currentTypes.put(transparencyType, renderType);
            if (previous == null) {
                return;
            }
            int weight = graph.get(previous, renderType).orElse(0);
            graph.put(previous, renderType, ++weight);
        }
    }

    @Override
    public void startGroup() {
        if (this.inGroup) {
            throw new IllegalStateException("Already in a group");
        }
        this.currentTypes.clear();
        this.inGroup = true;
    }

    @Override
    public boolean maybeStartGroup() {
        if (this.inGroup) {
            return false;
        }
        this.currentTypes.clear();
        this.inGroup = true;
        return true;
    }

    @Override
    public void endGroup() {
        if (!this.inGroup) {
            throw new IllegalStateException("Not in a group");
        }
        this.currentTypes.clear();
        this.inGroup = false;
    }

    @Override
    public void reset() {
        this.types.clear();
        for (TransparencyType type : TransparencyType.values()) {
            this.types.put(type, new MapDigraph());
        }
    }

    @Override
    public Iterable<class_1921> getRenderOrder() {
        int layerCount = 0;
        for (Digraph<class_1921> graph : this.types.values()) {
            layerCount += graph.getVertexCount();
        }
        ArrayList<class_1921> allLayers = new ArrayList<class_1921>(layerCount);
        for (Digraph<class_1921> graph : this.types.values()) {
            FeedbackArcSet<class_1921> arcSet = this.feedbackArcSetProvider.getFeedbackArcSet(graph, graph, FeedbackArcSetPolicy.MIN_WEIGHT);
            if (arcSet.getEdgeCount() > 0) {
                for (class_1921 source : arcSet.vertices()) {
                    for (class_1921 target : arcSet.targets(source)) {
                        graph.remove(source, target);
                    }
                }
            }
            allLayers.addAll(Digraphs.toposort(graph, false));
        }
        return allLayers;
    }
}

