/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris;

import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_5944;

public class HorizonRenderer {
    private static final float TOP = 16.0f;
    private static final float BOTTOM = -16.0f;
    private static final double COS_22_5 = Math.cos(Math.toRadians(22.5));
    private static final double SIN_22_5 = Math.sin(Math.toRadians(22.5));
    private class_291 buffer = new class_291();

    public HorizonRenderer() {
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        this.buildHorizon((class_4588)builder);
        builder.method_1326();
        this.buffer.method_1352(builder);
    }

    private void buildQuad(class_4588 consumer, double x1, double z1, double x2, double z2) {
        consumer.method_22912(x1, -16.0, z1);
        consumer.method_1344();
        consumer.method_22912(x1, 16.0, z1);
        consumer.method_1344();
        consumer.method_22912(x2, 16.0, z2);
        consumer.method_1344();
        consumer.method_22912(x2, -16.0, z2);
        consumer.method_1344();
    }

    private void buildHalf(class_4588 consumer, double adjacent, double opposite, boolean invert) {
        if (invert) {
            adjacent = -adjacent;
            opposite = -opposite;
        }
        this.buildQuad(consumer, adjacent, -opposite, opposite, -adjacent);
        this.buildQuad(consumer, adjacent, opposite, adjacent, -opposite);
        this.buildQuad(consumer, opposite, adjacent, adjacent, opposite);
        this.buildQuad(consumer, -opposite, adjacent, opposite, adjacent);
    }

    private void buildOctagonalPrism(class_4588 consumer, double adjacent, double opposite) {
        this.buildHalf(consumer, adjacent, opposite, false);
        this.buildHalf(consumer, adjacent, opposite, true);
    }

    private void buildRegularOctagonalPrism(class_4588 consumer, double radius) {
        this.buildOctagonalPrism(consumer, radius * COS_22_5, radius * SIN_22_5);
    }

    private void buildBottomPlane(class_4588 consumer, int radius) {
        for (int x = -radius; x <= radius; x += 64) {
            for (int z = -radius; z <= radius; z += 64) {
                consumer.method_22912((double)(x + 64), -16.0, (double)z);
                consumer.method_1344();
                consumer.method_22912((double)x, -16.0, (double)z);
                consumer.method_1344();
                consumer.method_22912((double)x, -16.0, (double)(z + 64));
                consumer.method_1344();
                consumer.method_22912((double)(x + 64), -16.0, (double)(z + 64));
                consumer.method_1344();
            }
        }
    }

    private void buildHorizon(class_4588 consumer) {
        int radius = this.getRenderDistanceInBlocks();
        if (radius > 256) {
            radius = 256;
        }
        this.buildRegularOctagonalPrism(consumer, radius);
        this.buildBottomPlane(consumer, 384);
    }

    private int getRenderDistanceInBlocks() {
        return class_310.method_1551().field_1690.method_38521() * 16;
    }

    public void close() {
        this.buffer.close();
    }

    public void renderHorizon(class_1159 modelView, class_1159 projection, class_5944 shader) {
        this.buffer.method_34427(modelView, projection, shader);
    }
}

