/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.block_rendering;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.materialmap.BlockEntry;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class BlockMaterialMapping {
    public static Object2IntMap<class_2680> createBlockStateIdMap(Int2ObjectMap<List<BlockEntry>> blockPropertiesMap) {
        Object2IntOpenHashMap blockStateIds = new Object2IntOpenHashMap();
        blockPropertiesMap.forEach((arg_0, arg_1) -> BlockMaterialMapping.lambda$createBlockStateIdMap$0((Object2IntMap)blockStateIds, arg_0, arg_1));
        return blockStateIds;
    }

    private static void addBlockStates(BlockEntry entry, Object2IntMap<class_2680> idMap, int intId) {
        NamespacedId id = entry.getId();
        class_2960 resourceLocation = new class_2960(id.getNamespace(), id.getName());
        class_2248 block = (class_2248)class_2378.field_11146.method_10223(resourceLocation);
        if (block == class_2246.field_10124) {
            return;
        }
        Map<String, String> propertyPredicates = entry.getPropertyPredicates();
        if (propertyPredicates.isEmpty()) {
            for (class_2680 state : block.method_9595().method_11662()) {
                idMap.put((Object)state, intId);
            }
            return;
        }
        HashMap properties = new HashMap();
        class_2689 stateManager = block.method_9595();
        propertyPredicates.forEach((key, value) -> {
            class_2769 property = stateManager.method_11663(key);
            if (property == null) {
                Iris.logger.warn("Error while parsing the block ID map entry for \"block." + intId + "\":");
                Iris.logger.warn("- The block " + resourceLocation + " has no property with the name " + key + ", ignoring!");
                return;
            }
            properties.put((class_2769<?>)property, (String)value);
        });
        for (class_2680 state : stateManager.method_11662()) {
            if (!BlockMaterialMapping.checkState(state, properties)) continue;
            idMap.put((Object)state, intId);
        }
    }

    private static boolean checkState(class_2680 state, Map<class_2769<?>, String> expectedValues) {
        for (Map.Entry<class_2769<?>, String> condition : expectedValues.entrySet()) {
            String actualValue;
            class_2769<?> property = condition.getKey();
            String expectedValue = condition.getValue();
            if (expectedValue.equals(actualValue = property.method_11901(state.method_11654(property)))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$createBlockStateIdMap$0(Object2IntMap blockStateIds, Integer intId, List entries) {
        for (BlockEntry entry : entries) {
            BlockMaterialMapping.addBlockStates(entry, (Object2IntMap<class_2680>)blockStateIds, intId);
        }
    }
}

