/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.xhfp;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import net.coderbot.iris.block_rendering.MaterialIdHolder;
import net.coderbot.iris.compat.sodium.impl.block_id.MaterialIdAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.xhfp.NormalHelper;
import net.coderbot.iris.compat.sodium.impl.vertex_format.xhfp.QuadView;
import net.coderbot.iris.compat.sodium.impl.vertex_format.xhfp.XHFPModelVertexType;
import net.coderbot.iris.vendored.joml.Vector3f;

public class XHFPModelVertexBufferWriterNio
extends VertexBufferWriterNio
implements ModelVertexSink,
MaterialIdAwareVertexWriter {
    private MaterialIdHolder idHolder;
    private static final int STRIDE = 40;
    int vertexCount = 0;
    float uSum;
    float vSum;
    private final QuadView currentQuad = new QuadView();
    private final Vector3f normal = new Vector3f();

    public XHFPModelVertexBufferWriterNio(VertexBufferView backingBuffer) {
        super(backingBuffer, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    public void copyQuadAndFlipNormal() {
        this.ensureCapacity(4);
        ByteBuffer src = this.byteBuffer.duplicate();
        ByteBuffer dst = this.byteBuffer.duplicate();
        src.position(this.byteBuffer.position() + this.writeOffset - 160);
        src.limit(src.position() + 160);
        dst.position(this.byteBuffer.position() + this.writeOffset);
        dst.limit(dst.position() + 160);
        dst.put(src);
        int packedNormal = this.byteBuffer.getInt(this.writeOffset + 28);
        int inverted = NormalHelper.invertPackedNormal(packedNormal);
        this.byteBuffer.putInt(this.writeOffset + 28, inverted);
        this.byteBuffer.putInt(this.writeOffset + 28 + 40, inverted);
        this.byteBuffer.putInt(this.writeOffset + 28 + 80, inverted);
        this.byteBuffer.putInt(this.writeOffset + 28 + 120, inverted);
        for (int i = 0; i < 4; ++i) {
            this.advance();
        }
        this.flush();
    }

    public void writeVertex(float posX, float posY, float posZ, int color, float u, float v, int light, int chunkId) {
        this.uSum += u;
        this.vSum += v;
        short materialId = this.idHolder.id;
        short renderType = this.idHolder.renderType;
        this.writeQuadInternal(posX, posY, posZ, color, u, v, light, materialId, renderType, chunkId);
    }

    private void writeQuadInternal(float posX, float posY, float posZ, int color, float u, float v, int light, short materialId, short renderType, int chunkId) {
        int i = this.writeOffset;
        ++this.vertexCount;
        ByteBuffer buffer = this.byteBuffer;
        buffer.putShort(i + 0, XHFPModelVertexType.encodePosition(posX));
        buffer.putShort(i + 2, XHFPModelVertexType.encodePosition(posY));
        buffer.putShort(i + 4, XHFPModelVertexType.encodePosition(posZ));
        buffer.putShort(i + 6, (short)chunkId);
        buffer.putInt(i + 8, color);
        buffer.putShort(i + 12, XHFPModelVertexType.encodeBlockTexture(u));
        buffer.putShort(i + 14, XHFPModelVertexType.encodeBlockTexture(v));
        buffer.putInt(i + 16, XHFPModelVertexType.encodeLightMapTexCoord(light));
        buffer.putShort(i + 32, materialId);
        buffer.putShort(i + 34, renderType);
        buffer.putShort(i + 36, (short)0);
        buffer.putShort(i + 38, (short)0);
        if (this.vertexCount == 4) {
            int midU = (int)(65535.0f * Math.min(this.uSum * 0.25f, 1.0f)) & 0xFFFF;
            int midV = (int)(65535.0f * Math.min(this.vSum * 0.25f, 1.0f)) & 0xFFFF;
            int midTexCoord = midV << 16 | midU;
            buffer.putInt(i + 20, midTexCoord);
            buffer.putInt(i + 20 - 40, midTexCoord);
            buffer.putInt(i + 20 - 80, midTexCoord);
            buffer.putInt(i + 20 - 120, midTexCoord);
            this.vertexCount = 0;
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.currentQuad.buffer = this.byteBuffer;
            this.currentQuad.writeOffset = this.writeOffset;
            NormalHelper.computeFaceNormal(this.normal, this.currentQuad);
            int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
            buffer.putInt(i + 28, packedNormal);
            buffer.putInt(i + 28 - 40, packedNormal);
            buffer.putInt(i + 28 - 80, packedNormal);
            buffer.putInt(i + 28 - 120, packedNormal);
            float x0 = XHFPModelVertexType.decodePosition(buffer.getShort(i + 0 - 120));
            float y0 = XHFPModelVertexType.decodePosition(buffer.getShort(i + 2 - 120));
            float z0 = XHFPModelVertexType.decodePosition(buffer.getShort(i + 4 - 120));
            float x1 = XHFPModelVertexType.decodePosition(buffer.getShort(i + 0 - 80));
            float y1 = XHFPModelVertexType.decodePosition(buffer.getShort(i + 2 - 80));
            float z1 = XHFPModelVertexType.decodePosition(buffer.getShort(i + 4 - 80));
            float x2 = XHFPModelVertexType.decodePosition(buffer.getShort(i + 0 - 40));
            float y2 = XHFPModelVertexType.decodePosition(buffer.getShort(i + 2 - 40));
            float z2 = XHFPModelVertexType.decodePosition(buffer.getShort(i + 4 - 40));
            float edge1x = x1 - x0;
            float edge1y = y1 - y0;
            float edge1z = z1 - z0;
            float edge2x = x2 - x0;
            float edge2y = y2 - y0;
            float edge2z = z2 - z0;
            float u0 = XHFPModelVertexType.decodeBlockTexture(buffer.getShort(i + 12 - 120));
            float v0 = XHFPModelVertexType.decodeBlockTexture(buffer.getShort(i + 14 - 120));
            float u1 = XHFPModelVertexType.decodeBlockTexture(buffer.getShort(i + 12 - 80));
            float v1 = XHFPModelVertexType.decodeBlockTexture(buffer.getShort(i + 14 - 80));
            float u2 = XHFPModelVertexType.decodeBlockTexture(buffer.getShort(i + 12 - 40));
            float v2 = XHFPModelVertexType.decodeBlockTexture(buffer.getShort(i + 14 - 40));
            float deltaU1 = u1 - u0;
            float deltaV1 = v1 - v0;
            float deltaU2 = u2 - u0;
            float deltaV2 = v2 - v0;
            float fdenom = deltaU1 * deltaV2 - deltaU2 * deltaV1;
            float f = (double)fdenom == 0.0 ? 1.0f : 1.0f / fdenom;
            float tangentx = f * (deltaV2 * edge1x - deltaV1 * edge2x);
            float tangenty = f * (deltaV2 * edge1y - deltaV1 * edge2y);
            float tangentz = f * (deltaV2 * edge1z - deltaV1 * edge2z);
            float tcoeff = XHFPModelVertexBufferWriterNio.rsqrt(tangentx * tangentx + tangenty * tangenty + tangentz * tangentz);
            tangentx *= tcoeff;
            tangenty *= tcoeff;
            float bitangentx = f * (-deltaU2 * edge1x + deltaU1 * edge2x);
            float bitangenty = f * (-deltaU2 * edge1y + deltaU1 * edge2y);
            float bitangentz = f * (-deltaU2 * edge1z + deltaU1 * edge2z);
            float bitcoeff = XHFPModelVertexBufferWriterNio.rsqrt(bitangentx * bitangentx + bitangenty * bitangenty + bitangentz * bitangentz);
            float pbitangentx = tangenty * this.normal.z() - (tangentz *= tcoeff) * this.normal.y();
            float pbitangenty = -(tangentx * this.normal.z() - tangentz * this.normal.x());
            float pbitangentz = tangentx * this.normal.x() - tangenty * this.normal.y();
            float dot = (bitangentx *= bitcoeff) * pbitangentx + (bitangenty *= bitcoeff) * pbitangenty + (bitangentz *= bitcoeff) * pbitangentz;
            int tangentW = dot < 0.0f ? -127 : 127;
            int tangent = Norm3b.pack((float)tangentx, (float)tangenty, (float)tangentz);
            buffer.putInt(i + 24, tangent |= tangentW << 24);
            buffer.putInt(i + 24 - 40, tangent);
            buffer.putInt(i + 24 - 80, tangent);
            buffer.putInt(i + 24 - 120, tangent);
        }
        this.advance();
    }

    private static float rsqrt(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        return (float)(1.0 / Math.sqrt(value));
    }

    @Override
    public void iris$setIdHolder(MaterialIdHolder holder) {
        this.idHolder = holder;
    }
}

