/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin;

import java.util.List;
import java.util.Set;
import net.coderbot.iris.compat.sodium.SodiumVersionCheck;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class IrisSodiumCompatMixinPlugin
implements IMixinConfigPlugin {
    private boolean validSodiumVersion = false;

    public void onLoad(String mixinPackage) {
        this.validSodiumVersion = FabricLoader.getInstance().getModContainer("sodium").map(sodium -> {
            String version = sodium.getMetadata().getVersion().getFriendlyString();
            return SodiumVersionCheck.isAllowedVersion(version);
        }).orElse(false);
        if (!this.validSodiumVersion) {
            System.err.println("[Iris] Invalid/missing version of Sodium detected, disabling compatibility mixins!");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return this.validSodiumVersion;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

