/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.blending;

import net.coderbot.iris.gl.blending.AlphaTestFunction;

public class AlphaTest {
    public static final AlphaTest ALWAYS = new AlphaTest(AlphaTestFunction.ALWAYS, 0.0f);
    private final AlphaTestFunction function;
    private final float reference;

    public AlphaTest(AlphaTestFunction function, float reference) {
        this.function = function;
        this.reference = reference;
    }

    public String toExpression(String indentation) {
        return this.toExpression("gl_FragData[0].a", indentation);
    }

    public String toExpression(String alphaAccessor, String indentation) {
        if (this.function == AlphaTestFunction.ALWAYS) {
            return "// alpha test disabled\n";
        }
        if (this.function == AlphaTestFunction.NEVER) {
            return "discard;\n";
        }
        String expr = this.function.getExpression();
        return indentation + "if (!(" + alphaAccessor + " " + expr + " " + this.reference + ")) {\n" + indentation + "    discard;\n" + indentation + "}\n";
    }

    public AlphaTestFunction getFunction() {
        return this.function;
    }

    public float getReference() {
        return this.reference;
    }
}

