/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.shader.ShaderConstants;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.shader.ShaderWorkarounds;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlShader
extends GlResource {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final String name;

    public GlShader(ShaderType type, String name, String src, ShaderConstants constants) {
        super(GlShader.createShader(type, name, src, constants));
        this.name = name;
    }

    private static int createShader(ShaderType type, String name, String src, ShaderConstants constants) {
        int result;
        src = GlShader.processShader(src, constants);
        int handle = GlStateManager.glCreateShader((int)type.id);
        ShaderWorkarounds.safeShaderSource(handle, src);
        GlStateManager.glCompileShader((int)handle);
        String log = IrisRenderSystem.getShaderInfoLog(handle);
        if (!log.isEmpty()) {
            LOGGER.warn("Shader compilation log for " + name + ": " + log);
        }
        if ((result = GlStateManager.glGetShaderi((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        return handle;
    }

    public static String processShader(String src, ShaderConstants constants) {
        StringBuilder builder = new StringBuilder(src.length());
        boolean patched = false;
        try (BufferedReader reader = new BufferedReader(new StringReader(src));){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
                if (patched || !line.startsWith("#version")) continue;
                for (String macro : constants.getDefineStrings()) {
                    builder.append(macro).append('\n');
                }
                patched = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not process shader source", e);
        }
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getHandle() {
        return this.getGlId();
    }

    @Override
    protected void destroyInternal() {
        GlStateManager.glDeleteShader((int)this.getGlId());
    }
}

