/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.shader.GlShader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgramCreator {
    private static final Logger LOGGER = LogManager.getLogger(ProgramCreator.class);

    public static int create(String name, GlShader ... shaders) {
        int result;
        int program = GlStateManager.glCreateProgram();
        GlStateManager._glBindAttribLocation((int)program, (int)11, (CharSequence)"mc_Entity");
        GlStateManager._glBindAttribLocation((int)program, (int)12, (CharSequence)"mc_midTexCoord");
        GlStateManager._glBindAttribLocation((int)program, (int)13, (CharSequence)"at_tangent");
        GlStateManager._glBindAttribLocation((int)program, (int)0, (CharSequence)"Position");
        GlStateManager._glBindAttribLocation((int)program, (int)1, (CharSequence)"UV0");
        for (GlShader shader : shaders) {
            GlStateManager.glAttachShader((int)program, (int)shader.getHandle());
        }
        GlStateManager.glLinkProgram((int)program);
        for (GlShader shader : shaders) {
            IrisRenderSystem.detachShader(program, shader.getHandle());
        }
        String log = IrisRenderSystem.getProgramInfoLog(program);
        if (!log.isEmpty()) {
            LOGGER.warn("Program link log for " + name + ": " + log);
        }
        if ((result = GlStateManager.glGetProgrami((int)program, (int)35714)) != 1) {
            throw new RuntimeException("Shader program linking failed, see log for details");
        }
        return program;
    }
}

