/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.gui.GuiUtil;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class IrisElementRow {
    private final Map<Element, Integer> elements = new HashMap<Element, Integer>();
    private final List<Element> orderedElements = new ArrayList<Element>();
    private final int spacing;
    private int x;
    private int y;
    private int width;
    private int height;

    public IrisElementRow(int spacing) {
        this.spacing = spacing;
    }

    public IrisElementRow() {
        this(1);
    }

    public IrisElementRow add(Element element, int width) {
        if (!this.orderedElements.contains(element)) {
            this.orderedElements.add(element);
        }
        this.elements.put(element, width);
        this.width += width + this.spacing;
        return this;
    }

    public void setWidth(Element element, int width) {
        if (!this.elements.containsKey(element)) {
            return;
        }
        this.width -= this.elements.get(element) + 2;
        this.add(element, width);
    }

    public void render(class_4587 poseStack, int x, int y, int height, int mouseX, int mouseY, float tickDelta, boolean rowHovered) {
        this.x = x;
        this.y = y;
        this.height = height;
        int currentX = x;
        for (Element element : this.orderedElements) {
            int currentWidth = this.elements.get(element);
            element.render(poseStack, currentX, y, currentWidth, height, mouseX, mouseY, tickDelta, rowHovered && this.sectionHovered(currentX, currentWidth, mouseX, mouseY));
            currentX += currentWidth + this.spacing;
        }
    }

    public void renderRightAligned(class_4587 poseStack, int x, int y, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
        this.render(poseStack, x - this.width, y, height, mouseX, mouseY, tickDelta, hovered);
    }

    private boolean sectionHovered(int sectionX, int sectionWidth, double mx, double my) {
        return mx > (double)sectionX && mx < (double)(sectionX + sectionWidth) && my > (double)this.y && my < (double)(this.y + this.height);
    }

    private Optional<Element> getHovered(double mx, double my) {
        int currentX = this.x;
        for (Element element : this.orderedElements) {
            int currentWidth = this.elements.get(element);
            if (this.sectionHovered(currentX, currentWidth, mx, my)) {
                return Optional.of(element);
            }
            currentX += currentWidth + this.spacing;
        }
        return Optional.empty();
    }

    public boolean mouseClicked(double mx, double my, int button) {
        return this.getHovered(mx, my).map(element -> element.mouseClicked(mx, my, button)).orElse(false);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        return this.getHovered(mx, my).map(element -> element.mouseReleased(mx, my, button)).orElse(false);
    }

    public static abstract class Element {
        public boolean disabled = false;
        private boolean hovered = false;

        public void render(class_4587 poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
            GuiUtil.bindIrisWidgetsTexture();
            GuiUtil.drawButton(poseStack, x, y, width, height, hovered, this.disabled);
            this.hovered = hovered;
            this.renderLabel(poseStack, x, y, width, height, mouseX, mouseY, tickDelta, hovered);
        }

        public abstract void renderLabel(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8, boolean var9);

        public boolean mouseClicked(double mx, double my, int button) {
            return false;
        }

        public boolean mouseReleased(double mx, double my, int button) {
            return false;
        }

        public boolean isHovered() {
            return this.hovered;
        }
    }

    public static class TextButtonElement
    extends ButtonElement<TextButtonElement> {
        protected final class_327 font;
        public class_2561 text;

        public TextButtonElement(class_2561 text, Function<TextButtonElement, Boolean> onClick) {
            super(onClick);
            this.font = class_310.method_1551().field_1772;
            this.text = text;
        }

        @Override
        public void renderLabel(class_4587 poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
            int textX = x + (int)((double)(width - this.font.method_27525((class_5348)this.text)) * 0.5);
            int textY = y + (int)((double)(height - 8) * 0.5);
            this.font.method_30881(poseStack, this.text, (float)textX, (float)textY, 0xFFFFFF);
        }
    }

    public static class IconButtonElement
    extends ButtonElement<IconButtonElement> {
        public GuiUtil.Icon icon;
        public GuiUtil.Icon hoveredIcon;

        public IconButtonElement(GuiUtil.Icon icon, GuiUtil.Icon hoveredIcon, Function<IconButtonElement, Boolean> onClick) {
            super(onClick);
            this.icon = icon;
            this.hoveredIcon = hoveredIcon;
        }

        public IconButtonElement(GuiUtil.Icon icon, Function<IconButtonElement, Boolean> onClick) {
            this(icon, icon, onClick);
        }

        @Override
        public void renderLabel(class_4587 poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
            int iconX = x + (int)((double)(width - this.icon.getWidth()) * 0.5);
            int iconY = y + (int)((double)(height - this.icon.getHeight()) * 0.5);
            GuiUtil.bindIrisWidgetsTexture();
            if (!this.disabled && hovered) {
                this.hoveredIcon.draw(poseStack, iconX, iconY);
            } else {
                this.icon.draw(poseStack, iconX, iconY);
            }
        }
    }

    public static abstract class ButtonElement<T extends ButtonElement<T>>
    extends Element {
        private final Function<T, Boolean> onClick;

        protected ButtonElement(Function<T, Boolean> onClick) {
            this.onClick = onClick;
        }

        @Override
        public boolean mouseClicked(double mx, double my, int button) {
            if (this.disabled) {
                return false;
            }
            if (button == 0) {
                return this.onClick.apply(this);
            }
            return super.mouseClicked(mx, my, button);
        }
    }
}

