/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.FileDialogUtil;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.IrisElementRow;
import net.coderbot.iris.gui.element.IrisObjectSelectionList;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.OptionMenuConstructor;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class ShaderPackOptionList
extends IrisObjectSelectionList<BaseEntry> {
    private final List<AbstractElementWidget<?>> elementWidgets = new ArrayList();
    private final ShaderPackScreen screen;
    private final NavigationController navigation;
    private OptionMenuContainer container;

    public ShaderPackOptionList(ShaderPackScreen screen, NavigationController navigation, ShaderPack pack, class_310 client, int width, int height, int top, int bottom, int left, int right) {
        super(client, width, height, top, bottom, left, right, 24);
        this.navigation = navigation;
        this.screen = screen;
        this.applyShaderPack(pack);
    }

    public void applyShaderPack(ShaderPack pack) {
        this.container = pack.getMenuContainer();
    }

    public void rebuild() {
        this.method_25339();
        this.method_25307(0.0);
        OptionMenuConstructor.constructAndApplyToScreen(this.container, this.screen, this, this.navigation);
    }

    public void refresh() {
        this.elementWidgets.forEach(widget -> widget.init(this.screen, this.navigation));
    }

    public int method_25322() {
        return Math.min(400, this.field_22742 - 12);
    }

    public void addHeader(class_2561 text, boolean backButton) {
        this.method_25321((class_350.class_351)new HeaderEntry(this.screen, this.navigation, text, backButton));
    }

    public void addWidgets(int columns, List<AbstractElementWidget<?>> elements) {
        this.elementWidgets.addAll(elements);
        ArrayList<AbstractElementWidget<Object>> row = new ArrayList();
        for (AbstractElementWidget<?> element : elements) {
            row.add(element);
            if (row.size() < columns) continue;
            this.method_25321((class_350.class_351)new ElementRowEntry(this.screen, this.navigation, row));
            row = new ArrayList();
        }
        if (row.size() > 0) {
            while (row.size() < columns) {
                row.add(AbstractElementWidget.EMPTY);
            }
            this.method_25321((class_350.class_351)new ElementRowEntry(this.screen, this.navigation, row));
        }
    }

    public NavigationController getNavigation() {
        return this.navigation;
    }

    public static class HeaderEntry
    extends BaseEntry {
        public static final class_2561 BACK_BUTTON_TEXT = new class_2585("< ").method_10852((class_2561)new class_2588("options.iris.back").method_27692(class_124.field_1056));
        public static final class_5250 RESET_BUTTON_TEXT_INACTIVE = new class_2588("options.iris.reset").method_27692(class_124.field_1080);
        public static final class_5250 RESET_BUTTON_TEXT_ACTIVE = new class_2588("options.iris.reset").method_27692(class_124.field_1054);
        public static final class_5250 RESET_HOLD_SHIFT_TOOLTIP = new class_2588("options.iris.reset.tooltip.holdShift").method_27692(class_124.field_1065);
        public static final class_5250 RESET_TOOLTIP = new class_2588("options.iris.reset.tooltip").method_27692(class_124.field_1061);
        public static final class_5250 IMPORT_TOOLTIP = new class_2588("options.iris.importSettings.tooltip").method_27694(style -> style.method_27703(class_5251.method_27717((int)5089023)));
        public static final class_5250 EXPORT_TOOLTIP = new class_2588("options.iris.exportSettings.tooltip").method_27694(style -> style.method_27703(class_5251.method_27717((int)16547133)));
        private static final int MIN_SIDE_BUTTON_WIDTH = 42;
        private static final int BUTTON_HEIGHT = 16;
        private final ShaderPackScreen screen;
        @Nullable
        private final IrisElementRow backButton;
        private final IrisElementRow utilityButtons = new IrisElementRow();
        private final IrisElementRow.TextButtonElement resetButton;
        private final IrisElementRow.IconButtonElement importButton;
        private final IrisElementRow.IconButtonElement exportButton;
        private final class_2561 text;

        public HeaderEntry(ShaderPackScreen screen, NavigationController navigation, class_2561 text, boolean hasBackButton) {
            super(navigation);
            this.backButton = hasBackButton ? new IrisElementRow().add(new IrisElementRow.TextButtonElement(BACK_BUTTON_TEXT, this::backButtonClicked), Math.max(42, class_310.method_1551().field_1772.method_27525((class_5348)BACK_BUTTON_TEXT) + 8)) : null;
            this.resetButton = new IrisElementRow.TextButtonElement((class_2561)RESET_BUTTON_TEXT_INACTIVE, this::resetButtonClicked);
            this.importButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.IMPORT, GuiUtil.Icon.IMPORT_COLORED, this::importSettingsButtonClicked);
            this.exportButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.EXPORT, GuiUtil.Icon.EXPORT_COLORED, this::exportSettingsButtonClicked);
            this.utilityButtons.add(this.importButton, 15).add(this.exportButton, 15).add(this.resetButton, Math.max(42, class_310.method_1551().field_1772.method_27525((class_5348)RESET_BUTTON_TEXT_INACTIVE) + 8));
            this.screen = screen;
            this.text = text;
        }

        public void method_25343(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            boolean shiftDown;
            class_332.method_25294((class_4587)poseStack, (int)(x - 3), (int)(y + entryHeight - 2), (int)(x + entryWidth), (int)(y + entryHeight - 1), (int)0x66BEBEBE);
            class_327 font = class_310.method_1551().field_1772;
            class_332.method_27534((class_4587)poseStack, (class_327)font, (class_2561)this.text, (int)(x + (int)((double)entryWidth * 0.5)), (int)(y + 5), (int)0xFFFFFF);
            GuiUtil.bindIrisWidgetsTexture();
            if (this.backButton != null) {
                this.backButton.render(poseStack, x, y, 16, mouseX, mouseY, tickDelta, hovered);
            }
            this.resetButton.disabled = !(shiftDown = class_437.method_25442());
            this.resetButton.text = shiftDown ? RESET_BUTTON_TEXT_ACTIVE : RESET_BUTTON_TEXT_INACTIVE;
            this.utilityButtons.renderRightAligned(poseStack, x + entryWidth - 3, y, 16, mouseX, mouseY, tickDelta, hovered);
            if (this.resetButton.isHovered()) {
                class_5250 tooltip = shiftDown ? RESET_TOOLTIP : RESET_HOLD_SHIFT_TOOLTIP;
                this.queueBottomRightAnchoredTooltip(poseStack, mouseX, mouseY, font, (class_2561)tooltip);
            }
            if (this.importButton.isHovered()) {
                this.queueBottomRightAnchoredTooltip(poseStack, mouseX, mouseY, font, (class_2561)IMPORT_TOOLTIP);
            }
            if (this.exportButton.isHovered()) {
                this.queueBottomRightAnchoredTooltip(poseStack, mouseX, mouseY, font, (class_2561)EXPORT_TOOLTIP);
            }
        }

        private void queueBottomRightAnchoredTooltip(class_4587 poseStack, int x, int y, class_327 font, class_2561 text) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(font, poseStack, text, x - (font.method_27525((class_5348)text) + 10), y - 16));
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean backButtonResult = this.backButton != null && this.backButton.mouseClicked(mouseX, mouseY, button);
            boolean utilButtonResult = this.utilityButtons.mouseClicked(mouseX, mouseY, button);
            return backButtonResult || utilButtonResult;
        }

        private boolean backButtonClicked(IrisElementRow.TextButtonElement button) {
            this.navigation.back();
            GuiUtil.playButtonClickSound();
            return true;
        }

        private boolean resetButtonClicked(IrisElementRow.TextButtonElement button) {
            if (class_437.method_25442()) {
                Iris.resetShaderPackOptionsOnNextReload();
                this.screen.applyChanges();
                GuiUtil.playButtonClickSound();
                return true;
            }
            return false;
        }

        private boolean importSettingsButtonClicked(IrisElementRow.IconButtonElement button) {
            GuiUtil.playButtonClickSound();
            if (!Iris.getCurrentPack().isPresent()) {
                return false;
            }
            ShaderPackScreen originalScreen = this.screen;
            FileDialogUtil.fileSelectDialog(FileDialogUtil.DialogType.OPEN, "Import Shader Settings from File", Iris.getShaderpacksDirectory().resolve(Iris.getCurrentPackName() + ".txt"), "Shader Pack Settings (.txt)", "*.txt").whenComplete((path, err) -> {
                if (err != null) {
                    Iris.logger.error("Error selecting shader settings from file", err);
                    return;
                }
                if (class_310.method_1551().field_1755 == originalScreen) {
                    path.ifPresent(originalScreen::importPackOptions);
                }
            });
            return true;
        }

        private boolean exportSettingsButtonClicked(IrisElementRow.IconButtonElement button) {
            GuiUtil.playButtonClickSound();
            if (!Iris.getCurrentPack().isPresent()) {
                return false;
            }
            FileDialogUtil.fileSelectDialog(FileDialogUtil.DialogType.SAVE, "Export Shader Settings to File", Iris.getShaderpacksDirectory().resolve(Iris.getCurrentPackName() + ".txt"), "Shader Pack Settings (.txt)", "*.txt").whenComplete((path, err) -> {
                if (err != null) {
                    Iris.logger.error("Error selecting file to export shader settings", err);
                    return;
                }
                path.ifPresent(p -> {
                    Properties toSave = new Properties();
                    Path sourceTxtPath = Iris.getShaderpacksDirectory().resolve(Iris.getCurrentPackName() + ".txt");
                    if (Files.exists(sourceTxtPath, new LinkOption[0])) {
                        try (InputStream in2 = Files.newInputStream(sourceTxtPath, new OpenOption[0]);){
                            toSave.load(in2);
                        }
                        catch (IOException in2) {
                            // empty catch block
                        }
                    }
                    try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);){
                        toSave.store(out, null);
                    }
                    catch (IOException e) {
                        Iris.logger.error("Error saving properties to \"" + p + "\"", (Throwable)e);
                    }
                });
            });
            return true;
        }

        public class_2561 method_37006() {
            return new class_2588("narrator.select", new Object[]{this.text});
        }
    }

    public static class ElementRowEntry
    extends BaseEntry {
        private final List<AbstractElementWidget<?>> widgets;
        private final ShaderPackScreen screen;
        private int cachedWidth;
        private int cachedPosX;

        public ElementRowEntry(ShaderPackScreen screen, NavigationController navigation, List<AbstractElementWidget<?>> widgets) {
            super(navigation);
            this.screen = screen;
            this.widgets = widgets;
        }

        public void method_25343(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.cachedWidth = entryWidth;
            this.cachedPosX = x;
            int totalWidthWithoutMargins = entryWidth - 2 * (this.widgets.size() - 1);
            float singleWidgetWidth = (float)(totalWidthWithoutMargins -= 3) / (float)this.widgets.size();
            for (int i = 0; i < this.widgets.size(); ++i) {
                AbstractElementWidget<?> widget = this.widgets.get(i);
                boolean widgetHovered = hovered && this.getHoveredWidget(mouseX) == i;
                widget.render(poseStack, x + (int)((singleWidgetWidth + 2.0f) * (float)i), y, (int)singleWidgetWidth, entryHeight + 2, mouseX, mouseY, tickDelta, widgetHovered);
                this.screen.setElementHoveredStatus(widget, widgetHovered);
            }
        }

        public int getHoveredWidget(int mouseX) {
            float positionAcrossWidget = (float)class_3532.method_15340((int)(mouseX - this.cachedPosX), (int)0, (int)this.cachedWidth) / (float)this.cachedWidth;
            return class_3532.method_15340((int)((int)Math.floor((float)this.widgets.size() * positionAcrossWidget)), (int)0, (int)(this.widgets.size() - 1));
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.widgets.get(this.getHoveredWidget((int)mouseX)).mouseClicked(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return this.widgets.get(this.getHoveredWidget((int)mouseX)).mouseReleased(mouseX, mouseY, button);
        }

        public class_2561 method_37006() {
            return new class_2588("narrator.select");
        }
    }

    public static abstract class BaseEntry
    extends class_4280.class_4281<BaseEntry> {
        protected final NavigationController navigation;

        protected BaseEntry(NavigationController navigation) {
            this.navigation = navigation;
        }
    }
}

