/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import java.util.Collection;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.element.IrisElementRow;
import net.coderbot.iris.gui.element.IrisObjectSelectionList;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import net.minecraft.class_5348;

public class ShaderPackSelectionList
extends IrisObjectSelectionList<BaseEntry> {
    private static final class_2561 PACK_LIST_LABEL = new class_2588("pack.iris.list.label").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080});
    private final TopButtonRowEntry topButtonRow = new TopButtonRowEntry(this, Iris.getIrisConfig().areShadersEnabled());
    private ShaderPackEntry applied = null;

    public ShaderPackSelectionList(class_310 client, int width, int height, int top, int bottom, int left, int right) {
        super(client, width, height, top, bottom, left, right, 20);
        this.refresh();
    }

    public int method_25322() {
        return Math.min(308, this.field_22742 - 50);
    }

    protected int method_25337(int index) {
        return super.method_25337(index) + 2;
    }

    public void refresh() {
        Collection<String> names;
        this.method_25339();
        try {
            names = Iris.getShaderpacksDirectoryManager().enumerate();
        }
        catch (Throwable e) {
            Iris.logger.error("Error reading files while constructing selection UI");
            Iris.logger.catching(e);
            this.addLabelEntries(new class_2561[]{class_2585.field_24366, new class_2585("There was an error reading your shaderpacks directory").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), class_2585.field_24366, new class_2585("Check your logs for more information."), new class_2585("Please file an issue report including a log file."), new class_2585("If you are able to identify the file causing this, please include it in your report as well."), new class_2585("Note that this might be an issue with folder permissions; ensure those are correct first.")});
            return;
        }
        this.method_25321((class_350.class_351)this.topButtonRow);
        this.topButtonRow.allowEnableShadersButton = names.size() > 0;
        int index = 0;
        for (String name : names) {
            this.addPackEntry(++index, name);
        }
        this.addLabelEntries(PACK_LIST_LABEL);
    }

    public void addPackEntry(int index, String name) {
        ShaderPackEntry entry = new ShaderPackEntry(index, this, name);
        Iris.getIrisConfig().getShaderPackName().ifPresent(currentPackName -> {
            if (name.equals(currentPackName)) {
                this.method_25313((class_350.class_351)entry);
                this.setApplied(entry);
            }
        });
        this.method_25321((class_350.class_351)entry);
    }

    public void addLabelEntries(class_2561 ... lines) {
        for (class_2561 text : lines) {
            this.method_25321((class_350.class_351)new LabelEntry(text));
        }
    }

    public void select(String name) {
        for (int i = 0; i < this.method_25340(); ++i) {
            BaseEntry entry = (BaseEntry)this.method_25326(i);
            if (!(entry instanceof ShaderPackEntry) || !((ShaderPackEntry)entry).packName.equals(name)) continue;
            this.method_25313((class_350.class_351)entry);
            return;
        }
    }

    public void setApplied(ShaderPackEntry entry) {
        this.applied = entry;
    }

    public ShaderPackEntry getApplied() {
        return this.applied;
    }

    public TopButtonRowEntry getTopButtonRow() {
        return this.topButtonRow;
    }

    public static class ShaderPackEntry
    extends BaseEntry {
        private final String packName;
        private final ShaderPackSelectionList list;
        private final int index;

        public ShaderPackEntry(int index, ShaderPackSelectionList list, String packName) {
            this.packName = packName;
            this.list = list;
            this.index = index;
        }

        public boolean isApplied() {
            return this.list.getApplied() == this;
        }

        public boolean isSelected() {
            return this.list.method_25334() == this;
        }

        public String getPackName() {
            return this.packName;
        }

        public class_2561 method_37006() {
            return new class_2588("narrator.select", new Object[]{this.packName});
        }

        public void method_25343(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 font = class_310.method_1551().field_1772;
            int color = 0xFFFFFF;
            String name = this.packName;
            boolean shadersEnabled = this.list.getTopButtonRow().shadersEnabled;
            if (font.method_27525((class_5348)new class_2585(name).method_27692(class_124.field_1067)) > this.list.method_25322() - 3) {
                name = font.method_27523(name, this.list.method_25322() - 8) + "...";
            }
            class_2585 text = new class_2585(name);
            if (shadersEnabled && this.method_25405(mouseX, mouseY)) {
                text = text.method_27692(class_124.field_1067);
            }
            if (this.isApplied()) {
                color = 16773731;
            }
            if (!shadersEnabled) {
                color = 0xA2A2A2;
            }
            class_332.method_27534((class_4587)poseStack, (class_327)font, (class_2561)text, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)color);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.list.getTopButtonRow().shadersEnabled && !this.isSelected() && button == 0) {
                this.list.select(this.index);
                return true;
            }
            return false;
        }
    }

    public static class TopButtonRowEntry
    extends BaseEntry {
        private static final class_2561 REFRESH_SHADER_PACKS_LABEL = new class_2588("options.iris.refreshShaderPacks").method_27694(style -> style.method_27703(class_5251.method_27717((int)10079999)));
        private static final class_2561 NONE_PRESENT_LABEL = new class_2588("options.iris.shaders.nonePresent").method_27692(class_124.field_1080);
        private static final class_2561 SHADERS_DISABLED_LABEL = new class_2588("options.iris.shaders.disabled");
        private static final class_2561 SHADERS_ENABLED_LABEL = new class_2588("options.iris.shaders.enabled");
        private static final int REFRESH_BUTTON_WIDTH = 18;
        private final ShaderPackSelectionList list;
        private final IrisElementRow buttons = new IrisElementRow();
        private final EnableShadersButtonElement enableDisableButton;
        private final IrisElementRow.Element refreshPacksButton;
        public boolean allowEnableShadersButton = true;
        public boolean shadersEnabled;

        public TopButtonRowEntry(ShaderPackSelectionList list, boolean shadersEnabled) {
            this.list = list;
            this.shadersEnabled = shadersEnabled;
            this.enableDisableButton = new EnableShadersButtonElement(this.getEnableDisableLabel(), button -> {
                if (this.allowEnableShadersButton) {
                    this.shadersEnabled = !this.shadersEnabled;
                    button.text = this.getEnableDisableLabel();
                    GuiUtil.playButtonClickSound();
                    return true;
                }
                return false;
            });
            this.refreshPacksButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.REFRESH, button -> {
                this.list.refresh();
                GuiUtil.playButtonClickSound();
                return true;
            });
            this.buttons.add(this.enableDisableButton, 0).add(this.refreshPacksButton, 18);
        }

        public void method_25343(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.setWidth(this.enableDisableButton, entryWidth - 1 - 18);
            this.enableDisableButton.centerX = x + (int)((double)entryWidth * 0.5);
            this.buttons.render(poseStack, x - 2, y - 3, 18, mouseX, mouseY, tickDelta, hovered);
            if (this.refreshPacksButton.isHovered()) {
                ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(class_310.method_1551().field_1772, poseStack, REFRESH_SHADER_PACKS_LABEL, mouseX - 8 - class_310.method_1551().field_1772.method_27525((class_5348)REFRESH_SHADER_PACKS_LABEL), mouseY - 16));
            }
        }

        private class_2561 getEnableDisableLabel() {
            return this.allowEnableShadersButton ? (this.shadersEnabled ? SHADERS_ENABLED_LABEL : SHADERS_DISABLED_LABEL) : NONE_PRESENT_LABEL;
        }

        public class_2561 method_37006() {
            return new class_2588("narration.button", new Object[]{this.shadersEnabled ? SHADERS_ENABLED_LABEL : SHADERS_DISABLED_LABEL});
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.buttons.mouseClicked(mouseX, mouseY, button);
        }

        public static class EnableShadersButtonElement
        extends IrisElementRow.TextButtonElement {
            private int centerX;

            public EnableShadersButtonElement(class_2561 text, Function<IrisElementRow.TextButtonElement, Boolean> onClick) {
                super(text, onClick);
            }

            @Override
            public void renderLabel(class_4587 poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
                int textX = this.centerX - (int)((double)this.font.method_27525((class_5348)this.text) * 0.5);
                int textY = y + (int)((double)(height - 8) * 0.5);
                this.font.method_30881(poseStack, this.text, (float)textX, (float)textY, 0xFFFFFF);
            }
        }
    }

    public static class LabelEntry
    extends BaseEntry {
        private final class_2561 label;

        public LabelEntry(class_2561 label) {
            this.label = label;
        }

        public class_2561 method_37006() {
            return this.label;
        }

        public void method_25343(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_332.method_27534((class_4587)poseStack, (class_327)class_310.method_1551().field_1772, (class_2561)this.label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xC2C2C2);
        }
    }

    public static abstract class BaseEntry
    extends class_4280.class_4281<BaseEntry> {
        protected BaseEntry() {
        }
    }
}

