/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import java.util.Optional;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuElement;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOptionElementWidget<T extends OptionMenuElement>
extends CommentedElementWidget<T> {
    protected static final class_2561 SET_TO_DEFAULT = new class_2588("options.iris.setToDefault").method_27692(class_124.field_1060);
    protected static final class_2561 DIVIDER = new class_2585(": ");
    protected class_5250 unmodifiedLabel;
    protected ShaderPackScreen screen;
    protected NavigationController navigation;
    private class_5250 label;
    protected class_2561 trimmedLabel;
    protected class_2561 valueLabel;
    private boolean isLabelTrimmed;
    private int maxLabelWidth;
    private int valueSectionWidth;

    public BaseOptionElementWidget(T element) {
        super(element);
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        this.screen = screen;
        this.navigation = navigation;
        this.valueLabel = null;
        this.trimmedLabel = null;
    }

    protected final void setLabel(class_5250 label) {
        this.label = label.method_27661().method_10852(DIVIDER);
        this.unmodifiedLabel = label;
    }

    protected final void updateRenderParams(int width, int minValueSectionWidth) {
        if (this.valueLabel == null) {
            this.valueLabel = this.createValueLabel();
        }
        class_327 font = class_310.method_1551().field_1772;
        this.valueSectionWidth = Math.max(minValueSectionWidth, font.method_27525((class_5348)this.valueLabel) + 8);
        this.maxLabelWidth = width - 8 - this.valueSectionWidth;
        if (this.trimmedLabel == null || font.method_27525((class_5348)this.label) > this.maxLabelWidth != this.isLabelTrimmed) {
            this.updateLabels();
        }
        this.isLabelTrimmed = font.method_27525((class_5348)this.label) > this.maxLabelWidth;
    }

    protected final void renderOptionWithValue(class_4587 poseStack, int x, int y, int width, int height, boolean hovered, float sliderPosition, int sliderWidth) {
        GuiUtil.bindIrisWidgetsTexture();
        GuiUtil.drawButton(poseStack, x, y, width, height, hovered, false);
        GuiUtil.drawButton(poseStack, x + width - (this.valueSectionWidth + 2), y + 2, this.valueSectionWidth, height - 4, false, true);
        if (sliderPosition >= 0.0f) {
            int sliderSpace = this.valueSectionWidth - 4 - sliderWidth;
            int sliderPos = x + width - this.valueSectionWidth + (int)(sliderPosition * (float)sliderSpace);
            GuiUtil.drawButton(poseStack, sliderPos, y + 4, sliderWidth, height - 8, false, false);
        }
        class_327 font = class_310.method_1551().field_1772;
        font.method_30881(poseStack, this.trimmedLabel, (float)(x + 6), (float)(y + 7), 0xFFFFFF);
        font.method_30881(poseStack, this.valueLabel, (float)(x + (width - 2) - (int)((double)this.valueSectionWidth * 0.5) - (int)((double)font.method_27525((class_5348)this.valueLabel) * 0.5)), (float)(y + 7), 0xFFFFFF);
    }

    protected final void renderOptionWithValue(class_4587 poseStack, int x, int y, int width, int height, boolean hovered) {
        this.renderOptionWithValue(poseStack, x, y, width, height, hovered, -1.0f, 0);
    }

    protected final void tryRenderTooltip(class_4587 poseStack, int mouseX, int mouseY, boolean hovered) {
        if (class_437.method_25442()) {
            this.renderTooltip(poseStack, SET_TO_DEFAULT, mouseX, mouseY, hovered);
        } else if (this.isLabelTrimmed && !this.screen.isDisplayingComment()) {
            this.renderTooltip(poseStack, (class_2561)this.unmodifiedLabel, mouseX, mouseY, hovered);
        }
    }

    protected final void renderTooltip(class_4587 poseStack, class_2561 text, int mouseX, int mouseY, boolean hovered) {
        if (hovered) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(class_310.method_1551().field_1772, poseStack, text, mouseX + 2, mouseY - 16));
        }
    }

    protected final void updateLabels() {
        this.trimmedLabel = this.createTrimmedLabel();
        this.valueLabel = this.createValueLabel();
    }

    protected final class_2561 createTrimmedLabel() {
        class_5250 label = GuiUtil.shortenText(class_310.method_1551().field_1772, this.label.method_27661(), this.maxLabelWidth);
        if (this.isValueModified()) {
            label = label.method_27694(style -> style.method_27703(class_5251.method_27717((int)16763210)));
        }
        return label;
    }

    protected abstract class_2561 createValueLabel();

    public abstract boolean applyNextValue();

    public abstract boolean applyPreviousValue();

    public abstract boolean applyOriginalValue();

    public abstract boolean isValueModified();

    @Nullable
    public abstract String getCommentKey();

    @Override
    public Optional<class_2561> getCommentTitle() {
        return Optional.of(this.unmodifiedLabel);
    }

    @Override
    public Optional<class_2561> getCommentBody() {
        return Optional.ofNullable(this.getCommentKey()).map(key -> class_1074.method_4663((String)key) ? new class_2588(key) : null);
    }

    @Override
    public boolean mouseClicked(double mx, double my, int button) {
        if (button == 0 || button == 1) {
            boolean refresh = false;
            if (class_437.method_25442()) {
                refresh = this.applyOriginalValue();
            }
            if (!refresh) {
                refresh = button == 0 ? this.applyNextValue() : this.applyPreviousValue();
            }
            if (refresh) {
                this.navigation.refresh();
            }
            GuiUtil.playButtonClickSound();
            return true;
        }
        return super.mouseClicked(mx, my, button);
    }
}

