/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.BaseOptionElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.BooleanOption;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuBooleanOptionElement;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class BooleanElementWidget
extends BaseOptionElementWidget<OptionMenuBooleanOptionElement> {
    private static final class_2561 TEXT_TRUE = new class_2588("label.iris.true").method_27692(class_124.field_1060);
    private static final class_2561 TEXT_FALSE = new class_2588("label.iris.false").method_27692(class_124.field_1061);
    private final BooleanOption option;
    private boolean appliedValue;
    private boolean value;

    public BooleanElementWidget(OptionMenuBooleanOptionElement element) {
        super(element);
        this.option = element.option;
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        super.init(screen, navigation);
        this.appliedValue = ((OptionMenuBooleanOptionElement)this.element).getAppliedOptionValues().getBooleanValueOrDefault(this.option.getName());
        this.value = ((OptionMenuBooleanOptionElement)this.element).getPendingOptionValues().getBooleanValueOrDefault(this.option.getName());
        this.setLabel(GuiUtil.translateOrDefault((class_5250)new class_2585(this.option.getName()), "option." + this.option.getName(), new Object[0]));
    }

    @Override
    public void render(class_4587 poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
        this.updateRenderParams(width, 28);
        this.renderOptionWithValue(poseStack, x, y, width, height, hovered);
        this.tryRenderTooltip(poseStack, mouseX, mouseY, hovered);
    }

    @Override
    protected class_2561 createValueLabel() {
        return this.value ? TEXT_TRUE : TEXT_FALSE;
    }

    @Override
    public String getCommentKey() {
        return "option." + this.option.getName() + ".comment";
    }

    public String getValue() {
        return Boolean.toString(this.value);
    }

    private void queue() {
        Iris.getShaderPackOptionQueue().put(this.option.getName(), this.getValue());
    }

    @Override
    public boolean applyNextValue() {
        this.value = !this.value;
        this.queue();
        return true;
    }

    @Override
    public boolean applyPreviousValue() {
        return this.applyNextValue();
    }

    @Override
    public boolean applyOriginalValue() {
        this.value = this.option.getDefaultValue();
        this.queue();
        return true;
    }

    @Override
    public boolean isValueModified() {
        return this.value != this.appliedValue;
    }
}

