/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import java.util.Optional;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuLinkElement;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class LinkElementWidget
extends CommentedElementWidget<OptionMenuLinkElement> {
    private static final class_2561 ARROW = new class_2585(">");
    private final String targetScreenId;
    private final class_5250 label;
    private NavigationController navigation;
    private class_5250 trimmedLabel = null;
    private boolean isLabelTrimmed = false;

    public LinkElementWidget(OptionMenuLinkElement element) {
        super(element);
        this.targetScreenId = element.targetScreenId;
        this.label = GuiUtil.translateOrDefault((class_5250)new class_2585(element.targetScreenId), "screen." + element.targetScreenId, new Object[0]);
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        this.navigation = navigation;
    }

    @Override
    public void render(class_4587 poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
        GuiUtil.bindIrisWidgetsTexture();
        GuiUtil.drawButton(poseStack, x, y, width, height, hovered, false);
        class_327 font = class_310.method_1551().field_1772;
        int maxLabelWidth = width - 9;
        if (font.method_27525((class_5348)this.label) > maxLabelWidth) {
            this.isLabelTrimmed = true;
        }
        if (this.trimmedLabel == null) {
            this.trimmedLabel = GuiUtil.shortenText(font, this.label, maxLabelWidth);
        }
        int labelWidth = font.method_27525((class_5348)this.trimmedLabel);
        font.method_30881(poseStack, (class_2561)this.trimmedLabel, (float)(x + (int)((double)width * 0.5) - (int)((double)labelWidth * 0.5) - (int)(0.5 * (double)Math.max(labelWidth - (width - 18), 0))), (float)(y + 7), 0xFFFFFF);
        font.method_30883(poseStack, ARROW, (float)(x + width - 9), (float)(y + 7), 0xFFFFFF);
        if (hovered && this.isLabelTrimmed) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(font, poseStack, (class_2561)this.label, mouseX + 2, mouseY - 16));
        }
    }

    @Override
    public boolean mouseClicked(double mx, double my, int button) {
        if (button == 0) {
            this.navigation.open(this.targetScreenId);
            GuiUtil.playButtonClickSound();
            return true;
        }
        return super.mouseClicked(mx, my, button);
    }

    @Override
    public Optional<class_2561> getCommentTitle() {
        return Optional.of(this.label);
    }

    @Override
    public Optional<class_2561> getCommentBody() {
        String translation = "screen." + this.targetScreenId + ".comment";
        return Optional.ofNullable(class_1074.method_4663((String)translation) ? new class_2588(translation) : null);
    }
}

