/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.screen;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.ShaderPackOptionList;
import net.coderbot.iris.gui.element.ShaderPackSelectionList;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.HudHideable;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class ShaderPackScreen
extends class_437
implements HudHideable {
    public static final Set<Runnable> TOP_LAYER_RENDER_QUEUE = new HashSet<Runnable>();
    private static final class_2561 SELECT_TITLE = new class_2588("pack.iris.select.title").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    private static final class_2561 CONFIGURE_TITLE = new class_2588("pack.iris.configure.title").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    private static final int COMMENT_PANEL_WIDTH = 314;
    private final class_437 parent;
    private ShaderPackSelectionList shaderPackList;
    @Nullable
    private ShaderPackOptionList shaderOptionList = null;
    @Nullable
    private NavigationController navigation = null;
    private class_4185 screenSwitchButton;
    private class_2561 notificationDialog = null;
    private int notificationDialogTimer = 0;
    @Nullable
    private AbstractElementWidget<?> hoveredElement = null;
    private Optional<class_2561> hoveredElementCommentTitle = Optional.empty();
    private List<class_5481> hoveredElementCommentBody = new ArrayList<class_5481>();
    private int hoveredElementCommentTimer = 0;
    private boolean optionMenuOpen = false;
    private boolean dropChanges = false;

    public ShaderPackScreen(class_437 parent) {
        super((class_2561)new class_2588("options.iris.shaderPackSelection.title"));
        this.parent = parent;
        this.refreshForChangedPack();
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        if (this.field_22787.field_1687 == null) {
            this.method_25420(poseStack);
        } else {
            this.method_25296(poseStack, 0, 0, this.field_22789, this.field_22790, 1327702819, 1327702819);
        }
        if (this.optionMenuOpen && this.shaderOptionList != null) {
            this.shaderOptionList.method_25394(poseStack, mouseX, mouseY, delta);
        } else {
            this.shaderPackList.method_25394(poseStack, mouseX, mouseY, delta);
        }
        super.method_25394(poseStack, mouseX, mouseY, delta);
        super.method_25394(poseStack, mouseX, mouseY, delta);
        ShaderPackScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)((int)((double)this.field_22789 * 0.5)), (int)8, (int)0xFFFFFF);
        if (this.notificationDialog != null && this.notificationDialogTimer > 0) {
            ShaderPackScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)this.notificationDialog, (int)((int)((double)this.field_22789 * 0.5)), (int)21, (int)0xFFFFFF);
        } else if (this.optionMenuOpen) {
            ShaderPackScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)CONFIGURE_TITLE, (int)((int)((double)this.field_22789 * 0.5)), (int)21, (int)0xFFFFFF);
        } else {
            ShaderPackScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)SELECT_TITLE, (int)((int)((double)this.field_22789 * 0.5)), (int)21, (int)0xFFFFFF);
        }
        if (this.isDisplayingComment()) {
            int panelHeight = Math.max(50, 18 + this.hoveredElementCommentBody.size() * 10);
            int x = (int)(0.5 * (double)this.field_22789) - 157;
            int y = this.field_22790 - (panelHeight + 4);
            GuiUtil.drawPanel(poseStack, x, y, 314, panelHeight);
            this.field_22793.method_30881(poseStack, this.hoveredElementCommentTitle.orElse(class_2585.field_24366), (float)(x + 4), (float)(y + 4), 0xFFFFFF);
            for (int i = 0; i < this.hoveredElementCommentBody.size(); ++i) {
                this.field_22793.method_27517(poseStack, this.hoveredElementCommentBody.get(i), (float)(x + 4), (float)(y + 16 + i * 10), 0xFFFFFF);
            }
        }
        for (Runnable render : TOP_LAYER_RENDER_QUEUE) {
            render.run();
        }
        TOP_LAYER_RENDER_QUEUE.clear();
    }

    protected void method_25426() {
        super.method_25426();
        int bottomCenter = this.field_22789 / 2 - 50;
        int topCenter = this.field_22789 / 2 - 76;
        boolean inWorld = this.field_22787.field_1687 != null;
        this.method_37066((class_364)this.shaderPackList);
        this.method_37066((class_364)this.shaderOptionList);
        this.shaderPackList = new ShaderPackSelectionList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 58, 0, this.field_22789);
        if (Iris.getCurrentPack().isPresent() && this.navigation != null) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.shaderOptionList = new ShaderPackOptionList(this, this.navigation, currentPack, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 58, 0, this.field_22789);
            this.navigation.setActiveOptionList(this.shaderOptionList);
            this.shaderOptionList.rebuild();
        } else {
            this.optionMenuOpen = false;
            this.shaderOptionList = null;
        }
        if (inWorld) {
            this.shaderPackList.method_31322(false);
            if (this.shaderOptionList != null) {
                this.shaderOptionList.method_31322(false);
            }
        }
        this.method_37067();
        if (this.optionMenuOpen && this.shaderOptionList != null) {
            this.method_37063((class_364)this.shaderOptionList);
        } else {
            this.method_37063((class_364)this.shaderPackList);
        }
        this.method_37063((class_364)new class_4185(bottomCenter + 104, this.field_22790 - 27, 100, 20, class_5244.field_24334, button -> this.method_25419()));
        this.method_37063((class_364)new class_4185(bottomCenter, this.field_22790 - 27, 100, 20, (class_2561)new class_2588("options.iris.apply"), button -> this.applyChanges()));
        this.method_37063((class_364)new class_4185(bottomCenter - 104, this.field_22790 - 27, 100, 20, class_5244.field_24335, button -> this.dropChangesAndClose()));
        this.method_37063((class_364)new class_4185(topCenter - 78, this.field_22790 - 51, 152, 20, (class_2561)new class_2588("options.iris.openShaderPackFolder"), button -> this.openShaderPackFolder()));
        this.screenSwitchButton = (class_4185)this.method_37063((class_364)new class_4185(topCenter + 78, this.field_22790 - 51, 152, 20, (class_2561)new class_2588("options.iris.shaderPackList"), button -> {
            this.optionMenuOpen = !this.optionMenuOpen;
            this.method_25426();
        }));
        this.refreshScreenSwitchButton();
    }

    public void refreshForChangedPack() {
        if (Iris.getCurrentPack().isPresent()) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.navigation = new NavigationController(currentPack.getMenuContainer());
            if (this.shaderOptionList != null) {
                this.shaderOptionList.applyShaderPack(currentPack);
                this.shaderOptionList.rebuild();
            }
        } else {
            this.navigation = null;
        }
        this.refreshScreenSwitchButton();
    }

    public void refreshScreenSwitchButton() {
        if (this.screenSwitchButton != null) {
            this.screenSwitchButton.method_25355((class_2561)(this.optionMenuOpen ? new class_2588("options.iris.shaderPackList") : new class_2588("options.iris.shaderPackSettings")));
            this.screenSwitchButton.field_22763 = this.optionMenuOpen || Iris.getCurrentPack().isPresent();
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.notificationDialogTimer > 0) {
            --this.notificationDialogTimer;
        }
        this.hoveredElementCommentTimer = this.hoveredElement != null ? ++this.hoveredElementCommentTimer : 0;
    }

    public boolean method_25404(int key, int j, int k) {
        if (key == 256) {
            if (this.navigation != null && this.navigation.hasHistory()) {
                this.navigation.back();
                return true;
            }
            if (this.optionMenuOpen) {
                this.optionMenuOpen = false;
                this.method_25426();
                return true;
            }
        }
        return super.method_25404(key, j, k);
    }

    public void method_29638(List<Path> paths) {
        if (this.optionMenuOpen) {
            this.onOptionMenuFilesDrop(paths);
        } else {
            this.onPackListFilesDrop(paths);
        }
    }

    public void onPackListFilesDrop(List<Path> paths) {
        List packs = paths.stream().filter(Iris::isValidShaderpack).collect(Collectors.toList());
        for (Path pack : packs) {
            String fileName = pack.getFileName().toString();
            try {
                Iris.getShaderpacksDirectoryManager().copyPackIntoDirectory(fileName, pack);
            }
            catch (FileAlreadyExistsException e) {
                this.notificationDialog = new class_2588("options.iris.shaderPackSelection.copyErrorAlreadyExists", new Object[]{fileName}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
                this.notificationDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
            catch (IOException e) {
                Iris.logger.warn("Error copying dragged shader pack", (Throwable)e);
                this.notificationDialog = new class_2588("options.iris.shaderPackSelection.copyError", new Object[]{fileName}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
                this.notificationDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
        }
        this.shaderPackList.refresh();
        if (packs.size() == 0) {
            if (paths.size() == 1) {
                String fileName = paths.get(0).getFileName().toString();
                this.notificationDialog = new class_2588("options.iris.shaderPackSelection.failedAddSingle", new Object[]{fileName}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            } else {
                this.notificationDialog = new class_2588("options.iris.shaderPackSelection.failedAdd").method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            }
        } else if (packs.size() == 1) {
            String packName = ((Path)packs.get(0)).getFileName().toString();
            this.notificationDialog = new class_2588("options.iris.shaderPackSelection.addedPack", new Object[]{packName}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
            this.shaderPackList.select(packName);
        } else {
            this.notificationDialog = new class_2588("options.iris.shaderPackSelection.addedPacks", new Object[]{packs.size()}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
        }
        this.notificationDialogTimer = 100;
    }

    public void onOptionMenuFilesDrop(List<Path> paths) {
        if (paths.size() != 1) {
            this.notificationDialog = new class_2588("options.iris.shaderPackOptions.tooManyFiles").method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            this.notificationDialogTimer = 100;
            return;
        }
        this.importPackOptions(paths.get(0));
    }

    public void importPackOptions(Path settingFile) {
        try (InputStream in = Files.newInputStream(settingFile, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(in);
            Iris.queueShaderPackOptionsFromProperties(properties);
            this.notificationDialog = new class_2588("options.iris.shaderPackOptions.importedSettings", new Object[]{settingFile.getFileName().toString()}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
            this.notificationDialogTimer = 100;
            if (this.navigation != null) {
                this.navigation.refresh();
            }
        }
        catch (Exception e) {
            Iris.logger.error("Error importing shader settings file \"" + settingFile.toString() + "\"", (Throwable)e);
            this.notificationDialog = new class_2588("options.iris.shaderPackOptions.failedImport", new Object[]{settingFile.getFileName().toString()}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            this.notificationDialogTimer = 100;
        }
    }

    public void method_25419() {
        if (!this.dropChanges) {
            this.applyChanges();
        } else {
            this.discardChanges();
        }
        this.field_22787.method_1507(this.parent);
    }

    private void dropChangesAndClose() {
        this.dropChanges = true;
        this.method_25419();
    }

    public void applyChanges() {
        ShaderPackSelectionList.BaseEntry base = (ShaderPackSelectionList.BaseEntry)this.shaderPackList.method_25334();
        if (!(base instanceof ShaderPackSelectionList.ShaderPackEntry)) {
            return;
        }
        ShaderPackSelectionList.ShaderPackEntry entry = (ShaderPackSelectionList.ShaderPackEntry)base;
        this.shaderPackList.setApplied(entry);
        String name = entry.getPackName();
        if (!name.equals(Iris.getCurrentPackName())) {
            Iris.clearShaderPackOptionQueue();
        }
        Iris.getIrisConfig().setShaderPackName(name);
        boolean enabled = this.shaderPackList.getTopButtonRow().shadersEnabled;
        IrisApi.getInstance().getConfig().setShadersEnabledAndApply(enabled);
        this.refreshForChangedPack();
    }

    private void discardChanges() {
        Iris.clearShaderPackOptionQueue();
    }

    private void openShaderPackFolder() {
        class_156.method_668().method_673(Iris.getShaderpacksDirectoryManager().getDirectoryUri());
    }

    public void setElementHoveredStatus(AbstractElementWidget<?> widget, boolean hovered) {
        if (hovered && widget != this.hoveredElement) {
            this.hoveredElement = widget;
            if (widget instanceof CommentedElementWidget) {
                this.hoveredElementCommentTitle = ((CommentedElementWidget)widget).getCommentTitle();
                Optional<class_2561> commentBody = ((CommentedElementWidget)widget).getCommentBody();
                if (!commentBody.isPresent()) {
                    this.hoveredElementCommentBody.clear();
                } else {
                    String rawCommentBody = commentBody.get().getString();
                    if (rawCommentBody.endsWith(".")) {
                        rawCommentBody = rawCommentBody.substring(0, rawCommentBody.length() - 1);
                    }
                    List splitByPeriods = Arrays.stream(rawCommentBody.split("\\. [ ]*")).map(class_2585::new).collect(Collectors.toList());
                    this.hoveredElementCommentBody = new ArrayList<class_5481>();
                    for (class_5250 text : splitByPeriods) {
                        this.hoveredElementCommentBody.addAll(this.field_22793.method_1728((class_5348)text, 306));
                    }
                }
            } else {
                this.hoveredElementCommentTitle = Optional.empty();
                this.hoveredElementCommentBody.clear();
            }
            this.hoveredElementCommentTimer = 0;
        } else if (!hovered && widget == this.hoveredElement) {
            this.hoveredElement = null;
            this.hoveredElementCommentTitle = Optional.empty();
            this.hoveredElementCommentBody.clear();
            this.hoveredElementCommentTimer = 0;
        }
    }

    public boolean isDisplayingComment() {
        return this.hoveredElementCommentTimer > 20 && this.hoveredElementCommentTitle.isPresent() && !this.hoveredElementCommentBody.isEmpty();
    }
}

