/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.layer;

import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.layer.GbufferProgram;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.class_1921;

public class GbufferPrograms {
    private static boolean entities;
    private static boolean blockEntities;
    private static Runnable phaseChangeListener;

    private static GbufferProgram refine(GbufferProgram program, boolean push) {
        if (program == GbufferProgram.ENTITIES || program == GbufferProgram.TERRAIN || program == GbufferProgram.TRANSLUCENT_TERRAIN) {
            if (HandRenderer.INSTANCE.isActive()) {
                return HandRenderer.INSTANCE.isRenderingSolid() ? GbufferProgram.HAND : GbufferProgram.HAND_TRANSLUCENT;
            }
            if (entities) {
                return GbufferProgram.ENTITIES;
            }
            if (blockEntities) {
                return GbufferProgram.BLOCK_ENTITIES;
            }
        }
        if (program == GbufferProgram.DAMAGED_BLOCKS) {
            GbufferPrograms.setPhase(push ? WorldRenderingPhase.DESTROY : WorldRenderingPhase.NONE);
        } else if (program == GbufferProgram.LINES) {
            GbufferPrograms.setPhase(push ? WorldRenderingPhase.OUTLINE : WorldRenderingPhase.NONE);
        }
        return program;
    }

    public static WorldRenderingPhase refineTerrainPhase(class_1921 renderType) {
        if (renderType == class_1921.method_23577()) {
            return WorldRenderingPhase.TERRAIN_SOLID;
        }
        if (renderType == class_1921.method_23581()) {
            return WorldRenderingPhase.TERRAIN_CUTOUT;
        }
        if (renderType == class_1921.method_23579()) {
            return WorldRenderingPhase.TERRAIN_CUTOUT_MIPPED;
        }
        if (renderType == class_1921.method_23583()) {
            return WorldRenderingPhase.TERRAIN_TRANSLUCENT;
        }
        if (renderType == class_1921.method_29997()) {
            return WorldRenderingPhase.TRIPWIRE;
        }
        throw new IllegalStateException("Illegal render type!");
    }

    public static void beginEntities() {
        if (entities || blockEntities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call beginEntities when entities = " + entities + ", blockEntities = " + blockEntities);
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.ENTITIES);
        entities = true;
    }

    public static boolean isRenderingEntities() {
        return entities;
    }

    public static void endEntities() {
        if (!entities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endEntities when entities = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        entities = false;
    }

    public static void beginBlockEntities() {
        if (entities || blockEntities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call beginBlockEntities when entities = " + entities + ", blockEntities = " + blockEntities);
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.BLOCK_ENTITIES);
        blockEntities = true;
    }

    public static boolean isRenderingBlockEntities() {
        return blockEntities;
    }

    public static void endBlockEntities() {
        if (!blockEntities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endBlockEntities when blockEntities = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        blockEntities = false;
    }

    public static void push(GbufferProgram program) {
        program = GbufferPrograms.refine(program, true);
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            pipeline.pushProgram(program);
        }
    }

    public static void pop(GbufferProgram program) {
        program = GbufferPrograms.refine(program, false);
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            pipeline.popProgram(program);
        }
    }

    public static WorldRenderingPhase getCurrentPhase() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            return pipeline.getPhase();
        }
        return WorldRenderingPhase.NONE;
    }

    public static void setPhase(WorldRenderingPhase phase) {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            pipeline.setPhase(phase);
        }
    }

    public static void runPhaseChangeNotifier() {
        if (phaseChangeListener != null) {
            phaseChangeListener.run();
        }
    }

    static {
        StateUpdateNotifiers.phaseChangeNotifier = listener -> {
            phaseChangeListener = listener;
        };
    }
}

