/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin;

import net.coderbot.iris.Iris;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4494;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_5944;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_759;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_757.class})
@Environment(value=EnvType.CLIENT)
public class MixinGameRenderer {
    @Shadow
    private boolean field_3992;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void iris$logSystem(class_310 client, class_3300 resourceManager, class_4599 bufferBuilderStorage, CallbackInfo ci) {
        Iris.logger.info("Hardware information:");
        Iris.logger.info("CPU: " + class_4494.method_22089());
        Iris.logger.info("GPU: " + class_4494.method_22090() + " (Supports OpenGL " + class_4494.method_22091() + ")");
        Iris.logger.info("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")");
    }

    @Redirect(method={"renderItemInHand"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;renderHandsWithItems(FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/player/LocalPlayer;I)V"))
    private void disableVanillaHandRendering(class_759 itemInHandRenderer, float tickDelta, class_4587 poseStack, class_4597.class_4598 bufferSource, class_746 localPlayer, int light) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            return;
        }
        itemInHandRenderer.method_22976(tickDelta, poseStack, bufferSource, localPlayer, light);
    }

    @Inject(method={"getPositionShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overridePositionShader(CallbackInfoReturnable<class_5944> cir) {
        if (MixinGameRenderer.isSky()) {
            MixinGameRenderer.override(ShaderKey.SKY_BASIC, cir);
        } else if (!ShadowRenderer.ACTIVE && MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.BASIC, cir);
        }
    }

    @Inject(method={"getPositionColorShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overridePositionColorShader(CallbackInfoReturnable<class_5944> cir) {
        if (MixinGameRenderer.isSky()) {
            MixinGameRenderer.override(ShaderKey.SKY_BASIC_COLOR, cir);
        } else if (!ShadowRenderer.ACTIVE && MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.BASIC_COLOR, cir);
        }
    }

    @Inject(method={"getPositionTexShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overridePositionTexShader(CallbackInfoReturnable<class_5944> cir) {
        if (MixinGameRenderer.isSky()) {
            MixinGameRenderer.override(ShaderKey.SKY_TEXTURED, cir);
        } else if (!ShadowRenderer.ACTIVE && MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.TEXTURED, cir);
        }
    }

    @Inject(method={"getPositionTexColorShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overridePositionTexColorShader(CallbackInfoReturnable<class_5944> cir) {
        if (MixinGameRenderer.isSky()) {
            MixinGameRenderer.override(ShaderKey.SKY_TEXTURED_COLOR, cir);
        } else if (!ShadowRenderer.ACTIVE && MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.TEXTURED_COLOR, cir);
        }
    }

    @Inject(method={"getParticleShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideParticleShader(CallbackInfoReturnable<class_5944> cir) {
        if (MixinGameRenderer.isPhase(WorldRenderingPhase.RAIN_SNOW)) {
            MixinGameRenderer.override(ShaderKey.WEATHER, cir);
        } else if (MixinGameRenderer.isRenderingWorld() && !ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.PARTICLES, cir);
        }
    }

    @Inject(method={"getPositionTexColorNormalShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overridePositionTexColorNormalShader(CallbackInfoReturnable<class_5944> cir) {
        MixinGameRenderer.override(ShaderKey.CLOUDS, cir);
    }

    @Inject(method={"getRendertypeSolidShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideSolidShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_TERRAIN_CUTOUT, cir);
        } else {
            MixinGameRenderer.override(ShaderKey.TERRAIN_SOLID, cir);
        }
    }

    @Inject(method={"getRendertypeCutoutMippedShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideCutoutMippedShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_TERRAIN_CUTOUT, cir);
        } else {
            MixinGameRenderer.override(ShaderKey.TERRAIN_CUTOUT_MIPPED, cir);
        }
    }

    @Inject(method={"getRendertypeCutoutShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideCutoutShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_TERRAIN_CUTOUT, cir);
        } else {
            MixinGameRenderer.override(ShaderKey.TERRAIN_CUTOUT, cir);
        }
    }

    @Inject(method={"getRendertypeTranslucentShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideTranslucentShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_TERRAIN_CUTOUT, cir);
        } else {
            MixinGameRenderer.override(ShaderKey.TERRAIN_TRANSLUCENT, cir);
        }
    }

    @Inject(method={"getRendertypeTripwireShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideTripwireShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_TERRAIN_CUTOUT, cir);
        } else {
            MixinGameRenderer.override(ShaderKey.TERRAIN_TRANSLUCENT, cir);
        }
    }

    @Inject(method={"getRendertypeEntityCutoutShader", "getRendertypeEntityCutoutNoCullShader", "getRendertypeEntityCutoutNoCullZOffsetShader", "getRendertypeEntitySmoothCutoutShader", "getRendertypeEntityTranslucentShader", "getRendertypeEntityTranslucentCullShader", "getRendertypeItemEntityTranslucentCullShader", "getRendertypeArmorCutoutNoCullShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideEntityCutoutShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_ENTITIES_CUTOUT, cir);
        } else if (HandRenderer.INSTANCE.isActive()) {
            MixinGameRenderer.override(HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE, cir);
        } else if (GbufferPrograms.isRenderingBlockEntities()) {
            MixinGameRenderer.override(ShaderKey.BLOCK_ENTITY_DIFFUSE, cir);
        } else if (MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.ENTITIES_CUTOUT_DIFFUSE, cir);
        }
    }

    @Inject(method={"getRendertypeEnergySwirlShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideEnergySwirlShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_ENTITIES_CUTOUT, cir);
        } else if (HandRenderer.INSTANCE.isActive()) {
            MixinGameRenderer.override(HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT : ShaderKey.HAND_TRANSLUCENT, cir);
        } else if (GbufferPrograms.isRenderingBlockEntities()) {
            MixinGameRenderer.override(ShaderKey.BLOCK_ENTITY, cir);
        } else if (MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.ENTITIES_CUTOUT, cir);
        }
    }

    @Inject(method={"getRendertypeGlintShader", "getRendertypeGlintDirectShader", "getRendertypeGlintTranslucentShader", "getRendertypeArmorGlintShader", "getRendertypeEntityGlintDirectShader", "getRendertypeEntityGlintShader", "getRendertypeArmorEntityGlintShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideGlintShader(CallbackInfoReturnable<class_5944> cir) {
        if (MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.GLINT, cir);
        }
    }

    @Inject(method={"getRendertypeEntitySolidShader", "getRendertypeEntityNoOutlineShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideEntitySolidDiffuseShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_ENTITIES_CUTOUT, cir);
        } else if (HandRenderer.INSTANCE.isActive()) {
            MixinGameRenderer.override(HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE, cir);
        } else if (GbufferPrograms.isRenderingBlockEntities()) {
            MixinGameRenderer.override(ShaderKey.BLOCK_ENTITY_DIFFUSE, cir);
        } else if (MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.ENTITIES_SOLID_DIFFUSE, cir);
        }
    }

    @Inject(method={"getRendertypeWaterMaskShader", "getRendertypeEntityShadowShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideEntitySolidShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_ENTITIES_CUTOUT, cir);
        } else if (HandRenderer.INSTANCE.isActive()) {
            MixinGameRenderer.override(HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT : ShaderKey.HAND_TRANSLUCENT, cir);
        } else if (GbufferPrograms.isRenderingBlockEntities()) {
            MixinGameRenderer.override(ShaderKey.BLOCK_ENTITY, cir);
        } else if (MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.ENTITIES_SOLID, cir);
        }
    }

    @Inject(method={"getRendertypeBeaconBeamShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideBeaconBeamShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_BEACON_BEAM, cir);
        } else {
            MixinGameRenderer.override(ShaderKey.BEACON, cir);
        }
    }

    @Inject(method={"getRendertypeEyesShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideEntityEyesShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_ENTITIES_CUTOUT, cir);
        } else if (GbufferPrograms.isRenderingBlockEntities()) {
            MixinGameRenderer.override(ShaderKey.BLOCK_ENTITY, cir);
        } else if (MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.ENTITIES_EYES, cir);
        }
    }

    @Inject(method={"getRendertypeLeashShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideLeashShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            return;
        }
        if (MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.LEASH, cir);
        }
    }

    @Inject(method={"getRendertypeLightningShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideLightningShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            return;
        }
        if (MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.LIGHTNING, cir);
        }
    }

    @Inject(method={"getRendertypeCrumblingShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideCrumblingShader(CallbackInfoReturnable<class_5944> cir) {
        if (MixinGameRenderer.isRenderingWorld() && !ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.CRUMBLING, cir);
        }
    }

    @Inject(method={"getRendertypeTextShader", "getRendertypeTextSeeThroughShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideTextShader(CallbackInfoReturnable<class_5944> cir) {
        if (MixinGameRenderer.isRenderingWorld() && !ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.TEXT, cir);
        }
    }

    @Inject(method={"getRendertypeTextIntensityShader", "getRendertypeTextIntensitySeeThroughShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideTextIntensityShader(CallbackInfoReturnable<class_5944> cir) {
        if (MixinGameRenderer.isRenderingWorld() && !ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.TEXT_INTENSITY, cir);
        }
    }

    @Inject(method={"getRendertypeEndGatewayShader", "getRendertypeEndPortalShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideEndPortalShader(CallbackInfoReturnable<class_5944> cir) {
        if (!ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.BLOCK_ENTITY, cir);
        }
    }

    @Inject(method={"getRendertypeLinesShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iris$overrideLinesShader(CallbackInfoReturnable<class_5944> cir) {
        if (ShadowRenderer.ACTIVE) {
            MixinGameRenderer.override(ShaderKey.SHADOW_LINES, cir);
        } else if (MixinGameRenderer.isRenderingWorld()) {
            MixinGameRenderer.override(ShaderKey.LINES, cir);
        }
    }

    private static boolean isSky() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            switch (pipeline.getPhase()) {
                case SKY: 
                case SUNSET: 
                case SUN: 
                case STARS: 
                case VOID: 
                case MOON: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean isPhase(WorldRenderingPhase phase) {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            return pipeline.getPhase() == phase;
        }
        return false;
    }

    private static boolean isRenderingWorld() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof CoreWorldRenderingPipeline) {
            return ((CoreWorldRenderingPipeline)pipeline).isRenderingWorld();
        }
        return false;
    }

    private static void override(ShaderKey key, CallbackInfoReturnable<class_5944> cir) {
        class_5944 override;
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof CoreWorldRenderingPipeline && (override = ((CoreWorldRenderingPipeline)pipeline).getShaderMap().getShader(key)) != null) {
            cir.setReturnValue((Object)override);
        }
    }
}

