/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.coderbot.iris.HorizonRenderer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
@Environment(value=EnvType.CLIENT)
public class MixinLevelRenderer {
    private static final String RENDER = "Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V";
    private static final String CLEAR = "Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V";
    private static final String RENDER_SKY = "Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FLjava/lang/Runnable;)V";
    private static final String RENDER_CLOUDS = "Lnet/minecraft/client/renderer/LevelRenderer;renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FDDD)V";
    private static final String RENDER_WEATHER = "Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V";
    @Shadow
    @Final
    private class_310 field_4088;
    @Unique
    private HorizonRenderer horizonRenderer = new HorizonRenderer();
    @Unique
    private int previousViewDistance;
    @Unique
    private WorldRenderingPipeline pipeline;

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V", shift=At.Shift.AFTER, remap=false)})
    private void iris$beginLevelRender(class_4587 poseStack, float tickDelta, long startTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        if (Iris.isSodiumInvalid()) {
            throw new IllegalStateException("An invalid version of Sodium is installed, and the warning screen somehow didn't work. This is a bug! Please report it to the Iris developers.");
        }
        CapturedRenderingState.INSTANCE.setGbufferModelView(poseStack.method_23760().method_23761());
        CapturedRenderingState.INSTANCE.setGbufferProjection(projection);
        CapturedRenderingState.INSTANCE.setTickDelta(tickDelta);
        SystemTimeUniforms.COUNTER.beginFrame();
        SystemTimeUniforms.TIMER.beginFrame(startTime);
        if (this.previousViewDistance != this.field_4088.field_1690.method_38521()) {
            this.horizonRenderer.close();
            this.horizonRenderer = new HorizonRenderer();
            this.previousViewDistance = this.field_4088.field_1690.method_38521();
        }
        this.pipeline = Iris.getPipelineManager().preparePipeline(Iris.getCurrentDimension());
        this.pipeline.beginLevelRendering();
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V"}, at={@At(value="RETURN", shift=At.Shift.BEFORE)})
    private void iris$endLevelRender(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo callback) {
        HandRenderer.INSTANCE.renderTranslucent(poseStack, tickDelta, camera, gameRenderer, this.pipeline);
        class_310.method_1551().method_16011().method_15405("iris_final");
        this.pipeline.finalizeLevelRendering();
        this.pipeline = null;
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V", shift=At.Shift.AFTER)})
    private void iris$renderTerrainShadows(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo callback) {
        this.pipeline.renderShadows((LevelRendererAccessor)((Object)this), camera);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FLjava/lang/Runnable;)V")})
    private void iris$beginSky(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.SKY);
        RenderSystem.setShader(class_757::method_34539);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;levelFogColor()V")})
    private void iris$renderSky$drawHorizon(class_4587 poseStack, class_1159 projectionMatrix, float f, Runnable runnable, CallbackInfo callback) {
        RenderSystem.depthMask((boolean)false);
        Vector3d fogColor = CapturedRenderingState.INSTANCE.getFogColor();
        RenderSystem.setShaderColor((float)((float)fogColor.x), (float)((float)fogColor.y), (float)((float)fogColor.z), (float)1.0f);
        this.horizonRenderer.renderHorizon(poseStack.method_23760().method_23761().method_22673(), projectionMatrix.method_22673(), class_757.method_34539());
        RenderSystem.depthMask((boolean)true);
    }

    @Inject(method={"renderSky"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;SUN_LOCATION:Lnet/minecraft/resources/ResourceLocation;")})
    private void iris$setSunRenderStage(class_4587 poseStack, class_1159 matrix4f, float f, Runnable runnable, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.SUN);
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;getSunriseColor(FF)[F")})
    private void iris$setSunsetRenderStage(class_4587 poseStack, class_1159 matrix4f, float f, Runnable runnable, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.SUNSET);
    }

    @Inject(method={"renderSky"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;MOON_LOCATION:Lnet/minecraft/resources/ResourceLocation;")})
    private void iris$setMoonRenderStage(class_4587 poseStack, class_1159 matrix4f, float f, Runnable runnable, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.MOON);
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getStarBrightness(F)F")})
    private void iris$setStarRenderStage(class_4587 poseStack, class_1159 matrix4f, float f, Runnable runnable, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.STARS);
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getEyePosition(F)Lnet/minecraft/world/phys/Vec3;")})
    private void iris$setVoidRenderStage(class_4587 poseStack, class_1159 matrix4f, float f, Runnable runnable, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.VOID);
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getTimeOfDay(F)F")}, slice={@Slice(from=@At(value="FIELD", target="com/mojang/math/Vector3f.YP : Lcom/mojang/math/Vector3f;"))})
    private void iris$renderSky$tiltSun(class_4587 poseStack, class_1159 projectionMatrix, float f, Runnable runnable, CallbackInfo callback) {
        poseStack.method_22907(class_1160.field_20707.method_23214(this.pipeline.getSunPathRotation()));
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FLjava/lang/Runnable;)V", shift=At.Shift.AFTER)})
    private void iris$endSky(class_4587 poseStack, float f, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FDDD)V")})
    private void iris$beginClouds(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.CLOUDS);
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$maybeRemoveClouds(class_4587 poseStack, class_1159 matrix4f, float f, double d, double e, double g, CallbackInfo ci) {
        if (!this.pipeline.shouldRenderClouds()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FDDD)V", shift=At.Shift.AFTER)})
    private void iris$endClouds(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"renderChunkLayer"}, at={@At(value="HEAD")})
    private void iris$beginTerrainLayer(class_1921 renderType, class_4587 poseStack, double d, double e, double f, class_1159 matrix4f, CallbackInfo ci) {
        this.pipeline.setPhase(GbufferPrograms.refineTerrainPhase(renderType));
    }

    @Inject(method={"renderChunkLayer"}, at={@At(value="RETURN")})
    private void iris$endTerrainLayer(class_1921 renderType, class_4587 poseStack, double d, double e, double f, class_1159 matrix4f, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V")})
    private void iris$beginWeather(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.RAIN_SNOW);
    }

    @ModifyArg(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;depthMask(Z)V", ordinal=0))
    private boolean iris$writeRainAndSnowToDepthBuffer(boolean depthMaskEnabled) {
        if (this.pipeline.shouldWriteRainAndSnowToDepthBuffer()) {
            return true;
        }
        return depthMaskEnabled;
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V", shift=At.Shift.AFTER)})
    private void iris$endWeather(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderWorldBorder(Lnet/minecraft/client/Camera;)V")})
    private void iris$beginWorldBorder(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.WORLD_BORDER);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderWorldBorder(Lnet/minecraft/client/Camera;)V", shift=At.Shift.AFTER)})
    private void iris$endWorldBorder(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/debug/DebugRenderer;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;DDD)V")})
    private void iris$setDebugRenderStage(class_4587 poseStack, float f, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.DEBUG);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/debug/DebugRenderer;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;DDD)V", shift=At.Shift.AFTER)})
    private void iris$resetDebugRenderStage(class_4587 poseStack, float f, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"renderLevel"}, at={@At(value="CONSTANT", args={"stringValue=translucent"})})
    private void iris$beginTranslucents(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo ci) {
        this.pipeline.beginHand();
        HandRenderer.INSTANCE.renderSolid(poseStack, tickDelta, camera, gameRenderer, this.pipeline);
        class_310.method_1551().method_16011().method_15405("iris_pre_translucent");
        this.pipeline.beginTranslucents();
    }
}

