/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.bettermipmaps;

import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1058.class})
public class MixinTextureAtlasSprite {
    private static final float[] SRGB_TO_LINEAR = new float[256];

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/MipmapGenerator;generateMipLevels(Lcom/mojang/blaze3d/platform/NativeImage;I)[Lcom/mojang/blaze3d/platform/NativeImage;")})
    private void fillInTransparentPixelColors(class_1059 textureAtlas, class_1058.class_4727 info, int i, int j, int k, int l, int m, class_1011 nativeImage, CallbackInfo ci) {
        if (info.method_24121().method_12832().contains("leaves")) {
            return;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalAlpha = 0.0f;
        for (int y = 0; y < nativeImage.method_4323(); ++y) {
            for (int x = 0; x < nativeImage.method_4307(); ++x) {
                int color = nativeImage.method_4315(x, y);
                int alpha = color >> 24 & 0xFF;
                if (alpha == 0) continue;
                totalAlpha += (float)alpha;
                r += MixinTextureAtlasSprite.unpackLinearComponent(color, 0) * (float)alpha;
                g += MixinTextureAtlasSprite.unpackLinearComponent(color, 8) * (float)alpha;
                b += MixinTextureAtlasSprite.unpackLinearComponent(color, 16) * (float)alpha;
            }
        }
        r /= totalAlpha;
        g /= totalAlpha;
        b /= totalAlpha;
        if (totalAlpha == 0.0f) {
            return;
        }
        int resultColor = MixinTextureAtlasSprite.packLinearToSrgb(r, g, b);
        for (int y = 0; y < nativeImage.method_4323(); ++y) {
            for (int x = 0; x < nativeImage.method_4307(); ++x) {
                int color = nativeImage.method_4315(x, y);
                int alpha = color >> 24 & 0xFF;
                if (alpha > 0) continue;
                nativeImage.method_4305(x, y, resultColor);
            }
        }
    }

    @Unique
    private static float unpackLinearComponent(int color, int shift) {
        return SRGB_TO_LINEAR[color >> shift & 0xFF];
    }

    @Unique
    private static int packLinearToSrgb(float r, float g, float b) {
        int srgbR = (int)(Math.pow(r, 0.45454545454545453) * 255.0);
        int srgbG = (int)(Math.pow(g, 0.45454545454545453) * 255.0);
        int srgbB = (int)(Math.pow(b, 0.45454545454545453) * 255.0);
        return srgbB << 16 | srgbG << 8 | srgbR;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MixinTextureAtlasSprite.SRGB_TO_LINEAR[i] = (float)Math.pow((double)i / 255.0, 2.2);
        }
    }
}

