/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.vertices;

import java.nio.ByteBuffer;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.BlockSensitiveBufferBuilder;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import net.coderbot.iris.vertices.QuadView;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4584;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_287.class})
public abstract class MixinBufferBuilder
implements class_4584,
BlockSensitiveBufferBuilder {
    @Unique
    boolean extending;
    @Unique
    private int vertexCount;
    @Unique
    private QuadView quad = new QuadView();
    @Unique
    private Vector3f normal = new Vector3f();
    @Unique
    private int normalOffset;
    @Unique
    private short currentBlock;
    @Unique
    private short currentRenderType;
    @Shadow
    private boolean field_21594;
    @Shadow
    private boolean field_21595;
    @Shadow
    private ByteBuffer field_1555;
    @Shadow
    private class_293 field_1565;
    @Shadow
    private int field_20884;
    @Shadow
    @Nullable
    private class_296 field_1558;

    @Inject(method={"begin"}, at={@At(value="HEAD")})
    private void iris$onBegin(class_293.class_5596 drawMode, class_293 format, CallbackInfo ci) {
        this.extending = format == class_290.field_1590 || format == IrisVertexFormats.TERRAIN;
        this.vertexCount = 0;
        if (this.extending) {
            this.normalOffset = format.method_1357().indexOf((Object)class_290.field_1579);
        }
    }

    @Inject(method={"begin"}, at={@At(value="RETURN")})
    private void iris$afterBegin(class_293.class_5596 drawMode, class_293 format, CallbackInfo ci) {
        if (this.extending) {
            this.field_1565 = IrisVertexFormats.TERRAIN;
            this.field_1558 = (class_296)IrisVertexFormats.TERRAIN.method_1357().get(0);
        }
    }

    @Inject(method={"discard()V"}, at={@At(value="HEAD")})
    private void iris$onDiscard(CallbackInfo ci) {
        this.extending = false;
        this.vertexCount = 0;
    }

    @Inject(method={"switchFormat"}, at={@At(value="RETURN")})
    private void iris$preventHardcodedVertexWriting(class_293 format, CallbackInfo ci) {
        if (!this.extending) {
            return;
        }
        this.field_21594 = false;
        this.field_21595 = false;
    }

    @Inject(method={"endVertex"}, at={@At(value="HEAD")})
    private void iris$beforeNext(CallbackInfo ci) {
        int vertex;
        if (!this.extending) {
            return;
        }
        this.method_22897(0, this.currentBlock);
        this.method_22897(4, this.currentRenderType);
        this.method_22897(8, -1.0f);
        this.method_22897(12, -1.0f);
        this.method_1325();
        this.method_22897(0, 0.0f);
        this.method_22897(4, 0.0f);
        this.method_1325();
        this.method_22897(0, 1.0f);
        this.method_22897(4, 0.0f);
        this.method_22897(8, 0.0f);
        this.method_22897(12, 1.0f);
        this.method_1325();
        ++this.vertexCount;
        if (this.vertexCount < 4) {
            return;
        }
        this.vertexCount = 0;
        int extendedDataLength = 40;
        int stride = this.field_1565.method_1362();
        this.quad.setup(this.field_1555, this.field_20884, stride);
        NormalHelper.computeFaceNormal(this.normal, this.quad);
        int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
        this.field_1555.putInt(this.field_20884 - 4 - extendedDataLength, packedNormal);
        this.field_1555.putInt(this.field_20884 - 4 - extendedDataLength - stride, packedNormal);
        this.field_1555.putInt(this.field_20884 - 4 - extendedDataLength - stride * 2, packedNormal);
        this.field_1555.putInt(this.field_20884 - 4 - extendedDataLength - stride * 3, packedNormal);
        this.computeTangents();
        float midU = 0.0f;
        float midV = 0.0f;
        for (vertex = 0; vertex < 4; ++vertex) {
            midU += this.quad.u(vertex);
            midV += this.quad.v(vertex);
        }
        midU = (float)((double)midU * 0.25);
        midV = (float)((double)midV * 0.25);
        for (vertex = 0; vertex < 4; ++vertex) {
            this.field_1555.putFloat(this.field_20884 - 24 - stride * vertex, midU);
            this.field_1555.putFloat(this.field_20884 - 20 - stride * vertex, midV);
        }
    }

    @Override
    public void beginBlock(short block, short renderType) {
        this.currentBlock = block;
        this.currentRenderType = renderType;
    }

    @Override
    public void endBlock() {
        this.currentBlock = (short)-1;
        this.currentRenderType = (short)-1;
    }

    private void computeTangents() {
        float deltaV1;
        float deltaU2;
        float x0 = this.quad.x(0);
        float y0 = this.quad.y(0);
        float z0 = this.quad.z(0);
        float x1 = this.quad.x(1);
        float y1 = this.quad.y(1);
        float z1 = this.quad.z(1);
        float x2 = this.quad.x(2);
        float y2 = this.quad.y(2);
        float z2 = this.quad.z(2);
        float edge1x = x1 - x0;
        float edge1y = y1 - y0;
        float edge1z = z1 - z0;
        float edge2x = x2 - x0;
        float edge2y = y2 - y0;
        float edge2z = z2 - z0;
        float u0 = this.quad.u(0);
        float v0 = this.quad.v(0);
        float u1 = this.quad.u(1);
        float v1 = this.quad.v(1);
        float u2 = this.quad.u(2);
        float deltaU1 = u1 - u0;
        float v2 = this.quad.v(2);
        float deltaV2 = v2 - v0;
        float fdenom = deltaU1 * deltaV2 - (deltaU2 = u2 - u0) * (deltaV1 = v1 - v0);
        float f = (double)fdenom == 0.0 ? 1.0f : 1.0f / fdenom;
        float tangentx = f * (deltaV2 * edge1x - deltaV1 * edge2x);
        float tangenty = f * (deltaV2 * edge1y - deltaV1 * edge2y);
        float tangentz = f * (deltaV2 * edge1z - deltaV1 * edge2z);
        float tcoeff = MixinBufferBuilder.rsqrt(tangentx * tangentx + tangenty * tangenty + tangentz * tangentz);
        tangentx *= tcoeff;
        tangenty *= tcoeff;
        float bitangentx = f * (-deltaU2 * edge1x + deltaU1 * edge2x);
        float bitangenty = f * (-deltaU2 * edge1y + deltaU1 * edge2y);
        float bitangentz = f * (-deltaU2 * edge1z + deltaU1 * edge2z);
        float bitcoeff = MixinBufferBuilder.rsqrt(bitangentx * bitangentx + bitangenty * bitangenty + bitangentz * bitangentz);
        float pbitangentx = tangenty * this.normal.z - (tangentz *= tcoeff) * this.normal.y;
        float pbitangenty = -(tangentx * this.normal.z - tangentz * this.normal.x);
        float pbitangentz = tangentx * this.normal.x - tangenty * this.normal.y;
        float dot = (bitangentx *= bitcoeff) * pbitangentx + (bitangenty *= bitcoeff) * pbitangenty + (bitangentz *= bitcoeff) * pbitangentz;
        float tangentW = dot < 0.0f ? -1.0f : 1.0f;
        int tangent = NormalHelper.packNormal(tangentx, tangenty, tangentz, tangentW);
        int stride = this.field_1565.method_1362();
        for (int vertex = 0; vertex < 4; ++vertex) {
            this.field_1555.putFloat(this.field_20884 - 16 - stride * vertex, tangentx);
            this.field_1555.putFloat(this.field_20884 - 12 - stride * vertex, tangenty);
            this.field_1555.putFloat(this.field_20884 - 8 - stride * vertex, tangentz);
            this.field_1555.putFloat(this.field_20884 - 4 - stride * vertex, 1.0f);
        }
    }

    @Unique
    private static float rsqrt(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        return (float)(1.0 / Math.sqrt(value));
    }
}

