/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import net.coderbot.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.coderbot.iris.mixin.GameRendererAccessor;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_1159;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1934;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_757;

public class HandRenderer {
    public static final HandRenderer INSTANCE = new HandRenderer();
    private boolean ACTIVE;
    private boolean renderingSolid;
    private FullyBufferedMultiBufferSource bufferSource = new FullyBufferedMultiBufferSource();

    private void setupGlState(class_757 gameRenderer, class_4184 camera, class_4587 poseStack, float tickDelta) {
        class_4587.class_4665 pose = poseStack.method_23760();
        class_1159 scaleMatrix = class_1159.method_24019((float)1.0f, (float)1.0f, (float)0.125f);
        scaleMatrix.method_22672(gameRenderer.method_22973(((GameRendererAccessor)gameRenderer).invokeGetFov(camera, tickDelta, false)));
        gameRenderer.method_22709(scaleMatrix);
        pose.method_23761().method_22668();
        pose.method_23762().method_22856();
        ((GameRendererAccessor)gameRenderer).invokeBobHurt(poseStack, tickDelta);
        if (class_310.method_1551().field_1690.field_1891) {
            ((GameRendererAccessor)gameRenderer).invokeBobView(poseStack, tickDelta);
        }
    }

    private boolean canRender(class_4184 camera, class_757 gameRenderer) {
        return ((GameRendererAccessor)gameRenderer).getRenderHand() && !camera.method_19333() && camera.method_19331() instanceof class_1657 && !((GameRendererAccessor)gameRenderer).getPanoramicMode() && !class_310.method_1551().field_1690.field_1842 && (!(camera.method_19331() instanceof class_1309) || !((class_1309)camera.method_19331()).method_6113()) && class_310.method_1551().field_1761.method_2920() != class_1934.field_9219;
    }

    public boolean isHandTranslucent(class_1268 hand) {
        class_1792 item = class_310.method_1551().field_1724.method_6118(hand == class_1268.field_5810 ? class_1304.field_6171 : class_1304.field_6173).method_7909();
        if (item instanceof class_1747) {
            return class_4696.method_23679((class_2680)((class_1747)item).method_7711().method_9564()) == class_1921.method_23583();
        }
        return false;
    }

    public boolean isAnyHandTranslucent() {
        return this.isHandTranslucent(class_1268.field_5808) || this.isHandTranslucent(class_1268.field_5810);
    }

    public void renderSolid(class_4587 poseStack, float tickDelta, class_4184 camera, class_757 gameRenderer, WorldRenderingPipeline pipeline) {
        if (!this.canRender(camera, gameRenderer) || !IrisApi.getInstance().isShaderPackInUse()) {
            return;
        }
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_SOLID);
        poseStack.method_22903();
        class_310.method_1551().method_16011().method_15396("iris_hand");
        this.setupGlState(gameRenderer, camera, poseStack, tickDelta);
        this.renderingSolid = true;
        class_310.method_1551().method_1489().method_22976(tickDelta, poseStack, (class_4597.class_4598)this.bufferSource, class_310.method_1551().field_1724, class_310.method_1551().method_1561().method_23839(camera.method_19331(), tickDelta));
        class_310.method_1551().method_16011().method_15407();
        gameRenderer.method_22709(CapturedRenderingState.INSTANCE.getGbufferProjection());
        poseStack.method_22909();
        this.bufferSource.method_22993();
        this.renderingSolid = false;
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public void renderTranslucent(class_4587 poseStack, float tickDelta, class_4184 camera, class_757 gameRenderer, WorldRenderingPipeline pipeline) {
        if (!(this.canRender(camera, gameRenderer) && this.isAnyHandTranslucent() && IrisApi.getInstance().isShaderPackInUse())) {
            return;
        }
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_TRANSLUCENT);
        poseStack.method_22903();
        class_310.method_1551().method_16011().method_15396("iris_hand_translucent");
        this.setupGlState(gameRenderer, camera, poseStack, tickDelta);
        class_310.method_1551().method_1489().method_22976(tickDelta, poseStack, (class_4597.class_4598)this.bufferSource, class_310.method_1551().field_1724, class_310.method_1551().method_1561().method_23839(camera.method_19331(), tickDelta));
        poseStack.method_22909();
        class_310.method_1551().method_16011().method_15407();
        gameRenderer.method_22709(CapturedRenderingState.INSTANCE.getGbufferProjection());
        this.bufferSource.method_22993();
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public boolean isActive() {
        return this.ACTIVE;
    }

    public boolean isRenderingSolid() {
        return this.renderingSolid;
    }

    public FullyBufferedMultiBufferSource getBufferSource() {
        return this.bufferSource;
    }
}

