/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class PipelineManager {
    private static PipelineManager instance;
    private final Function<DimensionId, WorldRenderingPipeline> pipelineFactory;
    private final Map<DimensionId, WorldRenderingPipeline> pipelinesPerDimension = new HashMap<DimensionId, WorldRenderingPipeline>();
    private WorldRenderingPipeline pipeline;
    private boolean sodiumShaderReloadNeeded;

    public PipelineManager(Function<DimensionId, WorldRenderingPipeline> pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public WorldRenderingPipeline preparePipeline(DimensionId currentDimension) {
        if (!this.pipelinesPerDimension.containsKey((Object)currentDimension)) {
            SystemTimeUniforms.COUNTER.reset();
            SystemTimeUniforms.TIMER.reset();
            Iris.logger.info("Creating pipeline for dimension {}", (Object)currentDimension);
            this.pipeline = this.pipelineFactory.apply(currentDimension);
            this.pipelinesPerDimension.put(currentDimension, this.pipeline);
            this.sodiumShaderReloadNeeded = true;
            if (BlockRenderingSettings.INSTANCE.isReloadRequired()) {
                class_310.method_1551().field_1769.method_3279();
                BlockRenderingSettings.INSTANCE.clearReloadRequired();
            }
        } else {
            this.pipeline = this.pipelinesPerDimension.get((Object)currentDimension);
        }
        return this.pipeline;
    }

    @Nullable
    public WorldRenderingPipeline getPipelineNullable() {
        return this.pipeline;
    }

    public Optional<WorldRenderingPipeline> getPipeline() {
        return Optional.ofNullable(this.pipeline);
    }

    public boolean isSodiumShaderReloadNeeded() {
        return this.sodiumShaderReloadNeeded;
    }

    public void clearSodiumShaderReloadNeeded() {
        this.sodiumShaderReloadNeeded = false;
    }

    public void setAsInstance() {
        if (instance != null) {
            throw new IllegalStateException("Multiple pipeline managers active at one time");
        }
        instance = this;
    }

    public static void resetInstance() {
        instance = null;
    }

    public static PipelineManager getInstance() {
        return instance;
    }

    public void destroyPipeline() {
        this.pipelinesPerDimension.forEach((dimensionId, pipeline) -> {
            Iris.logger.info("Destroying pipeline {}", (Object)dimensionId);
            this.resetTextureState();
            pipeline.destroy();
        });
        this.pipelinesPerDimension.clear();
        this.pipeline = null;
    }

    private void resetTextureState() {
        for (int i = 0; i < 16; ++i) {
            GlStateManager.glActiveTexture((int)(33984 + i));
            GlStateManager._bindTexture((int)0);
        }
        GlStateManager.glActiveTexture((int)33984);
    }
}

