/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.TriforcePatcher;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.minecraft.class_2960;

public class SodiumTerrainPipeline {
    String terrainVertex;
    String terrainGeometry;
    String terrainFragment;
    String terrainCutoutFragment;
    GlFramebuffer terrainFramebuffer;
    BlendModeOverride terrainBlendOverride;
    String translucentVertex;
    String translucentGeometry;
    String translucentFragment;
    GlFramebuffer translucentFramebuffer;
    BlendModeOverride translucentBlendOverride;
    String shadowVertex;
    String shadowGeometry;
    String shadowFragment;
    String shadowCutoutFragment;
    GlFramebuffer shadowFramebuffer;
    BlendModeOverride shadowBlendOverride = BlendModeOverride.OFF;
    ProgramSet programSet;
    private final WorldRenderingPipeline parent;
    private final IntFunction<ProgramSamplers> createTerrainSamplers;
    private final IntFunction<ProgramSamplers> createShadowSamplers;
    private final IntFunction<ProgramImages> createTerrainImages;
    private final IntFunction<ProgramImages> createShadowImages;

    public SodiumTerrainPipeline(WorldRenderingPipeline parent, ProgramSet programSet, IntFunction<ProgramSamplers> createTerrainSamplers, IntFunction<ProgramSamplers> createShadowSamplers, IntFunction<ProgramImages> createTerrainImages, IntFunction<ProgramImages> createShadowImages, RenderTargets targets, ImmutableSet<Integer> flippedAfterPrepare, ImmutableSet<Integer> flippedAfterTranslucent, GlFramebuffer shadowFramebuffer) {
        this.parent = Objects.requireNonNull(parent);
        Optional<ProgramSource> terrainSource = SodiumTerrainPipeline.first(programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = SodiumTerrainPipeline.first(programSet.getGbuffersWater(), terrainSource);
        this.programSet = programSet;
        this.shadowFramebuffer = shadowFramebuffer;
        terrainSource.ifPresent(sources -> {
            this.terrainFramebuffer = targets.createGbufferFramebuffer(flippedAfterPrepare, sources.getDirectives().getDrawBuffers());
        });
        translucentSource.ifPresent(sources -> {
            this.translucentFramebuffer = targets.createGbufferFramebuffer(flippedAfterTranslucent, sources.getDirectives().getDrawBuffers());
        });
        if (this.terrainFramebuffer == null) {
            this.terrainFramebuffer = targets.createGbufferFramebuffer(flippedAfterPrepare, new int[]{0});
        }
        if (this.translucentFramebuffer == null) {
            this.translucentFramebuffer = targets.createGbufferFramebuffer(flippedAfterTranslucent, new int[]{0});
        }
        this.createTerrainSamplers = createTerrainSamplers;
        this.createShadowSamplers = createShadowSamplers;
        this.createTerrainImages = createTerrainImages;
        this.createShadowImages = createShadowImages;
    }

    public void patchShaders(ChunkVertexType vertexType) {
        String fragment;
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(true, true, false, true, true);
        AlphaTest cutoutAlpha = new AlphaTest(AlphaTestFunction.GREATER, 0.1f);
        Optional<ProgramSource> terrainSource = SodiumTerrainPipeline.first(this.programSet.getGbuffersTerrain(), this.programSet.getGbuffersTexturedLit(), this.programSet.getGbuffersTextured(), this.programSet.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = SodiumTerrainPipeline.first(this.programSet.getGbuffersWater(), terrainSource);
        terrainSource.ifPresent(sources -> {
            this.terrainVertex = sources.getVertexSource().orElse(null);
            this.terrainGeometry = sources.getGeometrySource().orElse(null);
            this.terrainFragment = sources.getFragmentSource().orElse(null);
            this.terrainBlendOverride = sources.getDirectives().getBlendModeOverride();
        });
        translucentSource.ifPresent(sources -> {
            this.translucentVertex = sources.getVertexSource().orElse(null);
            this.translucentGeometry = sources.getGeometrySource().orElse(null);
            this.translucentFragment = sources.getFragmentSource().orElse(null);
            this.translucentBlendOverride = sources.getDirectives().getBlendModeOverride();
        });
        this.programSet.getShadow().ifPresent(sources -> {
            this.shadowVertex = sources.getVertexSource().orElse(null);
            this.shadowGeometry = sources.getGeometrySource().orElse(null);
            this.shadowFragment = sources.getFragmentSource().orElse(null);
            this.shadowBlendOverride = sources.getDirectives().getBlendModeOverride();
        });
        if (this.terrainVertex != null) {
            this.terrainVertex = TriforcePatcher.patchSodium(this.terrainVertex, ShaderType.VERTEX, null, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
        }
        if (this.translucentVertex != null) {
            this.translucentVertex = TriforcePatcher.patchSodium(this.translucentVertex, ShaderType.VERTEX, null, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
        }
        if (this.shadowVertex != null) {
            this.shadowVertex = TriforcePatcher.patchSodium(this.shadowVertex, ShaderType.VERTEX, null, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
        }
        if (this.terrainGeometry != null) {
            this.terrainGeometry = TriforcePatcher.patchSodium(this.terrainGeometry, ShaderType.GEOMETRY, null, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
        }
        if (this.translucentGeometry != null) {
            this.translucentGeometry = TriforcePatcher.patchSodium(this.translucentGeometry, ShaderType.GEOMETRY, null, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
        }
        if (this.shadowGeometry != null) {
            this.shadowGeometry = TriforcePatcher.patchSodium(this.shadowGeometry, ShaderType.GEOMETRY, null, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
        }
        if (this.terrainFragment != null) {
            fragment = this.terrainFragment;
            this.terrainFragment = TriforcePatcher.patchSodium(fragment, ShaderType.FRAGMENT, AlphaTest.ALWAYS, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
            this.terrainCutoutFragment = TriforcePatcher.patchSodium(fragment, ShaderType.FRAGMENT, cutoutAlpha, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
        }
        if (this.translucentFragment != null) {
            this.translucentFragment = TriforcePatcher.patchSodium(this.translucentFragment, ShaderType.FRAGMENT, AlphaTest.ALWAYS, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
        }
        if (this.shadowFragment != null) {
            fragment = this.shadowFragment;
            this.shadowFragment = TriforcePatcher.patchSodium(fragment, ShaderType.FRAGMENT, AlphaTest.ALWAYS, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
            this.shadowCutoutFragment = TriforcePatcher.patchSodium(fragment, ShaderType.FRAGMENT, cutoutAlpha, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
        }
    }

    public Optional<String> getTerrainVertexShaderSource() {
        return Optional.ofNullable(this.terrainVertex);
    }

    public Optional<String> getTerrainGeometryShaderSource() {
        return Optional.ofNullable(this.terrainGeometry);
    }

    public Optional<String> getTerrainFragmentShaderSource() {
        return Optional.ofNullable(this.terrainFragment);
    }

    public Optional<String> getTerrainCutoutFragmentShaderSource() {
        return Optional.ofNullable(this.terrainCutoutFragment);
    }

    public GlFramebuffer getTerrainFramebuffer() {
        return this.terrainFramebuffer;
    }

    public BlendModeOverride getTerrainBlendOverride() {
        return this.terrainBlendOverride;
    }

    public Optional<String> getTranslucentVertexShaderSource() {
        return Optional.ofNullable(this.translucentVertex);
    }

    public Optional<String> getTranslucentGeometryShaderSource() {
        return Optional.ofNullable(this.translucentGeometry);
    }

    public Optional<String> getTranslucentFragmentShaderSource() {
        return Optional.ofNullable(this.translucentFragment);
    }

    public GlFramebuffer getTranslucentFramebuffer() {
        return this.translucentFramebuffer;
    }

    public BlendModeOverride getTranslucentBlendOverride() {
        return this.translucentBlendOverride;
    }

    public Optional<String> getShadowVertexShaderSource() {
        return Optional.ofNullable(this.shadowVertex);
    }

    public Optional<String> getShadowGeometryShaderSource() {
        return Optional.ofNullable(this.shadowGeometry);
    }

    public Optional<String> getShadowFragmentShaderSource() {
        return Optional.ofNullable(this.shadowFragment);
    }

    public Optional<String> getShadowCutoutFragmentShaderSource() {
        return Optional.ofNullable(this.shadowCutoutFragment);
    }

    public GlFramebuffer getShadowFramebuffer() {
        return this.shadowFramebuffer;
    }

    public BlendModeOverride getShadowBlendOverride() {
        return this.shadowBlendOverride;
    }

    public ProgramUniforms initUniforms(int programId) {
        ProgramUniforms.Builder uniforms = ProgramUniforms.builder("<sodium shaders>", programId);
        CommonUniforms.addCommonUniforms(uniforms, this.programSet.getPack().getIdMap(), this.programSet.getPackDirectives(), this.parent.getFrameUpdateNotifier(), FogMode.ENABLED);
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
        return uniforms.buildUniforms();
    }

    public ProgramSamplers initTerrainSamplers(int programId) {
        return this.createTerrainSamplers.apply(programId);
    }

    public ProgramSamplers initShadowSamplers(int programId) {
        return this.createShadowSamplers.apply(programId);
    }

    public ProgramImages initTerrainImages(int programId) {
        return this.createTerrainImages.apply(programId);
    }

    public ProgramImages initShadowImages(int programId) {
        return this.createShadowImages.apply(programId);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }

    public static String parseSodiumImport(String shader) {
        Pattern IMPORT_PATTERN = Pattern.compile("#import <(?<namespace>.*):(?<path>.*)>");
        Matcher matcher = IMPORT_PATTERN.matcher(shader);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed import statement (expected format: " + IMPORT_PATTERN + ")");
        }
        String namespace = matcher.group("namespace");
        String path = matcher.group("path");
        class_2960 identifier = new class_2960(namespace, path);
        return ShaderLoader.getShaderSource((class_2960)identifier);
    }
}

