/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.layer.GbufferProgram;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewShaderTests;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.coderbot.iris.pipeline.newshader.ShaderMap;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.EmptyShadowMapRenderer;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5944;
import net.minecraft.class_757;

public class NewWorldRenderingPipeline
implements WorldRenderingPipeline,
CoreWorldRenderingPipeline {
    private final RenderTargets renderTargets;
    private final ShaderMap shaderMap;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private final Set<class_5944> loadedShaders;
    private final ImmutableList<ClearPass> clearPassesFull;
    private final ImmutableList<ClearPass> clearPasses;
    private final GlFramebuffer baseline;
    private final CompositeRenderer prepareRenderer;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    public boolean isBeforeTranslucent;
    private final float sunPathRotation;
    private final boolean shouldRenderClouds;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean shouldRenderParticlesBeforeDeferred;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private boolean destroyed = false;
    private boolean isRenderingWorld;
    private Runnable createShadowMapRenderer;
    private ShadowMapRenderer shadowMapRenderer;

    public NewWorldRenderingPipeline(ProgramSet programSet) throws IOException {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Path debugOutDir = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
            if (Files.exists(debugOutDir, new LinkOption[0])) {
                Files.list(debugOutDir).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            Files.createDirectories(debugOutDir, new FileAttribute[0]);
        }
        this.shouldRenderClouds = programSet.getPackDirectives().areCloudsEnabled();
        this.shouldRenderUnderwaterOverlay = programSet.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programSet.getPackDirectives().vignette();
        this.shouldWriteRainAndSnowToDepthBuffer = programSet.getPackDirectives().rainDepth();
        this.shouldRenderParticlesBeforeDeferred = programSet.getPackDirectives().areParticlesBeforeDeferred();
        this.oldLighting = programSet.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        this.renderTargets = new RenderTargets(class_310.method_1551().method_1522(), programSet.getPackDirectives().getRenderTargetDirectives());
        this.sunPathRotation = programSet.getPackDirectives().getSunPathRotation();
        PackShadowDirectives shadowDirectives = programSet.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = shadowDirectives.isDistanceRenderMulExplicit() ? ((double)shadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(shadowDirectives.getDistance() * shadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        GlStateManager._activeTexture((int)33986);
        this.customTextureManager = new CustomTextureManager(programSet.getPackDirectives(), programSet.getPack().getCustomTextureDataMap(), programSet.getPack().getCustomNoiseTexture());
        GlStateManager._activeTexture((int)33984);
        ImmutableSet flippedBeforeShadow = ImmutableSet.of();
        this.createShadowMapRenderer = () -> {
            this.shadowMapRenderer = new ShadowRenderer(this, programSet, programSet.getPackDirectives(), this.renderTargets);
            this.createShadowMapRenderer = () -> {};
        };
        BufferFlipper flipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(this.renderTargets, this.updateNotifier);
        Supplier<ShadowMapRenderer> shadowMapRendererSupplier = () -> {
            this.createShadowMapRenderer.run();
            return this.shadowMapRenderer;
        };
        this.prepareRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getPrepare(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.PREPARE, (Object)Object2ObjectMaps.emptyMap())), programSet.getPackDirectives().getExplicitFlips("prepare_pre"));
        this.flippedAfterPrepare = flipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getDeferred(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.DEFERRED, (Object)Object2ObjectMaps.emptyMap())), programSet.getPackDirectives().getExplicitFlips("deferred_pre"));
        this.flippedAfterTranslucent = flipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getComposite(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object)Object2ObjectMaps.emptyMap())), programSet.getPackDirectives().getExplicitFlips("composite_pre"));
        this.finalPassRenderer = new FinalPassRenderer(programSet, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, flipper.snapshot(), this.centerDepthSampler, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object)Object2ObjectMaps.emptyMap())), this.compositeRenderer.getFlippedAtLeastOnceFinal());
        Supplier<ImmutableSet> flipped = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> createTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                this.createShadowMapRenderer.run();
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                this.createShadowMapRenderer.run();
                IrisImages.addShadowColorImages((ImageHolder)builder, this.shadowMapRenderer);
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> createShadowTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> flippedBeforeShadow, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowMapRenderer != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createShadowTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, () -> flippedBeforeShadow, this.renderTargets);
            if (IrisImages.hasShadowImages(builder) && this.shadowMapRenderer != null) {
                IrisImages.addShadowColorImages((ImageHolder)builder, this.shadowMapRenderer);
            }
            return builder.build();
        };
        this.baseline = this.renderTargets.createFramebufferWritingToMain(new int[]{0});
        this.loadedShaders = new HashSet<class_5944>();
        ProgramFallbackResolver resolver = new ProgramFallbackResolver(programSet);
        this.shaderMap = new ShaderMap(key -> {
            try {
                if (key.isShadow()) {
                    if (this.shadowMapRenderer != null) {
                        return this.createShadowShader(key.getName(), resolver.resolve(key.getProgram()), (ShaderKey)((Object)key));
                    }
                    return null;
                }
                return this.createShader(key.getName(), resolver.resolve(key.getProgram()), (ShaderKey)((Object)key));
            }
            catch (IOException e) {
                this.destroyShaders();
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                this.destroyShaders();
                throw e;
            }
        });
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programSet.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programSet.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programSet.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programSet.getPackDirectives().shouldUseSeparateAo());
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programSet.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programSet.getPackDirectives().getRenderTargetDirectives());
        if (this.shadowMapRenderer == null) {
            this.shadowMapRenderer = new EmptyShadowMapRenderer(programSet.getPackDirectives().getShadowDirectives().getResolution());
        } else {
            class_5944 shader = this.shaderMap.getShader(ShaderKey.SHADOW_TERRAIN_CUTOUT);
            if (shader instanceof ExtendedShader && this.shadowMapRenderer instanceof ShadowRenderer) {
                ExtendedShader holder = (ExtendedShader)this.getShaderMap().getShader(ShaderKey.SHADOW_TERRAIN_CUTOUT);
                ((ShadowRenderer)this.shadowMapRenderer).packHasVoxelization = ((ShadowRenderer)this.shadowMapRenderer).packHasVoxelization | (IrisImages.hasShadowImages(holder) || IrisImages.hasRenderTargetImages(holder, this.renderTargets));
            }
        }
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programSet, createTerrainSamplers, createShadowTerrainSamplers, createTerrainImages, createShadowTerrainImages, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, this.shadowMapRenderer instanceof ShadowRenderer ? ((ShadowRenderer)this.shadowMapRenderer).getFramebuffer() : null);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }

    private class_5944 createShader(String name, Optional<ProgramSource> source, ShaderKey key) throws IOException {
        if (!source.isPresent()) {
            return this.createFallbackShader(name, key);
        }
        return this.createShader(name, source.get(), key.getAlphaTest(), key.getVertexFormat(), key.getFogMode(), key.isBeaconBeam(), key.isFullbright());
    }

    private class_5944 createShader(String name, ProgramSource source, AlphaTest fallbackAlpha, class_293 vertexFormat, FogMode fogMode, boolean isBeacon, boolean isFullbright) throws IOException {
        GlFramebuffer beforeTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, source.getDirectives().getDrawBuffers());
        GlFramebuffer afterTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, source.getDirectives().getDrawBuffers());
        ExtendedShader extendedShader = NewShaderTests.create(name, source, beforeTranslucent, afterTranslucent, this.baseline, fallbackAlpha, vertexFormat, this.updateNotifier, this, fogMode, isBeacon, isFullbright);
        this.loadedShaders.add(extendedShader);
        Supplier<ImmutableSet<Integer>> flipped = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        this.addGbufferOrShadowSamplers(extendedShader, flipped, false);
        return extendedShader;
    }

    private class_5944 createFallbackShader(String name, ShaderKey key) throws IOException {
        GlFramebuffer beforeTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer afterTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        FallbackShader shader = NewShaderTests.createFallback(name, beforeTranslucent, afterTranslucent, key.getAlphaTest(), key.getVertexFormat(), null, this, key.getFogMode(), key.hasDiffuseLighting(), key.isIntensity(), key.isBeaconBeam(), key.isFullbright());
        this.loadedShaders.add(shader);
        return shader;
    }

    private class_5944 createShadowShader(String name, Optional<ProgramSource> source, ShaderKey key) throws IOException {
        if (!source.isPresent()) {
            return this.createFallbackShadowShader(name, key);
        }
        return this.createShadowShader(name, source.get(), key.getAlphaTest(), key.getVertexFormat(), key.isBeaconBeam(), key.isFullbright());
    }

    private class_5944 createFallbackShadowShader(String name, ShaderKey key) throws IOException {
        GlFramebuffer framebuffer = ((ShadowRenderer)this.shadowMapRenderer).getFramebuffer();
        FallbackShader shader = NewShaderTests.createFallback(name, framebuffer, framebuffer, key.getAlphaTest(), key.getVertexFormat(), BlendModeOverride.OFF, this, key.getFogMode(), key.hasDiffuseLighting(), key.isIntensity(), key.isBeaconBeam(), key.isFullbright());
        this.loadedShaders.add(shader);
        return shader;
    }

    private class_5944 createShadowShader(String name, ProgramSource source, AlphaTest fallbackAlpha, class_293 vertexFormat, boolean isBeacon, boolean isFullbright) throws IOException {
        GlFramebuffer framebuffer = ((ShadowRenderer)this.shadowMapRenderer).getFramebuffer();
        ExtendedShader extendedShader = NewShaderTests.create(name, source, framebuffer, framebuffer, this.baseline, fallbackAlpha, vertexFormat, this.updateNotifier, this, FogMode.ENABLED, isBeacon, isFullbright);
        this.loadedShaders.add(extendedShader);
        ImmutableSet flippedSet = ImmutableSet.of();
        Supplier<ImmutableSet<Integer>> flipped = () -> flippedSet;
        this.addGbufferOrShadowSamplers(extendedShader, flipped, true);
        return extendedShader;
    }

    private void addGbufferOrShadowSamplers(ExtendedShader extendedShader, Supplier<ImmutableSet<Integer>> flipped, boolean isShadowPass) {
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor samplerHolder = ProgramSamplers.customTextureSamplerInterceptor(extendedShader, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)textureStage, (Object)Object2ObjectMaps.emptyMap())));
        IrisSamplers.addRenderTargetSamplers(samplerHolder, flipped, this.renderTargets, false);
        IrisImages.addRenderTargetImages(extendedShader, flipped, this.renderTargets);
        samplerHolder.addDynamicSampler(() -> ((NativeImageBackedSingleColorTexture)this.customTextureManager.getNormals()).method_4624(), "normals");
        samplerHolder.addDynamicSampler(() -> ((NativeImageBackedSingleColorTexture)this.customTextureManager.getSpecular()).method_4624(), "specular");
        IrisSamplers.addWorldDepthSamplers(samplerHolder, this.renderTargets);
        IrisSamplers.addNoiseSampler(samplerHolder, this.customTextureManager.getNoiseTexture());
        if (isShadowPass || IrisSamplers.hasShadowSamplers(samplerHolder)) {
            if (!isShadowPass) {
                this.createShadowMapRenderer.run();
            }
            IrisSamplers.addShadowSamplers(samplerHolder, this.shadowMapRenderer);
        }
        if (isShadowPass || IrisImages.hasShadowImages(extendedShader)) {
            IrisImages.addShadowColorImages((ImageHolder)extendedShader, this.shadowMapRenderer);
        }
    }

    @Override
    public WorldRenderingPhase getPhase() {
        return this.phase;
    }

    @Override
    public void setPhase(WorldRenderingPhase phase) {
        this.phase = phase;
    }

    @Override
    public void beginLevelRendering() {
        ImmutableList<ClearPass> passes;
        this.isRenderingWorld = true;
        RenderSystem.activeTexture((int)33984);
        this.updateNotifier.onNewFrame();
        class_276 main = class_310.method_1551().method_1522();
        this.renderTargets.resizeIfNeeded(main.field_1482, main.field_1481);
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            passes = this.clearPassesFull;
        } else {
            passes = this.clearPasses;
        }
        Vector3d fogColor3 = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f fogColor = new Vector4f((float)fogColor3.x, (float)fogColor3.y, (float)fogColor3.z, 1.0f);
        for (ClearPass clearPass : passes) {
            clearPass.execute(fogColor);
        }
        main.method_1235(true);
        this.isBeforeTranslucent = true;
    }

    @Override
    public void renderShadows(LevelRendererAccessor worldRenderer, class_4184 playerCamera) {
        this.shadowMapRenderer.renderShadows(worldRenderer, playerCamera);
        this.prepareRenderer.renderAll();
    }

    @Override
    public void addDebugText(List<String> messages) {
        ShadowMapRenderer shadowMapRenderer = this.shadowMapRenderer;
        if (shadowMapRenderer instanceof ShadowRenderer) {
            messages.add("");
            shadowMapRenderer.addDebugText(messages);
        } else if (shadowMapRenderer instanceof EmptyShadowMapRenderer) {
            messages.add("");
            messages.add("[Iris] Shadow Maps: not used by shader pack");
        } else {
            throw new IllegalStateException("Unknown shadow map renderer type!");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginShadowRender() {
    }

    @Override
    public void endShadowRender() {
    }

    @Override
    public void beginHand() {
        this.baseline.bind();
        GlStateManager._bindTexture((int)this.renderTargets.getDepthTextureNoHand().getTextureId());
        IrisRenderSystem.copyTexImage2D(3553, 0, 6402, 0, 0, this.renderTargets.getCurrentWidth(), this.renderTargets.getCurrentHeight(), 0);
        GlStateManager._bindTexture((int)0);
    }

    @Override
    public void beginTranslucents() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use a destroyed world rendering pipeline");
        }
        this.isBeforeTranslucent = false;
        this.baseline.bind();
        GlStateManager._bindTexture((int)this.renderTargets.getDepthTextureNoTranslucents().getTextureId());
        IrisRenderSystem.copyTexImage2D(3553, 0, 6402, 0, 0, this.renderTargets.getCurrentWidth(), this.renderTargets.getCurrentHeight(), 0);
        GlStateManager._bindTexture((int)0);
        this.deferredRenderer.renderAll();
        RenderSystem.enableBlend();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_310.method_1551().field_1773.method_22975().method_23209();
        RenderSystem.setShader(class_757::method_34539);
    }

    @Override
    public void pushProgram(GbufferProgram program) {
    }

    @Override
    public void popProgram(GbufferProgram program) {
    }

    @Override
    public void finalizeLevelRendering() {
        this.isRenderingWorld = false;
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowMapRenderer instanceof ShadowRenderer;
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.shouldRenderClouds;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public boolean shouldRenderParticlesBeforeDeferred() {
        return this.shouldRenderParticlesBeforeDeferred;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public ShaderMap getShaderMap() {
        return this.shaderMap;
    }

    private void destroyShaders() {
        this.loadedShaders.forEach(shader -> {
            shader.method_34585();
            shader.close();
        });
    }

    @Override
    public void destroy() {
        int i;
        this.destroyed = true;
        this.destroyShaders();
        for (i = 0; i < 16; ++i) {
            GlStateManager.glActiveTexture((int)(33984 + i));
            GlStateManager._bindTexture((int)0);
        }
        GlStateManager.glActiveTexture((int)33984);
        for (i = 0; i < 12; ++i) {
            RenderSystem.setShaderTexture((int)i, (int)0);
        }
        this.compositeRenderer.destroy();
        this.customTextureManager.destroy();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        class_310.method_1551().method_1522().method_1235(false);
        this.shadowMapRenderer.destroy();
        this.renderTargets.destroy();
    }

    @Override
    public boolean isRenderingWorld() {
        return this.isRenderingWorld;
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }
}

