/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.rendertarget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;

public class RenderTarget {
    private final InternalTextureFormat internalFormat;
    private final PixelFormat format;
    private final PixelType type;
    private boolean isValid = true;
    private final int mainTexture;
    private final int altTexture;
    private static final IntBuffer NULL_BUFFER = null;

    private RenderTarget(Builder builder) {
        this.internalFormat = builder.internalFormat;
        this.format = builder.format;
        this.type = builder.type;
        int[] textures = new int[2];
        GlStateManager._genTextures((int[])textures);
        this.mainTexture = textures[0];
        this.altTexture = textures[1];
        GlStateManager._bindTexture((int)this.mainTexture);
        this.setupCurrentlyBoundTexture(builder.width, builder.height);
        GlStateManager._bindTexture((int)this.altTexture);
        this.setupCurrentlyBoundTexture(builder.width, builder.height);
        GlStateManager._bindTexture((int)0);
    }

    private void setupCurrentlyBoundTexture(int width, int height) {
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
        RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        this.resizeCurrentlyBoundTexture(width, height);
    }

    private void resizeCurrentlyBoundTexture(int width, int height) {
        GlStateManager._texImage2D((int)3553, (int)0, (int)this.internalFormat.getGlFormat(), (int)width, (int)height, (int)0, (int)this.format.getGlFormat(), (int)this.type.getGlFormat(), (IntBuffer)NULL_BUFFER);
    }

    void resize(int width, int height) {
        this.requireValid();
        GlStateManager._bindTexture((int)this.mainTexture);
        this.resizeCurrentlyBoundTexture(width, height);
        GlStateManager._bindTexture((int)this.altTexture);
        this.resizeCurrentlyBoundTexture(width, height);
    }

    public InternalTextureFormat getInternalFormat() {
        return this.internalFormat;
    }

    public int getMainTexture() {
        this.requireValid();
        return this.mainTexture;
    }

    public int getAltTexture() {
        this.requireValid();
        return this.altTexture;
    }

    public void destroy() {
        this.requireValid();
        this.isValid = false;
        GlStateManager._deleteTextures((int[])new int[]{this.mainTexture, this.altTexture});
    }

    private void requireValid() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempted to use a deleted composite render target");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private InternalTextureFormat internalFormat = InternalTextureFormat.RGBA8;
        private int width = 0;
        private int height = 0;
        private PixelFormat format = PixelFormat.RGBA;
        private PixelType type = PixelType.UNSIGNED_BYTE;

        private Builder() {
        }

        public Builder setInternalFormat(InternalTextureFormat format) {
            this.internalFormat = format;
            return this;
        }

        public Builder setDimensions(int width, int height) {
            if (width <= 0) {
                throw new IllegalArgumentException("Width must be greater than zero");
            }
            if (height <= 0) {
                throw new IllegalArgumentException("Height must be greater than zero");
            }
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setPixelFormat(PixelFormat pixelFormat) {
            this.format = pixelFormat;
            return this;
        }

        public Builder setPixelType(PixelType pixelType) {
            this.type = pixelType;
            return this;
        }

        public RenderTarget build() {
            return new RenderTarget(this);
        }
    }
}

