/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableSet;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.shadows.ShadowRenderTargets;

public class IrisImages {
    public static void addRenderTargetImages(ImageHolder images, Supplier<ImmutableSet<Integer>> flipped, RenderTargets renderTargets) {
        for (int i = 0; i < renderTargets.getRenderTargetCount(); ++i) {
            int index = i;
            IntSupplier textureID = () -> {
                ImmutableSet flippedBuffers = (ImmutableSet)flipped.get();
                RenderTarget target = renderTargets.get(index);
                if (flippedBuffers.contains((Object)index)) {
                    return target.getAltTexture();
                }
                return target.getMainTexture();
            };
            InternalTextureFormat internalFormat = renderTargets.get(i).getInternalFormat();
            String name = "colorimg" + i;
            images.addTextureImage(textureID, internalFormat, name);
        }
    }

    public static boolean hasShadowImages(ImageHolder images) {
        if (images == null) {
            return false;
        }
        return images.hasImage("shadowcolorimg0") || images.hasImage("shadowcolorimg1");
    }

    public static boolean hasRenderTargetImages(ImageHolder images, RenderTargets targets) {
        for (int i = 0; i < targets.getRenderTargetCount(); ++i) {
            if (images == null || !images.hasImage("colorimg" + i)) continue;
            return true;
        }
        return false;
    }

    public static void addShadowColorImages(ImageHolder images, ShadowMapRenderer shadowMapRenderer) {
        IrisImages.addShadowColorImages(images, shadowMapRenderer.getRenderTargets());
    }

    public static void addShadowColorImages(ImageHolder images, ShadowRenderTargets shadowRenderTargets) {
        if (images == null) {
            return;
        }
        for (int i = 0; i < shadowRenderTargets.getNumColorTextures(); ++i) {
            int index = i;
            IntSupplier textureID = () -> shadowRenderTargets.getColorTextureId(index);
            InternalTextureFormat format = shadowRenderTargets.getColorTextureFormat(index);
            images.addTextureImage(textureID, format, "shadowcolorimg" + i);
        }
    }
}

