/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.WeakHashMap;
import net.coderbot.iris.texunits.TextureAtlasInterface;
import net.minecraft.class_1059;
import net.minecraft.class_241;

public class TextureAtlasTracker {
    public static final TextureAtlasTracker INSTANCE = new TextureAtlasTracker();
    private final WeakHashMap<Integer, class_1059> atlases = new WeakHashMap();

    private TextureAtlasTracker() {
    }

    public void trackAtlas(int id, class_1059 atlas) {
        class_1059 previous = this.atlases.put(id, atlas);
        if (previous != atlas) {
            TextureAtlasInterface atlasI = (TextureAtlasInterface)atlas;
            atlasI.setAtlasSize(0, 0);
        }
    }

    public void trackTexImage2D(int id, int level, int sizeX, int sizeY) {
        if (level != 0) {
            return;
        }
        class_1059 atlas = this.atlases.get(id);
        if (atlas != null) {
            ((TextureAtlasInterface)atlas).setAtlasSize(sizeX, sizeY);
        }
    }

    public class_241 getAtlasSize(int id) {
        class_1059 atlas = this.atlases.get(id);
        class_241 size = class_241.field_1340;
        if (atlas != null && class_241.field_1340.method_1016(size = ((TextureAtlasInterface)atlas).getAtlasSize())) {
            this.fetchAtlasSizeFromGlState(atlas);
            size = ((TextureAtlasInterface)atlas).getAtlasSize();
        }
        return size;
    }

    public void trackDeleteTextures(int id) {
        this.atlases.remove(id);
    }

    private void fetchAtlasSizeFromGlState(class_1059 atlas) {
        int existingGlId = GlStateManager._getInteger((int)32873);
        RenderSystem.bindTexture((int)atlas.method_4624());
        int width = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        int height = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        TextureAtlasInterface atlasI = (TextureAtlasInterface)atlas;
        atlasI.setAtlasSize(width, height);
        RenderSystem.bindTexture((int)existingGlId);
    }
}

