/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.include;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.include.FileNode;
import net.coderbot.iris.shaderpack.transform.line.LineTransform;

public class IncludeGraph {
    private final ImmutableMap<AbsolutePackPath, FileNode> nodes;
    private final ImmutableMap<AbsolutePackPath, IOException> failures;

    private IncludeGraph(ImmutableMap<AbsolutePackPath, FileNode> nodes, ImmutableMap<AbsolutePackPath, IOException> failures) {
        this.nodes = nodes;
        this.failures = failures;
    }

    public IncludeGraph(Path root, ImmutableList<AbsolutePackPath> startingPaths) {
        HashMap<AbsolutePackPath, FileNode> nodes = new HashMap<AbsolutePackPath, FileNode>();
        HashMap<AbsolutePackPath, IOException> failures = new HashMap<AbsolutePackPath, IOException>();
        ArrayList<AbsolutePackPath> queue = new ArrayList<AbsolutePackPath>((Collection<AbsolutePackPath>)startingPaths);
        HashSet<AbsolutePackPath> seen = new HashSet<AbsolutePackPath>((Collection<AbsolutePackPath>)startingPaths);
        while (!queue.isEmpty()) {
            String source;
            AbsolutePackPath next = (AbsolutePackPath)queue.remove(queue.size() - 1);
            try {
                source = IncludeGraph.readFile(next.resolved(root));
            }
            catch (IOException e) {
                failures.put(next, e);
                continue;
            }
            ImmutableList lines = ImmutableList.copyOf((Object[])source.split("\\R"));
            FileNode node = new FileNode(next, (ImmutableList<String>)lines);
            nodes.put(next, node);
            ImmutableCollection includes = node.getIncludes().values();
            for (AbsolutePackPath included : includes) {
                if (seen.contains(included)) continue;
                queue.add(included);
                seen.add(included);
            }
        }
        this.nodes = ImmutableMap.copyOf(nodes);
        this.failures = ImmutableMap.copyOf(failures);
    }

    public ImmutableMap<AbsolutePackPath, FileNode> getNodes() {
        return this.nodes;
    }

    public List<IncludeGraph> computeWeaklyConnectedSubgraphs() {
        return Collections.singletonList(this);
    }

    public IncludeGraph map(Function<AbsolutePackPath, LineTransform> transformProvider) {
        ImmutableMap.Builder mappedNodes = ImmutableMap.builder();
        this.nodes.forEach((path, node) -> mappedNodes.put(path, (Object)node.map((LineTransform)transformProvider.apply((AbsolutePackPath)path))));
        return new IncludeGraph((ImmutableMap<AbsolutePackPath, FileNode>)mappedNodes.build(), this.failures);
    }

    public ImmutableMap<AbsolutePackPath, IOException> getFailures() {
        return this.failures;
    }

    private static String readFile(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }
}

