/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.preprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesCommentListener;
import net.coderbot.iris.shaderpack.preprocessor.PropertyCollectingListener;
import org.anarres.cpp.Feature;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.PreprocessorListener;
import org.anarres.cpp.Source;
import org.anarres.cpp.StringLexerSource;
import org.anarres.cpp.Token;

public class PropertiesPreprocessor {
    public static String preprocessSource(String source, ShaderPackOptions shaderPackOptions) {
        if (source.contains("#warning IRIS_PASSTHROUGH ")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        List<String> booleanValues = PropertiesPreprocessor.getBooleanValues(shaderPackOptions);
        Map<String, String> stringValues = PropertiesPreprocessor.getStringValues(shaderPackOptions);
        Preprocessor pp = new Preprocessor();
        try {
            for (String value2 : booleanValues) {
                pp.addMacro(value2);
            }
            pp.addMacro("MC_VERSION", StandardMacros.getMcVersion());
        }
        catch (LexerException e) {
            e.printStackTrace();
        }
        stringValues.forEach((name, value) -> {
            try {
                pp.addMacro(name, value);
            }
            catch (LexerException e) {
                e.printStackTrace();
            }
        });
        return PropertiesPreprocessor.process(pp, source);
    }

    public static String preprocessSource(String source) {
        if (source.contains("#warning IRIS_PASSTHROUGH ")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        Preprocessor preprocessor = new Preprocessor();
        try {
            preprocessor.addMacro("MC_VERSION", StandardMacros.getMcVersion());
        }
        catch (LexerException e) {
            e.printStackTrace();
        }
        return PropertiesPreprocessor.process(preprocessor, source);
    }

    private static String process(Preprocessor preprocessor, String source) {
        preprocessor.setListener((PreprocessorListener)new PropertiesCommentListener());
        PropertyCollectingListener listener = new PropertyCollectingListener();
        source = source.replaceAll("([a-zA-Z]+\\.[a-zA-Z0-9]+)", "#warning IRIS_PASSTHROUGH $1");
        preprocessor.setListener((PreprocessorListener)listener);
        source = Arrays.stream(source.split("\\R")).map(String::trim).collect(Collectors.joining("\n"));
        preprocessor.addInput((Source)new StringLexerSource(source, true));
        preprocessor.addFeature(Feature.KEEPCOMMENTS);
        StringBuilder builder = new StringBuilder();
        try {
            Token tok;
            while ((tok = preprocessor.token()) != null && tok.getType() != 265) {
                builder.append(tok.getText());
            }
        }
        catch (Exception e) {
            Iris.logger.error("Properties pre-processing failed", (Throwable)e);
        }
        source = builder.toString();
        return listener.collectLines() + source;
    }

    private static List<String> getBooleanValues(ShaderPackOptions shaderPackOptions) {
        ArrayList<String> booleanValues = new ArrayList<String>();
        shaderPackOptions.getOptionSet().getBooleanOptions().forEach((string, value) -> {
            boolean trueValue = shaderPackOptions.getOptionValues().getBooleanValueOrDefault((String)string);
            if (trueValue) {
                booleanValues.add((String)string);
            }
        });
        return booleanValues;
    }

    private static Map<String, String> getStringValues(ShaderPackOptions shaderPackOptions) {
        HashMap<String, String> stringValues = new HashMap<String, String>();
        shaderPackOptions.getOptionSet().getStringOptions().forEach((optionName, value) -> stringValues.put((String)optionName, shaderPackOptions.getOptionValues().getStringValueOrDefault((String)optionName)));
        return stringValues;
    }
}

