/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import java.util.Arrays;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.rendertarget.DepthTexture;

public class ShadowRenderTargets {
    public static int MAX_SHADOW_RENDER_TARGETS = 8;
    private final int[] targets;
    private final InternalTextureFormat[] formats;
    private final DepthTexture depthTexture;
    private final DepthTexture noTranslucents;
    private final GlFramebuffer framebuffer;
    private static final IntBuffer NULL_BUFFER = null;

    public ShadowRenderTargets(int resolution, InternalTextureFormat[] formats) {
        if (formats.length > MAX_SHADOW_RENDER_TARGETS) {
            throw new IllegalStateException("Too many shadow render targets, requested " + formats.length + " but only " + MAX_SHADOW_RENDER_TARGETS + " are allowed.");
        }
        this.formats = Arrays.copyOf(formats, formats.length);
        int[] drawBuffers = new int[formats.length];
        this.targets = new int[formats.length];
        GlStateManager._genTextures((int[])this.targets);
        this.depthTexture = new DepthTexture(resolution, resolution);
        this.noTranslucents = new DepthTexture(resolution, resolution);
        this.framebuffer = new GlFramebuffer();
        this.framebuffer.addDepthAttachment(this.depthTexture.getTextureId());
        for (int i = 0; i < formats.length; ++i) {
            InternalTextureFormat format = formats[i];
            RenderSystem.bindTexture((int)this.targets[i]);
            GlStateManager._texImage2D((int)3553, (int)0, (int)format.getGlFormat(), (int)resolution, (int)resolution, (int)0, (int)PixelFormat.RGBA.getGlFormat(), (int)PixelType.UNSIGNED_BYTE.getGlFormat(), (IntBuffer)NULL_BUFFER);
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10242, (int)33069);
            RenderSystem.texParameter((int)3553, (int)10243, (int)33069);
            this.framebuffer.addColorAttachment(i, this.targets[i]);
            drawBuffers[i] = i;
        }
        this.framebuffer.drawBuffers(drawBuffers);
        RenderSystem.bindTexture((int)0);
    }

    public GlFramebuffer getFramebuffer() {
        return this.framebuffer;
    }

    public DepthTexture getDepthTexture() {
        return this.depthTexture;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        return this.noTranslucents;
    }

    public int getNumColorTextures() {
        return this.targets.length;
    }

    public int getColorTextureId(int index) {
        return this.targets[index];
    }

    public InternalTextureFormat getColorTextureFormat(int index) {
        return this.formats[index];
    }

    public void destroy() {
        this.framebuffer.destroy();
        GlStateManager._deleteTextures((int[])this.targets);
        this.depthTexture.destroy();
        this.noTranslucents.destroy();
    }
}

