/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.minecraft.class_310;

public class CameraUniforms {
    private static final class_310 client = class_310.method_1551();

    private CameraUniforms() {
    }

    public static void addCameraUniforms(UniformHolder uniforms, FrameUpdateNotifier notifier) {
        CameraPositionTracker tracker = new CameraPositionTracker(notifier);
        uniforms.uniform1f(UniformUpdateFrequency.ONCE, "near", () -> 0.05).uniform1f(UniformUpdateFrequency.PER_FRAME, "far", CameraUniforms::getRenderDistanceInBlocks).uniform3d(UniformUpdateFrequency.PER_FRAME, "cameraPosition", tracker::getCurrentCameraPosition).uniform3d(UniformUpdateFrequency.PER_FRAME, "previousCameraPosition", tracker::getPreviousCameraPosition);
    }

    private static int getRenderDistanceInBlocks() {
        return CameraUniforms.client.field_1690.method_38521() * 16;
    }

    public static Vector3d getUnshiftedCameraPosition() {
        return JomlConversions.fromVec3(CameraUniforms.client.field_1773.method_19418().method_19326());
    }

    static class CameraPositionTracker {
        private static final double RANGE = 1024.0;
        private Vector3d previousCameraPosition = new Vector3d();
        private Vector3d currentCameraPosition = new Vector3d();
        private final Vector3d shift = new Vector3d();

        CameraPositionTracker(FrameUpdateNotifier notifier) {
            notifier.addListener(this::update);
        }

        private void update() {
            this.previousCameraPosition = this.currentCameraPosition;
            this.currentCameraPosition = CameraUniforms.getUnshiftedCameraPosition().add(this.shift);
            this.updateShift();
        }

        private void updateShift() {
            double dX = CameraPositionTracker.getShift(this.currentCameraPosition.x, 1024.0);
            double dZ = CameraPositionTracker.getShift(this.currentCameraPosition.z, 1024.0);
            if (dX != 0.0 || dZ != 0.0) {
                this.applyShift(dX, dZ);
            }
        }

        private static double getShift(double value, double range) {
            if (Math.abs(value) > range) {
                return -(value - value % 1024.0);
            }
            return 0.0;
        }

        private void applyShift(double dX, double dZ) {
            this.shift.x += dX;
            this.currentCameraPosition.x += dX;
            this.previousCameraPosition.x += dX;
            this.shift.z += dZ;
            this.currentCameraPosition.z += dZ;
            this.previousCameraPosition.z += dZ;
        }

        public Vector3d getCurrentCameraPosition() {
            return this.currentCameraPosition;
        }

        public Vector3d getPreviousCameraPosition() {
            return this.previousCameraPosition;
        }
    }
}

