/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.util.Objects;
import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_310;
import net.minecraft.class_638;

public final class CelestialUniforms {
    private final float sunPathRotation;

    public CelestialUniforms(float sunPathRotation) {
        this.sunPathRotation = sunPathRotation;
    }

    public void addCelestialUniforms(UniformHolder uniforms) {
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "sunAngle", CelestialUniforms::getSunAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "sunPosition", this::getSunPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "moonPosition", this::getMoonPosition).uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowAngle", CelestialUniforms::getShadowAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "shadowLightPosition", this::getShadowLightPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "upPosition", CelestialUniforms::getUpPosition);
    }

    public static float getSunAngle() {
        float skyAngle = CelestialUniforms.getSkyAngle();
        if (skyAngle < 0.75f) {
            return skyAngle + 0.25f;
        }
        return skyAngle - 0.75f;
    }

    private static float getShadowAngle() {
        float shadowAngle = CelestialUniforms.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            shadowAngle -= 0.5f;
        }
        return shadowAngle;
    }

    private Vector4f getSunPosition() {
        return this.getCelestialPosition(100.0f);
    }

    private Vector4f getMoonPosition() {
        return this.getCelestialPosition(-100.0f);
    }

    public Vector4f getShadowLightPosition() {
        return CelestialUniforms.isDay() ? this.getSunPosition() : this.getMoonPosition();
    }

    public Vector4f getShadowLightPositionInWorldSpace() {
        return CelestialUniforms.isDay() ? this.getCelestialPositionInWorldSpace(100.0f) : this.getCelestialPositionInWorldSpace(-100.0f);
    }

    private Vector4f getCelestialPositionInWorldSpace(float y) {
        class_1162 position = new class_1162(0.0f, y, 0.0f, 0.0f);
        class_1159 celestial = new class_1159();
        celestial.method_22668();
        celestial.method_22670(class_1160.field_20705.method_23214(-90.0f));
        celestial.method_22670(class_1160.field_20707.method_23214(this.sunPathRotation));
        celestial.method_22670(class_1160.field_20703.method_23214(CelestialUniforms.getSkyAngle() * 360.0f));
        position.method_22674(celestial);
        return JomlConversions.toJoml(position);
    }

    private Vector4f getCelestialPosition(float y) {
        class_1162 position = new class_1162(0.0f, y, 0.0f, 0.0f);
        class_1159 celestial = CapturedRenderingState.INSTANCE.getGbufferModelView().method_22673();
        celestial.method_22670(class_1160.field_20705.method_23214(-90.0f));
        celestial.method_22670(class_1160.field_20707.method_23214(this.sunPathRotation));
        celestial.method_22670(class_1160.field_20703.method_23214(CelestialUniforms.getSkyAngle() * 360.0f));
        position.method_22674(celestial);
        return JomlConversions.toJoml(position);
    }

    private static Vector4f getUpPosition() {
        class_1162 upVector = new class_1162(0.0f, 100.0f, 0.0f, 0.0f);
        class_1159 preCelestial = CapturedRenderingState.INSTANCE.getGbufferModelView().method_22673();
        preCelestial.method_22670(class_1160.field_20705.method_23214(-90.0f));
        upVector.method_22674(preCelestial);
        return JomlConversions.toJoml(upVector);
    }

    public static boolean isDay() {
        return (double)CelestialUniforms.getSunAngle() <= 0.5;
    }

    private static class_638 getWorld() {
        return Objects.requireNonNull(class_310.method_1551().field_1687);
    }

    private static float getSkyAngle() {
        return CelestialUniforms.getWorld().method_30274(CapturedRenderingState.INSTANCE.getTickDelta());
    }
}

