/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.IntSupplier;
import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.layer.EntityColorRenderStateShard;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.statelisteners.BooleanStateAccessor;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.samplers.TextureAtlasTracker;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.ExternallyManagedUniforms;
import net.coderbot.iris.uniforms.FogUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.HardcodedCustomUniforms;
import net.coderbot.iris.uniforms.IdMapUniforms;
import net.coderbot.iris.uniforms.IrisExclusiveUniforms;
import net.coderbot.iris.uniforms.IrisInternalUniforms;
import net.coderbot.iris.uniforms.MatrixUniforms;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.coderbot.iris.uniforms.ViewportUniforms;
import net.coderbot.iris.uniforms.WorldTimeUniforms;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;
import net.coderbot.iris.uniforms.transforms.SmoothedVec2f;
import net.coderbot.iris.vendored.joml.Vector2f;
import net.coderbot.iris.vendored.joml.Vector2i;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.coderbot.iris.vendored.joml.Vector4i;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5636;
import net.minecraft.class_746;
import net.minecraft.class_757;

public final class CommonUniforms {
    private static final class_310 client = class_310.method_1551();

    private CommonUniforms() {
    }

    public static void addCommonUniforms(DynamicUniformHolder uniforms, IdMap idMap, PackDirectives directives, FrameUpdateNotifier updateNotifier, FogMode fogMode) {
        CameraUniforms.addCameraUniforms(uniforms, updateNotifier);
        ViewportUniforms.addViewportUniforms(uniforms);
        WorldTimeUniforms.addWorldTimeUniforms(uniforms);
        SystemTimeUniforms.addSystemTimeUniforms(uniforms);
        new CelestialUniforms(directives.getSunPathRotation()).addCelestialUniforms(uniforms);
        IdMapUniforms.addIdMapUniforms(uniforms, idMap);
        IrisExclusiveUniforms.addIrisExclusiveUniforms(uniforms);
        MatrixUniforms.addMatrixUniforms(uniforms, directives);
        HardcodedCustomUniforms.addHardcodedCustomUniforms(uniforms, updateNotifier);
        FogUniforms.addFogUniforms(uniforms, fogMode);
        IrisInternalUniforms.addFogUniforms(uniforms);
        uniforms.uniform4f("entityColor", () -> {
            if (EntityColorRenderStateShard.currentHurt) {
                return new Vector4f(1.0f, 0.0f, 0.0f, 0.3f);
            }
            float shade = EntityColorRenderStateShard.currentWhiteFlash;
            if (shade != 0.0f) {
                return new Vector4f(shade, shade, shade, 0.5f);
            }
            return new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        }, EntityColorRenderStateShard.getUpdateNotifier());
        uniforms.uniform2i("atlasSize", () -> {
            int glId = RenderSystem.getShaderTexture((int)0);
            class_241 atlasSize = TextureAtlasTracker.INSTANCE.getAtlasSize(glId);
            return new Vector2i((int)atlasSize.field_1343, (int)atlasSize.field_1342);
        }, StateUpdateNotifiers.atlasTextureNotifier);
        uniforms.uniform4i("blendFunc", () -> {
            GlStateManager.class_1017 blend = GlStateManagerAccessor.getBLEND();
            if (((BooleanStateAccessor)blend.field_5045).isEnabled()) {
                return new Vector4i(blend.field_5049, blend.field_5048, blend.field_5047, blend.field_5046);
            }
            return new Vector4i(0, 0, 0, 0);
        }, StateUpdateNotifiers.blendFuncNotifier);
        uniforms.uniform1i("renderStage", () -> GbufferPrograms.getCurrentPhase().ordinal(), StateUpdateNotifiers.phaseChangeNotifier);
        CommonUniforms.generalCommonUniforms(uniforms, updateNotifier);
    }

    public static void generalCommonUniforms(UniformHolder uniforms, FrameUpdateNotifier updateNotifier) {
        ExternallyManagedUniforms.addExternallyManagedUniforms117(uniforms);
        SmoothedVec2f eyeBrightnessSmooth = new SmoothedVec2f(10.0f, 10.0f, CommonUniforms::getEyeBrightness, updateNotifier);
        uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hideGUI", () -> CommonUniforms.client.field_1690.field_1842).uniform1f(UniformUpdateFrequency.PER_FRAME, "eyeAltitude", () -> Objects.requireNonNull(client.method_1560()).method_23320()).uniform1i(UniformUpdateFrequency.PER_FRAME, "isEyeInWater", CommonUniforms::isEyeInWater).uniform1f(UniformUpdateFrequency.PER_FRAME, "blindness", CommonUniforms::getBlindness).uniform1i(UniformUpdateFrequency.PER_FRAME, "heldBlockLightValue", new HeldItemLightingSupplier(class_1268.field_5808)).uniform1i(UniformUpdateFrequency.PER_FRAME, "heldBlockLightValue2", new HeldItemLightingSupplier(class_1268.field_5810)).uniform1f(UniformUpdateFrequency.PER_FRAME, "nightVision", CommonUniforms::getNightVision).uniform1f(UniformUpdateFrequency.PER_FRAME, "screenBrightness", () -> CommonUniforms.client.field_1690.field_1840).uniform1f(UniformUpdateFrequency.PER_TICK, "playerMood", CommonUniforms::getPlayerMood).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightness", CommonUniforms::getEyeBrightness).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightnessSmooth", () -> {
            Vector2f smoothed = eyeBrightnessSmooth.get();
            return new Vector2i((int)smoothed.x(), (int)smoothed.y());
        }).uniform1f(UniformUpdateFrequency.PER_TICK, "rainStrength", CommonUniforms::getRainStrength).uniform1f(UniformUpdateFrequency.PER_TICK, "wetness", new SmoothedFloat(600.0f, 600.0f, CommonUniforms::getRainStrength, updateNotifier)).uniform3d(UniformUpdateFrequency.PER_FRAME, "skyColor", CommonUniforms::getSkyColor);
    }

    private static Vector3d getSkyColor() {
        if (CommonUniforms.client.field_1687 == null || CommonUniforms.client.field_1719 == null) {
            return new Vector3d();
        }
        return JomlConversions.fromVec3(CommonUniforms.client.field_1687.method_23777(CommonUniforms.client.field_1719.method_19538(), CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    static float getBlindness() {
        class_1293 blindness;
        class_1297 cameraEntity = client.method_1560();
        if (cameraEntity instanceof class_1309 && (blindness = ((class_1309)cameraEntity).method_6112(class_1294.field_5919)) != null) {
            return Math.min(1.0f, (float)blindness.method_5584() / 20.0f);
        }
        return 0.0f;
    }

    private static float getPlayerMood() {
        if (!(CommonUniforms.client.field_1719 instanceof class_746)) {
            return 0.0f;
        }
        return ((class_746)CommonUniforms.client.field_1719).method_26269();
    }

    static float getRainStrength() {
        if (CommonUniforms.client.field_1687 == null) {
            return 0.0f;
        }
        return CommonUniforms.client.field_1687.method_8430(CapturedRenderingState.INSTANCE.getTickDelta());
    }

    private static Vector2i getEyeBrightness() {
        if (CommonUniforms.client.field_1719 == null || CommonUniforms.client.field_1687 == null) {
            return new Vector2i(0, 0);
        }
        class_243 feet = CommonUniforms.client.field_1719.method_19538();
        class_243 eyes = new class_243(feet.field_1352, CommonUniforms.client.field_1719.method_23320(), feet.field_1350);
        class_2338 eyeBlockPos = new class_2338(eyes);
        int blockLight = CommonUniforms.client.field_1687.method_8314(class_1944.field_9282, eyeBlockPos);
        int skyLight = CommonUniforms.client.field_1687.method_8314(class_1944.field_9284, eyeBlockPos);
        return new Vector2i(blockLight * 16, skyLight * 16);
    }

    private static float getNightVision() {
        float underwaterVisibility;
        class_1297 cameraEntity = client.method_1560();
        if (cameraEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)cameraEntity;
            try {
                float nightVisionStrength = class_757.method_3174((class_1309)livingEntity, (float)CapturedRenderingState.INSTANCE.getTickDelta());
                if (nightVisionStrength > 0.0f) {
                    return nightVisionStrength;
                }
            }
            catch (NullPointerException e) {
                return 0.0f;
            }
        }
        if (CommonUniforms.client.field_1724 != null && CommonUniforms.client.field_1724.method_6059(class_1294.field_5927) && (underwaterVisibility = CommonUniforms.client.field_1724.method_3140()) > 0.0f) {
            return underwaterVisibility;
        }
        return 0.0f;
    }

    private static int isEyeInWater() {
        class_5636 submersionType = CommonUniforms.client.field_1773.method_19418().method_19334();
        if (submersionType == class_5636.field_27886) {
            return 1;
        }
        if (submersionType == class_5636.field_27885) {
            return 2;
        }
        if (submersionType == class_5636.field_27887) {
            return 3;
        }
        return 0;
    }

    private static class HeldItemLightingSupplier
    implements IntSupplier {
        private final class_1268 hand;

        private HeldItemLightingSupplier(class_1268 targetHand) {
            this.hand = targetHand;
        }

        @Override
        public int getAsInt() {
            if (client.field_1724 == null) {
                return 0;
            }
            class_1799 stack = client.field_1724.method_5998(this.hand);
            if (stack == class_1799.field_8037 || stack == null || !(stack.method_7909() instanceof class_1747)) {
                return 0;
            }
            class_1747 item = (class_1747)stack.method_7909();
            return item.method_7711().method_9564().method_26213();
        }
    }
}

