/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Function;
import link.infra.indium.renderer.IndiumRenderer;
import link.infra.indium.renderer.aocalc.AoConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Indigo
implements ClientModInitializer {
    public static final boolean ALWAYS_TESSELATE_INDIGO;
    public static final AoConfig AMBIENT_OCCLUSION_MODE;
    public static final boolean DEBUG_COMPARE_LIGHTING;
    public static final boolean FIX_SMOOTH_LIGHTING_OFFSET;
    public static final boolean FIX_EXTERIOR_VERTEX_LIGHTING;
    public static final boolean FIX_LUMINOUS_AO_SHADE;
    public static final Logger LOGGER;

    private static boolean asBoolean(String property, boolean defValue) {
        switch (Indigo.asTriState(property)) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return defValue;
    }

    private static <T extends Enum> T asEnum(String property, T defValue) {
        if (property == null || property.isEmpty()) {
            return defValue;
        }
        for (Enum obj : (Enum[])defValue.getClass().getEnumConstants()) {
            if (!property.equalsIgnoreCase(obj.name())) continue;
            return (T)obj;
        }
        return defValue;
    }

    private static TriState asTriState(String property) {
        if (property == null || property.isEmpty()) {
            return TriState.DEFAULT;
        }
        switch (property.toLowerCase(Locale.ROOT)) {
            case "true": {
                return TriState.TRUE;
            }
            case "false": {
                return TriState.FALSE;
            }
        }
        return TriState.DEFAULT;
    }

    public void onInitializeClient() {
        RendererAccess.INSTANCE.registerRenderer((Renderer)IndiumRenderer.INSTANCE);
    }

    static {
        Closeable stream;
        LOGGER = LogManager.getLogger();
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve("indium-renderer.properties");
        Properties properties = new Properties();
        if (Files.exists(configFile, new LinkOption[0])) {
            try {
                stream = Files.newInputStream(configFile, new OpenOption[0]);
                try {
                    properties.load((InputStream)stream);
                }
                finally {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("[Indium] Could not read property file '" + configFile.toAbsolutePath() + "'", (Throwable)e);
            }
        }
        ALWAYS_TESSELATE_INDIGO = Indigo.asBoolean((String)properties.computeIfAbsent("always-tesselate-blocks", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), false);
        AMBIENT_OCCLUSION_MODE = Indigo.asEnum((String)properties.computeIfAbsent("ambient-occlusion-mode", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), AoConfig.ENHANCED);
        DEBUG_COMPARE_LIGHTING = Indigo.asBoolean((String)properties.computeIfAbsent("debug-compare-lighting", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), false);
        FIX_SMOOTH_LIGHTING_OFFSET = Indigo.asBoolean((String)properties.computeIfAbsent("fix-smooth-lighting-offset", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), true);
        FIX_EXTERIOR_VERTEX_LIGHTING = Indigo.asBoolean((String)properties.computeIfAbsent("fix-exterior-vertex-lighting", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), true);
        FIX_LUMINOUS_AO_SHADE = Indigo.asBoolean((String)properties.computeIfAbsent("fix-luminous-block-ambient-occlusion", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), false);
        try {
            stream = Files.newOutputStream(configFile, new OpenOption[0]);
            try {
                properties.store((OutputStream)stream, "Indium properties file");
            }
            finally {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("[Indium] Could not store property file '" + configFile.toAbsolutePath() + "'", (Throwable)e);
        }
    }
}

