/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import link.infra.indium.other.VertexConsumerSinkShim;
import link.infra.indium.renderer.aocalc.AoLuminanceFix;
import link.infra.indium.renderer.render.TerrainBlockRenderInfo;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4588;
import net.minecraft.class_761;

public class IndiumChunkRenderInfo {
    private final Long2IntOpenHashMap brightnessCache = new Long2IntOpenHashMap();
    private final Long2FloatOpenHashMap aoLevelCache;
    class_1920 blockView;
    ChunkBuildBuffers buffers;
    TerrainBlockRenderInfo blockRenderInfo;

    IndiumChunkRenderInfo() {
        this.brightnessCache.defaultReturnValue(Integer.MAX_VALUE);
        this.aoLevelCache = new Long2FloatOpenHashMap();
        this.aoLevelCache.defaultReturnValue(Float.MAX_VALUE);
    }

    void prepare(class_1920 blockView, ChunkBuildBuffers buffers, TerrainBlockRenderInfo blockRenderInfo) {
        this.blockView = blockView;
        this.buffers = buffers;
        this.brightnessCache.clear();
        this.aoLevelCache.clear();
        this.blockRenderInfo = blockRenderInfo;
    }

    public class_4588 getInitializedBuffer(class_1921 renderLayer) {
        ChunkModelBuilder chunkModelBuilder = this.buffers.get(renderLayer);
        return new VertexConsumerSinkShim(chunkModelBuilder.getVertexSink(), chunkModelBuilder.getIndexBufferBuilder(ModelQuadFacing.UNASSIGNED), this.blockRenderInfo, chunkModelBuilder.getChunkId());
    }

    int cachedBrightness(class_2338 pos) {
        long key = pos.method_10063();
        int result = this.brightnessCache.get(key);
        if (result == Integer.MAX_VALUE) {
            result = class_761.method_23793((class_1920)this.blockView, (class_2680)this.blockView.method_8320(pos), (class_2338)pos);
            this.brightnessCache.put(key, result);
        }
        return result;
    }

    float cachedAoLevel(class_2338 pos) {
        long key = pos.method_10063();
        float result = this.aoLevelCache.get(key);
        if (result == Float.MAX_VALUE) {
            result = AoLuminanceFix.INSTANCE.apply((class_1922)this.blockView, pos);
            this.aoLevelCache.put(key, result);
        }
        return result;
    }
}

