/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Consumer;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.render.AbstractMeshConsumer;
import link.infra.indium.renderer.render.AbstractRenderContext;
import link.infra.indium.renderer.render.IndiumChunkRenderInfo;
import link.infra.indium.renderer.render.TerrainBlockRenderInfo;
import link.infra.indium.renderer.render.TerrainFallbackConsumer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_5539;

public class IndiumTerrainRenderContext
extends AbstractRenderContext
implements RenderContext {
    private final TerrainBlockRenderInfo blockInfo = new TerrainBlockRenderInfo();
    private final IndiumChunkRenderInfo chunkInfo = new IndiumChunkRenderInfo();
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo, this.chunkInfo::cachedBrightness, this.chunkInfo::cachedAoLevel);
    private final AbstractMeshConsumer meshConsumer = new AbstractMeshConsumer(this.blockInfo, this.chunkInfo::getInitializedBuffer, this.aoCalc, this::transform){

        @Override
        protected int overlay() {
            return IndiumTerrainRenderContext.this.overlay;
        }

        @Override
        protected class_1159 matrix() {
            return IndiumTerrainRenderContext.this.matrix;
        }

        @Override
        protected class_4581 normalMatrix() {
            return IndiumTerrainRenderContext.this.normalMatrix;
        }
    };
    private final TerrainFallbackConsumer fallbackConsumer = new TerrainFallbackConsumer(this.blockInfo, this.chunkInfo::getInitializedBuffer, this.aoCalc, this::transform){

        @Override
        protected int overlay() {
            return IndiumTerrainRenderContext.this.overlay;
        }

        @Override
        protected class_1159 matrix() {
            return IndiumTerrainRenderContext.this.matrix;
        }

        @Override
        protected class_4581 normalMatrix() {
            return IndiumTerrainRenderContext.this.normalMatrix;
        }
    };

    public IndiumTerrainRenderContext prepare(class_1920 blockView, ChunkBuildBuffers buffers) {
        this.blockInfo.setBlockView(blockView);
        this.chunkInfo.prepare(blockView, buffers, this.blockInfo);
        return this;
    }

    public void release() {
        this.blockInfo.release();
    }

    public boolean tesselateBlock(class_2680 blockState, class_2338 blockPos, class_2338 origin, class_1087 model, class_4587 matrixStack) {
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        try {
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(blockState, blockPos, model.method_4708());
            this.blockInfo.setOrigin(origin);
            ((FabricBakedModel)model).emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable var9) {
            class_128 crashReport_1 = class_128.method_560((Throwable)var9, (String)"Tesselating block in world - Indium Renderer");
            class_129 crashReportElement_1 = crashReport_1.method_562("Block being tesselated");
            class_129.method_586((class_129)crashReportElement_1, (class_5539)this.chunkInfo.blockView, (class_2338)blockPos, (class_2680)blockState);
            throw new class_148(crashReport_1);
        }
        return false;
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }
}

