/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.entry.renderer;

import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRendererProvider;
import me.shedaniel.rei.api.client.entry.renderer.ForwardingEntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.Reloadable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface EntryRendererRegistry
extends Reloadable<REIClientPlugin> {
    public static EntryRendererRegistry getInstance() {
        return PluginManager.getClientInstance().get(EntryRendererRegistry.class);
    }

    public <T> void register(EntryType<T> var1, EntryRendererProvider<T> var2);

    default public <T> void transformTooltip(EntryType<T> type, final TooltipTransformer<T> transformer) {
        this.register(type, (entry, last) -> new ForwardingEntryRenderer<T>(last){

            @Override
            @Nullable
            public Tooltip getTooltip(EntryStack<T> entry, Point mouse) {
                return transformer.transform(entry, mouse, super.getTooltip(entry, mouse));
            }
        });
    }

    public <T> EntryRenderer<T> get(EntryStack<T> var1);

    @FunctionalInterface
    public static interface TooltipTransformer<T> {
        @Nullable
        public Tooltip transform(EntryStack<T> var1, Point var2, @Nullable Tooltip var3);
    }
}

