/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.mojang.serialization.DataResult;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClientInternals {
    private static Supplier<ClientHelper> clientHelper = ClientInternals::throwNotSetup;
    private static Supplier<WidgetsProvider> widgetsProvider = ClientInternals::throwNotSetup;
    private static Supplier<ViewSearchBuilder> viewSearchBuilder = ClientInternals::throwNotSetup;
    private static Supplier<PluginManager<REIClientPlugin>> clientPluginManager = ClientInternals::throwNotSetup;
    private static Supplier<EntryRenderer<?>> emptyEntryRenderer = ClientInternals::throwNotSetup;
    private static BiFunction<Supplier<DataResult<FavoriteEntry>>, Supplier<class_2487>, FavoriteEntry> delegateFavoriteEntry = (supplier, toJson) -> (FavoriteEntry)ClientInternals.throwNotSetup();
    private static Function<class_2487, DataResult<FavoriteEntry>> favoriteEntryFromJson = object -> (DataResult)ClientInternals.throwNotSetup();
    private static Function<Boolean, ClickArea.Result> clickAreaHandlerResult = result -> (ClickArea.Result)ClientInternals.throwNotSetup();
    private static BiConsumer<List<class_5684>, class_5632> clientTooltipComponentProvider = (tooltip, result) -> ClientInternals.throwNotSetup();
    private static BiFunction<@Nullable Point, Collection<Tooltip.Entry>, Tooltip> tooltipProvider = (point, texts) -> (Tooltip)ClientInternals.throwNotSetup();
    private static Function<Object, Tooltip.Entry> tooltipEntryProvider = component -> (Tooltip.Entry)ClientInternals.throwNotSetup();
    private static Supplier<List<String>> jeiCompatMods = ClientInternals::throwNotSetup;
    private static Supplier<Object> builtinClientPlugin = ClientInternals::throwNotSetup;

    private static <T> T throwNotSetup() {
        throw new AssertionError((Object)"REI Internals have not been initialized!");
    }

    @ApiStatus.Internal
    public static <T> void attachInstance(T instance, Class<T> clazz) {
        ClientInternals.attachInstanceSupplier(instance, clazz.getSimpleName());
    }

    @ApiStatus.Internal
    public static <T> void attachInstanceSupplier(T instance, String name) {
        ClientInternals.attachInstance(() -> instance, name);
    }

    public static <T> void attachInstance(T instance, String name) {
        try {
            for (Field field : ClientInternals.class.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(name)) continue;
                field.setAccessible(true);
                field.set(null, instance);
                return;
            }
            throw new RuntimeException("Failed to attach " + instance + " with field name: " + name);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClientHelper getClientHelper() {
        return clientHelper.get();
    }

    public static WidgetsProvider getWidgetsProvider() {
        return widgetsProvider.get();
    }

    public static ViewSearchBuilder createViewSearchBuilder() {
        return viewSearchBuilder.get();
    }

    public static Object getBuiltinPlugin() {
        return builtinClientPlugin.get();
    }

    public static ClickArea.Result createClickAreaHandlerResult(boolean applicable) {
        return clickAreaHandlerResult.apply(applicable);
    }

    public static void getClientTooltipComponent(List<class_5684> tooltip, class_5632 component) {
        clientTooltipComponentProvider.accept(tooltip, component);
    }

    public static Tooltip createTooltip(@Nullable Point point, Collection<Tooltip.Entry> texts) {
        return tooltipProvider.apply(point, texts);
    }

    public static Tooltip.Entry createTooltipEntry(Object component) {
        return tooltipEntryProvider.apply(component);
    }

    public static FavoriteEntry delegateFavoriteEntry(Supplier<DataResult<FavoriteEntry>> supplier, Supplier<class_2487> toJoin) {
        return delegateFavoriteEntry.apply(supplier, toJoin);
    }

    public static DataResult<FavoriteEntry> favoriteEntryFromJson(class_2487 tag) {
        return favoriteEntryFromJson.apply(tag);
    }

    public static <T> EntryRenderer<T> getEmptyEntryRenderer() {
        return emptyEntryRenderer.get().cast();
    }

    public static List<String> getJeiCompatMods() {
        return jeiCompatMods.get();
    }

    public static PluginManager<REIClientPlugin> getPluginManager() {
        return clientPluginManager.get();
    }

    @Environment(value=EnvType.CLIENT)
    public static interface WidgetsProvider {
        public boolean isRenderingPanel(Panel var1);

        public Widget createDrawableWidget(DrawableConsumer var1);

        public Slot createSlot(Point var1);

        public Slot createSlot(Rectangle var1);

        public Button createButton(Rectangle var1, class_2561 var2);

        public Panel createPanelWidget(Rectangle var1);

        public Label createLabel(Point var1, class_5348 var2);

        public Arrow createArrow(Rectangle var1);

        public BurningFire createBurningFire(Rectangle var1);

        public DrawableConsumer createTexturedConsumer(class_2960 var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9, int var10, int var11);

        public DrawableConsumer createFillRectangleConsumer(Rectangle var1, int var2);
    }
}

