/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.region.RegionEntry;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionDraggableStack;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionEntryListEntry;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionListener;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3902;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class EntryStacksRegionWidget<T extends RegionEntry<T>>
extends WidgetWithBounds
implements DraggableStackProviderWidget,
DraggableStackVisitorWidget {
    public final RegionListener<T> listener;
    protected int blockedCount;
    private Rectangle bounds = new Rectangle();
    private Rectangle innerBounds;
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return EntryStacksRegionWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            if (EntryStacksRegionWidget.this.innerBounds.width == 0) {
                return 0;
            }
            return class_3532.method_15386((float)((float)(EntryStacksRegionWidget.this.entries.size() + EntryStacksRegionWidget.this.blockedCount) / ((float)EntryStacksRegionWidget.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }

        public int getScrollBarX() {
            if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
                return EntryStacksRegionWidget.this.bounds.x + 1;
            }
            return EntryStacksRegionWidget.this.bounds.getMaxX() - 7;
        }
    };
    private final Int2ObjectMap<RealRegionEntry<T>> entries = new Int2ObjectLinkedOpenHashMap();
    private final Int2ObjectMap<RealRegionEntry<T>> removedEntries = new Int2ObjectLinkedOpenHashMap();
    private List<RegionEntryListEntry<T>> entriesList = Lists.newArrayList();
    private List<Widget> children = Lists.newArrayList();

    public EntryStacksRegionWidget(RegionListener<T> listener) {
        this.listener = listener;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_4587 poses, int mouseX, int mouseY, float delta) {
        if (this.bounds.isEmpty()) {
            return;
        }
        int entrySize = EntryListWidget.entrySize();
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        this.updateEntriesPosition(entry -> true);
        for (RealRegionEntry entry2 : this.entries.values()) {
            entry2.update(delta);
        }
        ObjectIterator removedEntriesIterator = this.removedEntries.values().iterator();
        while (removedEntriesIterator.hasNext()) {
            RealRegionEntry removedEntry = (RealRegionEntry)removedEntriesIterator.next();
            removedEntry.update(delta);
            if (!(removedEntry.size.doubleValue() <= 300.0)) continue;
            removedEntriesIterator.remove();
            this.entriesList.remove(removedEntry.getWidget());
            this.children.remove(removedEntry.getWidget());
        }
        ScissorsHandler.INSTANCE.scissor(this.bounds);
        Stream<RegionEntryListEntry> entryStream = this.entriesList.stream().filter(entry -> entry.getBounds().getMaxY() >= this.bounds.getY() && entry.getBounds().y <= this.bounds.getMaxY());
        new BatchedEntryRendererManager(entryStream.collect(Collectors.toList())).render(poses, mouseX, mouseY, delta);
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        ScissorsHandler.INSTANCE.removeLastScissor();
    }

    public List<Widget> method_25396() {
        return this.children;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY, ConfigObject.getInstance().doesSnapToRows(), (double)EntryListWidget.entrySize())) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.containsMouse(PointHelper.ofMouse())) {
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public DraggableStack getHoveredStack(DraggingContext<class_437> context, double mouseX, double mouseY) {
        if (this.innerBounds.contains(mouseX, mouseY)) {
            for (RealRegionEntry entry : this.entries.values()) {
                if (!entry.getWidget().containsMouse(mouseX, mouseY) || !this.listener.canBeDragged(entry)) continue;
                return new RegionDraggableStack(entry, null);
            }
        }
        return null;
    }

    public EntryStack<?> getFocusedStack() {
        Point mouse = PointHelper.ofMouse();
        if (this.innerBounds.contains(mouse)) {
            for (RealRegionEntry entry : this.entries.values()) {
                if (!entry.getWidget().containsMouse(mouse)) continue;
                return entry.getWidget().getCurrentEntry().copy();
            }
        }
        return EntryStack.empty();
    }

    public Stream<EntryStack<?>> getEntries() {
        return this.entriesList.stream().filter(entry -> entry.getBounds().getMaxY() >= this.bounds.getY() && entry.getBounds().y <= this.bounds.getMaxY()).map(EntryWidget::getCurrentEntry).filter(entry -> !entry.isEmpty());
    }

    @Override
    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<class_437> context, DraggableStack stack) {
        return this.checkDraggedStacks(context, stack).filter(entry -> this.innerBounds.contains(context.getCurrentPosition())).flatMap(entry -> {
            if (stack instanceof RegionDraggableStack && ((RegionDraggableStack)stack).getEntry().region == this && ((RegionDraggableStack)stack).getShowcaseWidget() == null) {
                return Optional.empty();
            }
            if (!this.drop((RealRegionEntry<T>)entry)) {
                return Optional.empty();
            }
            return Optional.of(class_3902.field_17274);
        }).isPresent() ? DraggedAcceptorResult.CONSUMED : DraggedAcceptorResult.PASS;
    }

    public Optional<RealRegionEntry<T>> checkDraggedStacks(DraggingContext<class_437> context, DraggableStack stack) {
        EntrySerializer<?> serializer = stack.getStack().getDefinition().getSerializer();
        if (serializer != null && (stack instanceof RegionDraggableStack || serializer.supportReading() && serializer.supportSaving())) {
            try {
                Object regionEntry;
                Object t = regionEntry = stack instanceof RegionDraggableStack ? ((RegionDraggableStack)stack).getEntry().getEntry().copy() : this.listener.convertDraggableStack(context, stack);
                if (regionEntry == null) {
                    return Optional.empty();
                }
                RealRegionEntry entry = new RealRegionEntry(this, regionEntry, EntryListWidget.entrySize());
                entry.size.setAs(EntryListWidget.entrySize() * 100);
                return Optional.of(entry);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public void setEntries(List<T> newEntries) {
        newEntries = Lists.newArrayList((Iterable)newEntries);
        newEntries.removeIf(entry -> entry == null || entry.isEntryInvalid());
        int entrySize = EntryListWidget.entrySize();
        IntOpenHashSet newFavoritesHash = new IntOpenHashSet((IntCollection)CollectionUtils.mapToInt(newEntries, Object::hashCode));
        ArrayList removedEntries = Lists.newArrayList((Iterable)this.entries.values());
        removedEntries.removeIf(arg_0 -> EntryStacksRegionWidget.lambda$setEntries$7((IntSet)newFavoritesHash, arg_0));
        for (RealRegionEntry removedEntry : removedEntries) {
            removedEntry.remove();
            this.removedEntries.put(removedEntry.hashIgnoreAmount(), (Object)removedEntry);
        }
        ArrayList<RealRegionEntry<RegionEntry>> addedEntries = new ArrayList<RealRegionEntry<RegionEntry>>();
        Int2ObjectOpenHashMap prevEntries = new Int2ObjectOpenHashMap(this.entries);
        this.entries.clear();
        for (RegionEntry regionEntry : newEntries) {
            RealRegionEntry<RegionEntry> realEntry = (RealRegionEntry<RegionEntry>)prevEntries.get(regionEntry.hashCode());
            if (realEntry == null) {
                realEntry = new RealRegionEntry<RegionEntry>(this, regionEntry, entrySize);
                addedEntries.add(realEntry);
            }
            if (!ConfigObject.getInstance().isFavoritesAnimated()) {
                realEntry.size.setAs(entrySize * 100);
            } else {
                realEntry.size.setTo(entrySize * 100, 300L);
            }
            this.entries.put(realEntry.hashIgnoreAmount(), realEntry);
        }
        this.applyNewEntriesList();
        this.updateEntriesPosition(arg_0 -> EntryStacksRegionWidget.lambda$setEntries$8((Int2ObjectMap)prevEntries, arg_0));
        for (RealRegionEntry realRegionEntry : removedEntries) {
            this.listener.onRemove(realRegionEntry);
        }
        for (RealRegionEntry realRegionEntry : addedEntries) {
            this.listener.onAdd(realRegionEntry);
        }
        this.listener.onSetNewEntries(this.entriesList);
        this.listener.onSetNewEntries(this.entriesList.stream().map(RegionEntryListEntry::getEntry).map(RealRegionEntry::getEntry));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void applyNewEntriesList() {
        this.entriesList = Stream.concat(this.entries.values().stream().map(RealRegionEntry::getWidget), this.removedEntries.values().stream().map(RealRegionEntry::getWidget)).collect(Collectors.toList());
        this.children = Stream.of(this.entries.values().stream().map(RealRegionEntry::getWidget), this.removedEntries.values().stream().map(RealRegionEntry::getWidget)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public void updateEntriesPosition(Predicate<RealRegionEntry<T>> animated) {
        int entrySize = EntryListWidget.entrySize();
        this.blockedCount = 0;
        this.innerBounds = EntryStacksRegionWidget.updateInnerBounds(this.bounds);
        int width = this.innerBounds.width / entrySize;
        int currentX = 0;
        int currentY = 0;
        int releaseIndex = this.getReleaseIndex(null);
        int slotIndex = 0;
        block0: for (RealRegionEntry entry : this.entries.values()) {
            while (true) {
                int xPos = currentX * entrySize + this.innerBounds.x;
                int yPos = currentY * entrySize + this.innerBounds.y;
                if (++currentX >= width) {
                    currentX = 0;
                    ++currentY;
                }
                if (EntryListWidget.notSteppingOnExclusionZones(xPos, yPos - (int)this.scrolling.scrollAmount, entrySize, entrySize, this.innerBounds)) {
                    if (slotIndex++ == releaseIndex) continue;
                    entry.moveTo(animated.test(entry), xPos, yPos);
                    continue block0;
                }
                ++this.blockedCount;
            }
        }
    }

    private int getReleaseIndex(@Nullable Point position) {
        DraggingContext<?> context = DraggingContext.getInstance();
        if (position == null) {
            position = context.getCurrentPosition();
        }
        if (context.isDraggingStack() && this.bounds.contains(position) && this.checkDraggedStacks(context.cast(), context.getCurrentStack()).isPresent()) {
            int yPos;
            int xPos;
            int entrySize = EntryListWidget.entrySize();
            int width = this.innerBounds.width / entrySize;
            int currentX = 0;
            int currentY = 0;
            ArrayList entriesPoints = Lists.newArrayList();
            block0: for (RealRegionEntry entry : this.entries.values()) {
                while (true) {
                    int xPos2 = currentX * entrySize + this.innerBounds.x;
                    int yPos2 = currentY * entrySize + this.innerBounds.y;
                    if (++currentX >= width) {
                        currentX = 0;
                        ++currentY;
                    }
                    if (EntryListWidget.notSteppingOnExclusionZones(xPos2, yPos2 - (int)this.scrolling.scrollAmount, entrySize, entrySize, this.innerBounds)) {
                        entriesPoints.add(new class_3545((Object)entry, (Object)new Point(xPos2, yPos2)));
                        continue block0;
                    }
                    ++this.blockedCount;
                }
            }
            int maxSize = entriesPoints.size();
            if (currentX != 0 && EntryListWidget.notSteppingOnExclusionZones(xPos = currentX * entrySize + this.innerBounds.x, (yPos = currentY * entrySize + this.innerBounds.y) - (int)this.scrolling.scrollAmount, entrySize, entrySize, this.innerBounds)) {
                entriesPoints.add(new class_3545(null, (Object)new Point(xPos, yPos)));
            }
            double x = position.x - 8;
            double y = (double)position.y + this.scrolling.scrollAmount - 8.0;
            return class_3532.method_15340((int)entriesPoints.stream().filter(value -> {
                double otherY = ((Point)value.method_15441()).y;
                return otherY <= y + (double)(entrySize / 2) && otherY + (double)entrySize > y + (double)(entrySize / 2);
            }).min(Comparator.comparingDouble(value -> {
                double otherX = ((Point)value.method_15441()).x;
                double otherY = ((Point)value.method_15441()).y;
                return (x - otherX) * (x - otherX) + (y - otherY) * (y - otherY);
            })).map(entriesPoints::indexOf).orElse(maxSize), (int)0, (int)entriesPoints.size());
        }
        return -2;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int entrySize = EntryListWidget.entrySize();
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
        if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
    }

    public boolean drop(RealRegionEntry<T> entry) {
        DraggingContext<?> context = DraggingContext.getInstance();
        double x = context.getCurrentPosition().x;
        double y = (double)context.getCurrentPosition().y + this.scrolling.scrollAmount;
        return this.drop(entry, x, y);
    }

    public boolean drop(RealRegionEntry<T> entry, double x, double y) {
        boolean contains = this.bounds.contains(x, y);
        int newIndex = contains ? this.getReleaseIndex(new Point(x, y)) : Math.max(-1, Iterables.indexOf((Iterable)this.entries.values(), e -> e == entry));
        return this.drop(entry, x, y, newIndex < 0 ? this.entries.size() : newIndex);
    }

    public boolean drop(RealRegionEntry<T> entry, double x, double y, int newIndex) {
        if (newIndex < 0) {
            return this.drop(entry, x, y);
        }
        if (!this.listener.canAcceptDrop(entry)) {
            return false;
        }
        entry.pos.setAs(new FloatingPoint(x - 8.0, y - 8.0));
        if (this.entries.size() <= newIndex) {
            RealRegionEntry remove = (RealRegionEntry)this.entries.remove(entry.hashIgnoreAmount());
            if (remove != null) {
                remove.remove();
                this.removedEntries.put(remove.hashIgnoreAmount(), (Object)remove);
            }
            this.entries.put(entry.hashIgnoreAmount(), entry);
        } else {
            Int2ObjectLinkedOpenHashMap prevEntries = new Int2ObjectLinkedOpenHashMap(this.entries);
            this.entries.clear();
            int index = 0;
            for (Int2ObjectMap.Entry entryEntry : prevEntries.int2ObjectEntrySet()) {
                if (index == newIndex) {
                    this.entries.put(entry.hashIgnoreAmount(), entry);
                }
                if (entryEntry.getIntKey() == entry.hashIgnoreAmount()) continue;
                this.entries.put(entryEntry.getIntKey(), (Object)((RealRegionEntry)entryEntry.getValue()));
                ++index;
            }
        }
        this.applyNewEntriesList();
        this.listener.onDrop(this.entries.values().stream().map(RealRegionEntry::getEntry));
        this.setEntries(this.entries.values().stream().map(RealRegionEntry::getEntry).collect(Collectors.toList()));
        return true;
    }

    public int indexOf(RealRegionEntry<T> entry) {
        return this.entriesList.indexOf(entry.getWidget());
    }

    public void remove(RealRegionEntry<T> entry) {
        this.entries.remove(entry.hashIgnoreAmount());
        this.setEntries(CollectionUtils.map(this.entries.values(), RealRegionEntry::getEntry));
    }

    public double getScrollAmount() {
        return this.scrolling.scrollAmount;
    }

    public boolean has(RealRegionEntry<T> entry) {
        return this.has(entry.getEntry());
    }

    public boolean has(T entry) {
        int hash = entry.hashCode();
        return this.entries.containsKey(hash) && !this.removedEntries.containsKey(hash);
    }

    public Rectangle getInnerBounds() {
        return this.innerBounds;
    }

    private static /* synthetic */ boolean lambda$setEntries$8(Int2ObjectMap prevEntries, RealRegionEntry entry) {
        return prevEntries.containsKey(entry.hashIgnoreAmount());
    }

    private static /* synthetic */ boolean lambda$setEntries$7(IntSet newFavoritesHash, RealRegionEntry entry) {
        return newFavoritesHash.contains(entry.hashIgnoreAmount());
    }
}

