/*
 * Decompiled with CFR 0.152.
 */
package frozenblock.wild.mod.entity;

import frozenblock.wild.mod.blocks.FrogEggBlock;
import frozenblock.wild.mod.entity.FrogMoveControl;
import frozenblock.wild.mod.liukrastapi.FrogGoal;
import frozenblock.wild.mod.liukrastapi.FrogMateGoal;
import frozenblock.wild.mod.liukrastapi.FrogWanderInWaterGoal;
import frozenblock.wild.mod.liukrastapi.LayFrogEggGoal;
import frozenblock.wild.mod.registry.RegisterBlocks;
import frozenblock.wild.mod.registry.RegisterSounds;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class FrogEntity
extends class_1429 {
    static final int BREEDING_COOLDOWN = 6000;
    private static final class_2940<Integer> VARIANT;
    public static final String VARIANT_KEY = "Variant";
    public static final int SWAMP = 0;
    public static final int COLD = 1;
    public static final int TROPICAL = 2;
    private static final double speed = 0.3;
    public static final class_2940<Boolean> HAS_FROG_EGG;
    public static final class_2940<class_2338> TRAVEL_POS;
    public static final class_2940<Boolean> ACTIVELY_TRAVELLING;
    public static final class_1856 BREEDING_ITEM;
    private int loveTicks;
    private int tongue;
    public long eatTimer = 0L;

    public FrogEntity(class_1299<? extends FrogEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new FrogMoveControl(this);
    }

    public static class_5132.class_5133 createFrogAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.3);
    }

    public static boolean canColdSpawn(class_1937 world, class_2338 pos) {
        return world.method_23753(pos).method_33599(pos) || world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9362);
    }

    public static boolean canTropicalSpawn(class_1937 world, class_2338 pos) {
        return world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9358) || world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9368);
    }

    void setTravelPos(class_2338 pos) {
        this.field_6011.method_12778(TRAVEL_POS, (Object)pos);
    }

    class_2338 getTravelPos() {
        return (class_2338)this.field_6011.method_12789(TRAVEL_POS);
    }

    public boolean hasFrogEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_FROG_EGG);
    }

    public void setHasEgg(boolean hasfrogEgg) {
        this.field_6011.method_12778(HAS_FROG_EGG, (Object)hasfrogEgg);
    }

    public boolean method_24828() {
        return this.field_5952;
    }

    public int getTongue() {
        return this.tongue;
    }

    public void method_6007() {
        super.method_6007();
        if (this.tongue > 0) {
            --this.tongue;
            System.out.println(this.tongue);
        }
        if (this.method_5618() != 0) {
            this.loveTicks = 0;
        }
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.loveTicks % 10 == 0) {
                double d = this.field_5974.nextGaussian() * 0.02;
                double e = this.field_5974.nextGaussian() * 0.02;
                double f = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        }
        if (this.hasFrogEgg() && this.canPlace(this.field_6002, this.method_24515())) {
            class_1937 world = this.field_6002;
            world.method_8396((class_1657)null, this.method_24515(), class_3417.field_14634, class_3419.field_15245, 0.3f, 0.9f + world.field_9229.nextFloat() * 0.2f);
            world.method_8652(this.method_24515().method_10084(), RegisterBlocks.FROG_EGG.method_9564(), 3);
            world.method_20290(2005, this.method_24515().method_10084(), 0);
            world.method_39279(this.method_24515(), world.method_8320(this.method_24515()).method_26204(), class_6019.method_35017((int)400, (int)1800).method_35008(world.method_8409()));
            this.setHasEgg(false);
            this.method_6476(600);
        }
    }

    public boolean method_5869() {
        if (this.method_5770().method_8320(new class_2338(this.method_19538().field_1352, this.method_19538().field_1351 - 0.0625, this.method_19538().field_1350)) == class_2246.field_10382.method_9564()) {
            return true;
        }
        return this.field_6000 && this.method_5799();
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        if (spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16470) {
            if (FrogEntity.canColdSpawn(this.method_5770(), this.method_24515())) {
                this.setVariant(Variant.COLD);
            } else if (FrogEntity.canTropicalSpawn(this.method_5770(), this.method_24515())) {
                this.setVariant(Variant.TROPICAL);
            }
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(HAS_FROG_EGG, (Object)false);
        this.field_6011.method_12784(ACTIVELY_TRAVELLING, (Object)false);
        this.field_6011.method_12784(TRAVEL_POS, (Object)this.method_24515());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(VARIANT_KEY, this.getVariant().getId());
        nbt.method_10544("eatTimer", this.eatTimer);
        nbt.method_10556("HasEgg", this.hasFrogEgg());
        nbt.method_10569("TravelPosX", this.getTravelPos().method_10263());
        nbt.method_10569("TravelPosY", this.getTravelPos().method_10264());
        nbt.method_10569("TravelPosZ", this.getTravelPos().method_10260());
    }

    public Variant getVariant() {
        return Variant.VARIANTS[(Integer)this.field_6011.method_12789(VARIANT)];
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Variant.VARIANTS[nbt.method_10550(VARIANT_KEY)]);
        this.eatTimer = nbt.method_10537("eatTimer");
        this.setHasEgg(nbt.method_10577("HasEgg"));
        int l = nbt.method_10550("TravelPosX");
        int m = nbt.method_10550("TravelPosY");
        int n = nbt.method_10550("TravelPosZ");
        this.setTravelPos(new class_2338(l, m, n));
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new LayFrogEggGoal(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new FrogMateGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new FrogWanderInWaterGoal(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 0.3));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.1, BREEDING_ITEM, false));
        this.field_6201.method_6277(3, (class_1352)new FrogGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 10.0f));
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_2246.field_10376.method_8389());
    }

    protected class_3414 method_5994() {
        return RegisterSounds.ENTITY_FROG_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return RegisterSounds.ENTITY_FROG_HURT;
    }

    protected class_3414 method_6002() {
        return RegisterSounds.ENTITY_FROG_DEATH;
    }

    protected class_3414 getStepSound() {
        return class_3417.field_14878;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(this.getStepSound(), 0.15f, 1.0f);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public void method_6476(int loveTicks) {
        this.loveTicks = loveTicks;
    }

    public int method_29270() {
        return this.loveTicks;
    }

    public void method_5711(byte status) {
        if (status == 4) {
            this.tongue = 10;
        } else if (status == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.field_5974.nextGaussian() * 0.02;
                double e = this.field_5974.nextGaussian() * 0.02;
                double f = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        } else {
            super.method_5711(status);
        }
    }

    protected boolean canPlace(class_1937 world, class_2338 pos) {
        return world.method_22347(pos.method_10084()) && FrogEggBlock.isWater((class_1922)world, pos);
    }

    static {
        HAS_FROG_EGG = class_2945.method_12791(FrogEntity.class, (class_2941)class_2943.field_13323);
        TRAVEL_POS = class_2945.method_12791(FrogEntity.class, (class_2941)class_2943.field_13324);
        ACTIVELY_TRAVELLING = class_2945.method_12791(FrogEntity.class, (class_2941)class_2943.field_13323);
        BREEDING_ITEM = class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_10376.method_8389()});
        VARIANT = class_2945.method_12791(FrogEntity.class, (class_2941)class_2943.field_13327);
    }

    public static enum Variant {
        SWAMP(0, "swamp"),
        COLD(1, "cold"),
        TROPICAL(2, "tropical");

        public static final Variant[] VARIANTS;
        private final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        static {
            VARIANTS = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

