/*
 * Decompiled with CFR 0.152.
 */
package frozenblock.wild.mod.entity;

import com.google.common.collect.Lists;
import frozenblock.wild.mod.registry.RegisterEntities;
import frozenblock.wild.mod.registry.RegisterItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2553;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2836;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import net.minecraft.class_5459;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class MangroveBoatEntity
extends class_1297 {
    private static final class_2940<Integer> DAMAGE_WOBBLE_TICKS = class_2945.method_12791(class_1690.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DAMAGE_WOBBLE_SIDE = class_2945.method_12791(class_1690.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DAMAGE_WOBBLE_STRENGTH = class_2945.method_12791(class_1690.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> LEFT_PADDLE_MOVING = class_2945.method_12791(class_1690.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> RIGHT_PADDLE_MOVING = class_2945.method_12791(class_1690.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> BUBBLE_WOBBLE_TICKS = class_2945.method_12791(class_1690.class, (class_2941)class_2943.field_13327);
    public static final int field_30697 = 0;
    public static final int field_30698 = 1;
    private static final int field_30695 = 60;
    private static final double field_30696 = (double)0.3926991f;
    public static final double field_30699 = 0.7853981852531433;
    public static final int field_30700 = 60;
    private final float[] paddlePhases = new float[2];
    private float velocityDecay;
    private float ticksUnderwater;
    private float yawVelocity;
    private int field_7708;
    private double x;
    private double y;
    private double z;
    private double boatYaw;
    private double boatPitch;
    private boolean pressingLeft;
    private boolean pressingRight;
    private boolean pressingForward;
    private boolean pressingBack;
    private double waterLevel;
    private float field_7714;
    private Location location;
    private Location lastLocation;
    private double fallVelocity;
    private boolean onBubbleColumnSurface;
    private boolean bubbleColumnIsDrag;
    private float bubbleWobbleStrength;
    private float bubbleWobble;
    private float lastBubbleWobble;

    public MangroveBoatEntity(class_1299<? extends MangroveBoatEntity> type, class_1937 world) {
        super(type, world);
        this.field_23807 = true;
    }

    public MangroveBoatEntity(class_1937 world, double x, double y, double z) {
        this(RegisterEntities.MANGROVE_BOAT, world);
        this.method_5814(x, y, z);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    protected void method_5693() {
        this.field_6011.method_12784(DAMAGE_WOBBLE_TICKS, (Object)0);
        this.field_6011.method_12784(DAMAGE_WOBBLE_SIDE, (Object)1);
        this.field_6011.method_12784(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LEFT_PADDLE_MOVING, (Object)false);
        this.field_6011.method_12784(RIGHT_PADDLE_MOVING, (Object)false);
        this.field_6011.method_12784(BUBBLE_WOBBLE_TICKS, (Object)0);
    }

    public boolean method_30949(class_1297 other) {
        return MangroveBoatEntity.canCollide(this, other);
    }

    public static boolean canCollide(class_1297 entity, class_1297 other) {
        return (other.method_30948() || other.method_5810()) && !entity.method_5794(other);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return true;
    }

    protected class_243 method_30633(class_2350.class_2351 portalAxis, class_5459.class_5460 portalRect) {
        return class_1309.method_31079((class_243)super.method_30633(portalAxis, portalRect));
    }

    public double method_5621() {
        return -0.1;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.field_6002.field_9236 && !this.method_31481()) {
            boolean bl;
            this.setDamageWobbleSide(-this.getDamageWobbleSide());
            this.setDamageWobbleTicks(10);
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f);
            this.method_5785();
            this.method_32875(class_5712.field_28736, source.method_5529());
            boolean bl2 = bl = source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).method_31549().field_7477;
            if (bl || this.getDamageWobbleStrength() > 40.0f) {
                if (!bl && this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                    this.method_5706((class_1935)this.asItem());
                }
                this.method_31472();
            }
            return true;
        }
        return true;
    }

    public void method_5700(boolean drag) {
        if (!this.field_6002.field_9236) {
            this.onBubbleColumnSurface = true;
            this.bubbleColumnIsDrag = drag;
            if (this.getBubbleWobbleTicks() == 0) {
                this.setBubbleWobbleTicks(60);
            }
        }
        this.field_6002.method_8406((class_2394)class_2398.field_11202, this.method_23317() + (double)this.field_5974.nextFloat(), this.method_23318() + 0.7, this.method_23321() + (double)this.field_5974.nextFloat(), 0.0, 0.0, 0.0);
        if (this.field_5974.nextInt(20) == 0) {
            this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), this.method_5625(), this.method_5634(), 1.0f, 0.8f + 0.4f * this.field_5974.nextFloat(), false);
        }
        this.method_32875(class_5712.field_28160, this.method_5642());
    }

    public void method_5697(class_1297 entity) {
        if (entity instanceof class_1690) {
            if (entity.method_5829().field_1322 < this.method_5829().field_1325) {
                super.method_5697(entity);
            }
        } else if (entity.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entity);
        }
    }

    public class_1792 asItem() {
        return RegisterItems.MANGROVE_BOAT;
    }

    public void method_5879() {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.field_7708 = 10;
    }

    public class_2350 method_5755() {
        return this.method_5735().method_10170();
    }

    public void method_5773() {
        this.lastLocation = this.location;
        this.location = this.checkLocation();
        this.ticksUnderwater = this.location != Location.UNDER_WATER && this.location != Location.UNDER_FLOWING_WATER ? 0.0f : (this.ticksUnderwater += 1.0f);
        if (!this.field_6002.field_9236 && this.ticksUnderwater >= 60.0f) {
            this.method_5772();
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.method_5773();
        this.method_7555();
        if (this.method_5787()) {
            if (!(this.method_31483() instanceof class_1657)) {
                this.setPaddleMovings(false, false);
            }
            this.updateVelocity();
            if (this.field_6002.field_9236) {
                this.updatePaddles();
                this.field_6002.method_8522((class_2596)new class_2836(this.isPaddleMoving(0), this.isPaddleMoving(1)));
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
        } else {
            this.method_18799(class_243.field_1353);
        }
        this.handleBubbleColumn();
        for (int i = 0; i <= 1; ++i) {
            if (this.isPaddleMoving(i)) {
                class_3414 soundEvent;
                if (!this.method_5701() && (double)(this.paddlePhases[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.paddlePhases[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundEvent = this.getPaddleSoundEvent()) != null) {
                    class_243 vec3d = this.method_5828(1.0f);
                    double d = i == 1 ? -vec3d.field_1350 : vec3d.field_1350;
                    double e = i == 1 ? vec3d.field_1352 : -vec3d.field_1352;
                    this.field_6002.method_8465((class_1657)null, this.method_23317() + d, this.method_23318(), this.method_23321() + e, soundEvent, this.method_5634(), 1.0f, 0.8f + 0.4f * this.field_5974.nextFloat());
                    this.field_6002.method_32888(this.method_5642(), class_5712.field_28160, new class_2338(this.method_23317() + d, this.method_23318(), this.method_23321() + e));
                }
                float[] var10000 = this.paddlePhases;
                var10000[i] = (float)((double)var10000[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePhases[i] = 0.0f;
        }
        this.method_5852();
        List list = this.field_6002.method_8333((class_1297)this, this.method_5829().method_1009((double)0.2f, (double)-0.01f, (double)0.2f), class_1301.method_5911((class_1297)this));
        if (!list.isEmpty()) {
            boolean bl = !this.field_6002.field_9236 && !(this.method_5642() instanceof class_1657);
            for (int j = 0; j < list.size(); ++j) {
                class_1297 entity = (class_1297)list.get(j);
                if (entity.method_5626((class_1297)this)) continue;
                if (bl && this.method_5685().size() < 2 && !entity.method_5765() && entity.method_17681() < this.method_17681() && entity instanceof class_1309 && !(entity instanceof class_1480) && !(entity instanceof class_1657)) {
                    entity.method_5804((class_1297)this);
                    continue;
                }
                this.method_5697(entity);
            }
        }
    }

    private void handleBubbleColumn() {
        if (this.field_6002.field_9236) {
            int j = this.getBubbleWobbleTicks();
            this.bubbleWobbleStrength = j > 0 ? (this.bubbleWobbleStrength += 0.05f) : (this.bubbleWobbleStrength -= 0.1f);
            this.bubbleWobbleStrength = class_3532.method_15363((float)this.bubbleWobbleStrength, (float)0.0f, (float)1.0f);
            this.lastBubbleWobble = this.bubbleWobble;
            this.bubbleWobble = 10.0f * (float)Math.sin(0.5f * (float)this.field_6002.method_8510()) * this.bubbleWobbleStrength;
        } else {
            int j;
            if (!this.onBubbleColumnSurface) {
                this.setBubbleWobbleTicks(0);
            }
            if ((j = this.getBubbleWobbleTicks()) > 0) {
                this.setBubbleWobbleTicks(--j);
                int k = 60 - j - 1;
                if (k > 0 && j == 0) {
                    this.setBubbleWobbleTicks(0);
                    class_243 vec3d = this.method_18798();
                    if (this.bubbleColumnIsDrag) {
                        this.method_18799(vec3d.method_1031(0.0, -0.7, 0.0));
                        this.method_5772();
                    } else {
                        this.method_18800(vec3d.field_1352, this.method_5703(entity -> entity instanceof class_1657) ? 2.7 : 0.6, vec3d.field_1350);
                    }
                }
                this.onBubbleColumnSurface = false;
            }
        }
    }

    @Nullable
    protected class_3414 getPaddleSoundEvent() {
        switch (this.checkLocation()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return class_3417.field_15171;
            }
            case ON_LAND: {
                return class_3417.field_14886;
            }
        }
        return null;
    }

    private void method_7555() {
        if (this.method_5787()) {
            this.field_7708 = 0;
            this.method_18003(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.field_7708 > 0) {
            double d = this.method_23317() + (this.x - this.method_23317()) / (double)this.field_7708;
            double e = this.method_23318() + (this.y - this.method_23318()) / (double)this.field_7708;
            double f = this.method_23321() + (this.z - this.method_23321()) / (double)this.field_7708;
            double g = class_3532.method_15338((double)(this.boatYaw - (double)this.method_36454()));
            this.method_36456(this.method_36454() + (float)g / (float)this.field_7708);
            this.method_36457(this.method_36455() + (float)(this.boatPitch - (double)this.method_36455()) / (float)this.field_7708);
            --this.field_7708;
            this.method_5814(d, e, f);
            this.method_5710(this.method_36454(), this.method_36455());
        }
    }

    public void setPaddleMovings(boolean leftMoving, boolean rightMoving) {
        this.field_6011.method_12778(LEFT_PADDLE_MOVING, (Object)leftMoving);
        this.field_6011.method_12778(RIGHT_PADDLE_MOVING, (Object)rightMoving);
    }

    public float interpolatePaddlePhase(int paddle, float tickDelta) {
        return this.isPaddleMoving(paddle) ? (float)class_3532.method_15390((double)((double)this.paddlePhases[paddle] - (double)0.3926991f), (double)this.paddlePhases[paddle], (double)tickDelta) : 0.0f;
    }

    private Location checkLocation() {
        Location location = this.getUnderWaterLocation();
        if (location != null) {
            this.waterLevel = this.method_5829().field_1325;
            return location;
        }
        if (this.checkBoatInWater()) {
            return Location.IN_WATER;
        }
        float f = this.method_7548();
        if (f > 0.0f) {
            this.field_7714 = f;
            return Location.ON_LAND;
        }
        return Location.IN_AIR;
    }

    public float method_7544() {
        class_238 box = this.method_5829();
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1325);
        int l = class_3532.method_15384((double)(box.field_1325 - this.fallVelocity));
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        block0: for (int o = k; o < l; ++o) {
            float f = 0.0f;
            for (int p = i; p < j; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(p, o, q);
                    class_3610 fluidState = this.field_6002.method_8316((class_2338)mutable);
                    if (fluidState.method_15767((class_3494)class_3486.field_15517)) {
                        f = Math.max(f, fluidState.method_15763((class_1922)this.field_6002, (class_2338)mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)mutable.method_10264() + f;
        }
        return l + 1;
    }

    public float method_7548() {
        class_238 box = this.method_5829();
        class_238 box2 = new class_238(box.field_1323, box.field_1322 - 0.001, box.field_1321, box.field_1320, box.field_1322, box.field_1324);
        int i = class_3532.method_15357((double)box2.field_1323) - 1;
        int j = class_3532.method_15384((double)box2.field_1320) + 1;
        int k = class_3532.method_15357((double)box2.field_1322) - 1;
        int l = class_3532.method_15384((double)box2.field_1325) + 1;
        int m = class_3532.method_15357((double)box2.field_1321) - 1;
        int n = class_3532.method_15384((double)box2.field_1324) + 1;
        class_265 voxelShape = class_259.method_1078((class_238)box2);
        float f = 0.0f;
        int o = 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int p = i; p < j; ++p) {
            for (int q = m; q < n; ++q) {
                int r = (p != i && p != j - 1 ? 0 : 1) + (q != m && q != n - 1 ? 0 : 1);
                if (r == 2) continue;
                for (int s = k; s < l; ++s) {
                    if (r > 0 && (s == k || s == l - 1)) continue;
                    mutable.method_10103(p, s, q);
                    class_2680 blockState = this.field_6002.method_8320((class_2338)mutable);
                    if (blockState.method_26204() instanceof class_2553 || !class_259.method_1074((class_265)blockState.method_26220((class_1922)this.field_6002, (class_2338)mutable).method_1096((double)p, (double)s, (double)q), (class_265)voxelShape, (class_247)class_247.field_16896)) continue;
                    f += blockState.method_26204().method_9499();
                    ++o;
                }
            }
        }
        return f / (float)o;
    }

    private boolean checkBoatInWater() {
        class_238 box = this.method_5829();
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1322);
        int l = class_3532.method_15384((double)(box.field_1322 + 0.001));
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean bl = false;
        this.waterLevel = -1.7976931348623157E308;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.field_6002.method_8316((class_2338)mutable);
                    if (!fluidState.method_15767((class_3494)class_3486.field_15517)) continue;
                    float f = (float)p + fluidState.method_15763((class_1922)this.field_6002, (class_2338)mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    bl |= box.field_1322 < (double)f;
                }
            }
        }
        return bl;
    }

    @Nullable
    private Location getUnderWaterLocation() {
        class_238 box = this.method_5829();
        double d = box.field_1325 + 0.001;
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1325);
        int l = class_3532.method_15384((double)d);
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean bl = false;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.field_6002.method_8316((class_2338)mutable);
                    if (!fluidState.method_15767((class_3494)class_3486.field_15517) || !(d < (double)((float)mutable.method_10264() + fluidState.method_15763((class_1922)this.field_6002, (class_2338)mutable)))) continue;
                    if (!fluidState.method_15771()) {
                        return Location.UNDER_FLOWING_WATER;
                    }
                    bl = true;
                }
            }
        }
        return bl ? Location.UNDER_WATER : null;
    }

    private void updateVelocity() {
        double d = -0.04f;
        double e = this.method_5740() ? 0.0 : (double)-0.04f;
        double f = 0.0;
        this.velocityDecay = 0.05f;
        if (this.lastLocation == Location.IN_AIR && this.location != Location.IN_AIR && this.location != Location.ON_LAND) {
            this.waterLevel = this.method_23323(1.0);
            this.method_5814(this.method_23317(), (double)(this.method_7544() - this.method_17682()) + 0.101, this.method_23321());
            this.method_18799(this.method_18798().method_18805(1.0, 0.0, 1.0));
            this.fallVelocity = 0.0;
            this.location = Location.IN_WATER;
        } else {
            if (this.location == Location.IN_WATER) {
                f = (this.waterLevel - this.method_23318()) / (double)this.method_17682();
                this.velocityDecay = 0.9f;
            } else if (this.location == Location.UNDER_FLOWING_WATER) {
                e = -7.0E-4;
                this.velocityDecay = 0.9f;
            } else if (this.location == Location.UNDER_WATER) {
                f = 0.01f;
                this.velocityDecay = 0.45f;
            } else if (this.location == Location.IN_AIR) {
                this.velocityDecay = 0.9f;
            } else if (this.location == Location.ON_LAND) {
                this.velocityDecay = this.field_7714;
                if (this.method_5642() instanceof class_1657) {
                    this.field_7714 /= 2.0f;
                }
            }
            class_243 vec3d = this.method_18798();
            this.method_18800(vec3d.field_1352 * (double)this.velocityDecay, vec3d.field_1351 + e, vec3d.field_1350 * (double)this.velocityDecay);
            this.yawVelocity *= this.velocityDecay;
            if (f > 0.0) {
                class_243 vec3d2 = this.method_18798();
                this.method_18800(vec3d2.field_1352, (vec3d2.field_1351 + f * 0.06153846016296973) * 0.75, vec3d2.field_1350);
            }
        }
    }

    private void updatePaddles() {
        if (this.method_5782()) {
            float f = 0.0f;
            if (this.pressingLeft) {
                this.yawVelocity -= 1.0f;
            }
            if (this.pressingRight) {
                this.yawVelocity += 1.0f;
            }
            if (this.pressingRight != this.pressingLeft && !this.pressingForward && !this.pressingBack) {
                f += 0.005f;
            }
            this.method_36456(this.method_36454() + this.yawVelocity);
            if (this.pressingForward) {
                f += 0.04f;
            }
            if (this.pressingBack) {
                f -= 0.005f;
            }
            this.method_18799(this.method_18798().method_1031((double)(class_3532.method_15374((float)(-this.method_36454() * ((float)Math.PI / 180))) * f), 0.0, (double)(class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * f)));
            this.setPaddleMovings(this.pressingRight && !this.pressingLeft || this.pressingForward, this.pressingLeft && !this.pressingRight || this.pressingForward);
        }
    }

    public void method_5865(class_1297 passenger) {
        if (this.method_5626(passenger)) {
            float f = 0.0f;
            float g = (float)((this.method_31481() ? (double)0.01f : this.method_5621()) + passenger.method_5678());
            if (this.method_5685().size() > 1) {
                int i = this.method_5685().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof class_1429) {
                    f = (float)((double)f + 0.2);
                }
            }
            class_243 vec3d = new class_243((double)f, 0.0, 0.0).method_1024(-this.method_36454() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.method_5814(this.method_23317() + vec3d.field_1352, this.method_23318() + (double)g, this.method_23321() + vec3d.field_1350);
            passenger.method_36456(passenger.method_36454() + this.yawVelocity);
            passenger.method_5847(passenger.method_5791() + this.yawVelocity);
            this.copyEntityData(passenger);
            if (passenger instanceof class_1429 && this.method_5685().size() > 1) {
                int j = passenger.method_5628() % 2 == 0 ? 90 : 270;
                passenger.method_5636(((class_1429)passenger).field_6283 + (float)j);
                passenger.method_5847(passenger.method_5791() + (float)j);
            }
        }
    }

    public class_243 method_24829(class_1309 passenger) {
        double e;
        class_243 vec3d = MangroveBoatEntity.method_24826((double)(this.method_17681() * class_3532.field_15724), (double)passenger.method_17681(), (float)passenger.method_36454());
        double d = this.method_23317() + vec3d.field_1352;
        class_2338 blockPos = new class_2338(d, this.method_5829().field_1325, e = this.method_23321() + vec3d.field_1350);
        class_2338 blockPos2 = blockPos.method_10074();
        if (!this.field_6002.method_22351(blockPos2)) {
            double g;
            ArrayList list = Lists.newArrayList();
            double f = this.field_6002.method_30347(blockPos);
            if (class_5275.method_27932((double)f)) {
                list.add(new class_243(d, (double)blockPos.method_10264() + f, e));
            }
            if (class_5275.method_27932((double)(g = this.field_6002.method_30347(blockPos2)))) {
                list.add(new class_243(d, (double)blockPos2.method_10264() + g, e));
            }
            for (class_4050 entityPose : passenger.method_24831()) {
                for (class_243 vec3d2 : list) {
                    if (!class_5275.method_33353((class_1941)this.field_6002, (class_243)vec3d2, (class_1309)passenger, (class_4050)entityPose)) continue;
                    passenger.method_18380(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.method_24829(passenger);
    }

    protected void copyEntityData(class_1297 entity) {
        entity.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(entity.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        entity.field_5982 += g - f;
        entity.method_36456(entity.method_36454() + g - f);
        entity.method_5847(entity.method_36454());
    }

    public void method_5644(class_1297 passenger) {
        this.copyEntityData(passenger);
    }

    protected void method_5652(class_2487 nbt) {
    }

    protected void method_5749(class_2487 nbt) {
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (this.ticksUnderwater < 60.0f) {
            if (!this.field_6002.field_9236) {
                return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        this.fallVelocity = this.method_18798().field_1351;
        if (!this.method_5765()) {
            if (onGround) {
                if (this.field_6017 > 3.0f) {
                    if (this.location != Location.ON_LAND) {
                        this.field_6017 = 0.0f;
                        return;
                    }
                    this.method_5747(this.field_6017, 1.0f, class_1282.field_5868);
                    if (!this.field_6002.field_9236 && !this.method_31481()) {
                        this.method_5768();
                        if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                            int j;
                            for (j = 0; j < 3; ++j) {
                                this.method_5706((class_1935)this.asItem());
                            }
                            for (j = 0; j < 2; ++j) {
                                this.method_5706((class_1935)class_1802.field_8600);
                            }
                        }
                    }
                }
                this.field_6017 = 0.0f;
            } else if (!this.field_6002.method_8316(this.method_24515().method_10074()).method_15767((class_3494)class_3486.field_15517) && heightDifference < 0.0) {
                this.field_6017 = (float)((double)this.field_6017 - heightDifference);
            }
        }
    }

    public boolean isPaddleMoving(int paddle) {
        return (Boolean)this.field_6011.method_12789(paddle == 0 ? LEFT_PADDLE_MOVING : RIGHT_PADDLE_MOVING) != false && this.method_5642() != null;
    }

    public void setDamageWobbleStrength(float wobbleStrength) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(wobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.field_6011.method_12789(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public void setDamageWobbleTicks(int wobbleTicks) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_TICKS, (Object)wobbleTicks);
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_TICKS);
    }

    private void setBubbleWobbleTicks(int wobbleTicks) {
        this.field_6011.method_12778(BUBBLE_WOBBLE_TICKS, (Object)wobbleTicks);
    }

    private int getBubbleWobbleTicks() {
        return (Integer)this.field_6011.method_12789(BUBBLE_WOBBLE_TICKS);
    }

    public float interpolateBubbleWobble(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastBubbleWobble, (float)this.bubbleWobble);
    }

    public void setDamageWobbleSide(int side) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_SIDE, (Object)side);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_SIDE);
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < 2 && !this.method_5777((class_3494)class_3486.field_15517);
    }

    @Nullable
    public class_1297 method_5642() {
        return this.method_31483();
    }

    public void setInputs(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        this.pressingLeft = pressingLeft;
        this.pressingRight = pressingRight;
        this.pressingForward = pressingForward;
        this.pressingBack = pressingBack;
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public boolean method_5869() {
        return this.location == Location.UNDER_WATER || this.location == Location.UNDER_FLOWING_WATER;
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.asItem());
    }

    public static enum Location {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

