/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity;

import it.unimi.dsi.fastutil.objects.Reference2ByteOpenHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Logger;
import me.jellysquid.mods.lithium.common.reflection.ReflectionUtil;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1606;
import net.minecraft.class_1695;

public class EntityClassGroup {
    public static final EntityClassGroup MINECART_BOAT_LIKE_COLLISION;
    private final Predicate<Class<?>> classFitEvaluator;
    private volatile Reference2ByteOpenHashMap<Class<?>> class2GroupContains = new Reference2ByteOpenHashMap();

    public EntityClassGroup(Predicate<Class<?>> classFitEvaluator) {
        Objects.requireNonNull(classFitEvaluator);
        this.classFitEvaluator = classFitEvaluator;
    }

    public void clear() {
        this.class2GroupContains = new Reference2ByteOpenHashMap();
    }

    public boolean contains(Class<?> entityClass) {
        byte contains = this.class2GroupContains.getOrDefault(entityClass, (byte)2);
        if (contains != 2) {
            return contains == 1;
        }
        return this.testAndAddClass(entityClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean testAndAddClass(Class<?> entityClass) {
        byte contains;
        EntityClassGroup entityClassGroup = this;
        synchronized (entityClassGroup) {
            contains = this.class2GroupContains.getOrDefault(entityClass, (byte)2);
            if (contains != 2) {
                return contains == 1;
            }
            Reference2ByteOpenHashMap newMap = this.class2GroupContains.clone();
            contains = this.classFitEvaluator.test(entityClass) ? (byte)1 : 0;
            newMap.put(entityClass, contains);
            this.class2GroupContains = newMap;
        }
        return contains == 1;
    }

    static {
        String remapped_method_30949 = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_1297", "method_30949", "(Lnet/minecraft/class_1297;)Z");
        MINECART_BOAT_LIKE_COLLISION = new EntityClassGroup(entityClass -> ReflectionUtil.isMethodFromSuperclassOverwritten(entityClass, class_1297.class, remapped_method_30949, class_1297.class));
        if (!MINECART_BOAT_LIKE_COLLISION.contains(class_1695.class)) {
            throw new AssertionError();
        }
        if (MINECART_BOAT_LIKE_COLLISION.contains(class_1606.class)) {
            Logger.getLogger("Lithium EntityClassGroup").warning("Either chunk.entity_class_groups is broken or something else gave Shulkers the minecart-like collision behavior.");
        }
        MINECART_BOAT_LIKE_COLLISION.clear();
    }

    public static class NoDragonClassGroup
    extends EntityClassGroup {
        public static final NoDragonClassGroup BOAT_SHULKER_LIKE_COLLISION;

        public NoDragonClassGroup(Predicate<Class<?>> classFitEvaluator) {
            super(classFitEvaluator);
            if (classFitEvaluator.test(class_1510.class)) {
                throw new IllegalArgumentException("EntityClassGroupNoDragon cannot be initialized: Class fit evaluator must exclude EnderDragonEntity!");
            }
        }

        static {
            String remapped_method_30948 = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_1297", "method_30948", "()Z");
            BOAT_SHULKER_LIKE_COLLISION = new NoDragonClassGroup(entityClass -> ReflectionUtil.isMethodFromSuperclassOverwritten(entityClass, class_1297.class, remapped_method_30948, new Class[0]));
            if (!BOAT_SHULKER_LIKE_COLLISION.contains(class_1606.class)) {
                throw new AssertionError();
            }
            BOAT_SHULKER_LIKE_COLLISION.clear();
        }
    }
}

