/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIBlockEntityTypes;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.api.FluidFuelRegistry;
import aztech.modern_industrialization.api.ScrewdriverableBlockEntity;
import aztech.modern_industrialization.api.WrenchableBlockEntity;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerScreenHandler;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPacketHandlers;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPackets;
import aztech.modern_industrialization.items.armor.ArmorPackets;
import aztech.modern_industrialization.items.armor.MIArmorEffects;
import aztech.modern_industrialization.items.armor.MIKeyMap;
import aztech.modern_industrialization.machines.MachinePackets;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MultiblockHatches;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.init.SingleBlockCraftingMachines;
import aztech.modern_industrialization.machines.init.SingleBlockSpecialMachines;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListeners;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.misc.autotest.MIAutoTesting;
import aztech.modern_industrialization.misc.guidebook.GuidebookEvents;
import aztech.modern_industrialization.nuclear.NuclearItem;
import aztech.modern_industrialization.pipes.MIPipes;
import java.util.Map;
import java.util.function.Consumer;
import me.shedaniel.cloth.api.common.events.v1.PlayerChangeWorldCallback;
import me.shedaniel.cloth.api.common.events.v1.PlayerLeaveCallback;
import net.devtech.arrp.api.RRPCallback;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JEntry;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.loot.JPool;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricMaterialBuilder;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModernIndustrialization
implements ModInitializer {
    public static final String MOD_ID = "modern_industrialization";
    public static final Logger LOGGER = LogManager.getLogger((String)"Modern Industrialization");
    public static final RuntimeResourcePack RESOURCE_PACK = RuntimeResourcePack.create((String)"modern_industrialization:general");
    public static final class_3614 METAL_MATERIAL = new FabricMaterialBuilder(class_3620.field_16005).method_15813();
    public static final class_3614 STONE_MATERIAL = new FabricMaterialBuilder(class_3620.field_16023).method_15813();
    public static final class_1761 ITEM_GROUP = FabricItemGroupBuilder.build((class_2960)new class_2960("modern_industrialization", "general"), () -> new class_1799((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier("forge_hammer"))));
    public static final class_3494<class_1792> SCREWDRIVERS = TagFactory.ITEM.create(new class_2960("c:screwdrivers"));
    public static final class_3494<class_1792> WRENCHES = TagFactory.ITEM.create(new class_2960("c:wrenches"));
    public static final class_3917<MachineScreenHandlers.Common> SCREEN_HANDLER_MACHINE = ScreenHandlerRegistry.registerExtended((class_2960)new MIIdentifier("machine"), MachineScreenHandlers::createClient);
    public static final class_3917<ForgeHammerScreenHandler> SCREEN_HANDLER_FORGE_HAMMER = ScreenHandlerRegistry.registerSimple((class_2960)new class_2960("modern_industrialization", "forge_hammer"), ForgeHammerScreenHandler::new);

    public void onInitialize() {
        MIMaterials.init();
        MITags.init();
        MIMachineRecipeTypes.init();
        SingleBlockCraftingMachines.init();
        SingleBlockSpecialMachines.init();
        MultiblockHatches.init();
        MultiblockMachines.init();
        NuclearItem.init();
        this.setupItems();
        this.setupBlocks();
        MIBlockEntityTypes.init();
        MIFluids.setupFluids();
        this.setupPackets();
        this.setupFuels();
        MIArmorEffects.init();
        this.setupWrench();
        MIPipes.INSTANCE.setup();
        RRPCallback.EVENT.register(a -> a.add(RESOURCE_PACK));
        ChunkEventListeners.init();
        PlayerChangeWorldCallback.EVENT.register((player, oldWorld, newWorld) -> MIKeyMap.clear((class_1657)player));
        PlayerLeaveCallback.EVENT.register(MIKeyMap::clear);
        GuidebookEvents.init();
        if (System.getProperty("modern_industrialization.autoTest") != null) {
            MIAutoTesting.init();
        }
        LOGGER.info("Modern Industrialization setup done!");
    }

    private void setupItems() {
        for (Map.Entry<String, class_1792> entry : MIItem.items.entrySet()) {
            ModernIndustrialization.registerItem(entry.getValue(), entry.getKey());
            if (!MIItem.registrationEvents.containsKey(entry.getKey())) continue;
            ((Consumer)MIItem.registrationEvents.get(entry.getKey())).accept(entry.getValue());
        }
    }

    public static void registerItem(class_1792 item, String id) {
        MIIdentifier ID = new MIIdentifier(id);
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)ID, (Object)item);
        RESOURCE_PACK.addModel(JModel.model().parent(MIItem.handhelds.contains(id) ? "minecraft:item/handheld" : "minecraft:item/generated").textures(new JTextures().layer0(ID.method_12836() + ":items/" + ID.method_12832())), new class_2960(ID.method_12836() + ":item/" + ID.method_12832()));
    }

    private void setupBlocks() {
        for (Map.Entry<String, MIBlock> entry : MIBlock.blocks.entrySet()) {
            ModernIndustrialization.registerBlock(entry.getValue());
            entry.getValue().onRegister(entry.getValue(), entry.getValue().blockItem);
        }
    }

    public static void registerBlock(class_2248 block, class_1792 item, String id, int flag) {
        MIIdentifier identifier = new MIIdentifier(id);
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)identifier, (Object)block);
        if (class_2378.field_11142.method_17966((class_2960)identifier).isEmpty()) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)identifier, (Object)item);
        }
        if ((flag & 1) != 0) {
            if (block instanceof MIBlock) {
                RESOURCE_PACK.addLootTable((class_2960)new MIIdentifier("blocks/" + id), ((MIBlock)block).getLootTables());
            } else {
                RESOURCE_PACK.addLootTable((class_2960)new MIIdentifier("blocks/" + id), JLootTable.loot((String)"minecraft:block").pool(new JPool().rolls(Integer.valueOf(1)).entry(new JEntry().type("minecraft:item").name("modern_industrialization:" + id)).condition(new JCondition("minecraft:survives_explosion"))));
            }
        }
        RESOURCE_PACK.addBlockState(JState.state().add(new JVariant().put("", new JBlockModel("modern_industrialization:block/" + id))), (class_2960)identifier);
        if ((flag & 2) != 0) {
            RESOURCE_PACK.addModel(JModel.model().parent("block/cube_all").textures(new JTextures().var("all", "modern_industrialization:blocks/" + id)), (class_2960)new MIIdentifier("block/" + id));
        }
        if ((flag & 4) != 0) {
            RESOURCE_PACK.addModel(JModel.model().parent("modern_industrialization:block/" + id), (class_2960)new MIIdentifier("item/" + id));
        }
    }

    public static void registerBlock(class_2248 block, class_1792 item, String id) {
        ModernIndustrialization.registerBlock(block, item, id, 7);
    }

    public static void registerBlock(MIBlock block) {
        MIIdentifier identifier = new MIIdentifier(block.id);
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)identifier, (Object)((Object)block));
        if (class_2378.field_11142.method_17966((class_2960)identifier).isEmpty()) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)identifier, (Object)block.blockItem);
        }
        if ((block.FLAGS & 1) != 0 && block instanceof MIBlock) {
            RESOURCE_PACK.addLootTable((class_2960)new MIIdentifier("blocks/" + block.id), block.getLootTables());
        }
        RESOURCE_PACK.addBlockState(block.getBlockState(), (class_2960)identifier);
        if ((block.FLAGS & 2) != 0) {
            RESOURCE_PACK.addModel(block.getBlockModel(), (class_2960)new MIIdentifier("block/" + block.id));
        }
        if ((block.FLAGS & 4) != 0) {
            RESOURCE_PACK.addModel(block.getItemModel(), (class_2960)new MIIdentifier("item/" + block.id));
        }
    }

    private void setupPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.SET_LOCKING_MODE, (ServerPlayNetworking.PlayChannelHandler)ConfigurableInventoryPacketHandlers.C2S.SET_LOCKING_MODE);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.DO_SLOT_DRAGGING, (ServerPlayNetworking.PlayChannelHandler)ConfigurableInventoryPacketHandlers.C2S.DO_SLOT_DRAGGING);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.ADJUST_SLOT_CAPACITY, (ServerPlayNetworking.PlayChannelHandler)ConfigurableInventoryPacketHandlers.C2S.ADJUST_SLOT_CAPACITY);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MachinePackets.C2S.SET_AUTO_EXTRACT, (ServerPlayNetworking.PlayChannelHandler)MachinePackets.C2S.ON_SET_AUTO_EXTRACT);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MachinePackets.C2S.REI_LOCK_SLOTS, (ServerPlayNetworking.PlayChannelHandler)MachinePackets.C2S.ON_REI_LOCK_SLOTS);
        ServerSidePacketRegistry.INSTANCE.register(ArmorPackets.UPDATE_KEYS, ArmorPackets.ON_UPDATE_KEYS);
        ServerSidePacketRegistry.INSTANCE.register(ArmorPackets.ACTIVATE_CHEST, ArmorPackets.ON_ACTIVATE_CHEST);
    }

    private static void addFuel(String id, int burnTicks) {
        class_1792 item = (class_1792)class_2378.field_11142.method_10223((class_2960)new MIIdentifier(id));
        if (item == class_1802.field_8162) {
            throw new IllegalArgumentException("Couldn't find item " + id);
        }
        FuelRegistry.INSTANCE.add((class_1935)item, (Object)burnTicks);
    }

    private void setupFuels() {
        ModernIndustrialization.addFuel("coke", 6400);
        ModernIndustrialization.addFuel("coke_dust", 6400);
        ModernIndustrialization.addFuel("coke_block", Short.MAX_VALUE);
        ModernIndustrialization.addFuel("coal_crushed_dust", 1600);
        FuelRegistry.INSTANCE.add(TagRegistry.item((class_2960)new class_2960("c:coal_dusts")), (Object)1600);
        ModernIndustrialization.addFuel("coal_tiny_dust", 160);
        ModernIndustrialization.addFuel("lignite_coal", 1600);
        ModernIndustrialization.addFuel("lignite_coal_block", 16000);
        ModernIndustrialization.addFuel("lignite_coal_crushed_dust", 1600);
        ModernIndustrialization.addFuel("lignite_coal_dust", 1600);
        ModernIndustrialization.addFuel("lignite_coal_tiny_dust", 160);
        ModernIndustrialization.addFuel("carbon_dust", 6400);
        ModernIndustrialization.addFuel("carbon_tiny_dust", 640);
        FluidFuelRegistry.register(MIFluids.HYDROGEN, 1);
        FluidFuelRegistry.register(MIFluids.DEUTERIUM, 1);
        FluidFuelRegistry.register(MIFluids.TRITIUM, 1);
        FluidFuelRegistry.register(MIFluids.CRUDE_OIL, 8);
        FluidFuelRegistry.register(MIFluids.SYNTHETIC_OIL, 8);
        FluidFuelRegistry.register(MIFluids.NAPHTHA, 40);
        FluidFuelRegistry.register(MIFluids.CREOSOTE, 80);
        FluidFuelRegistry.register(MIFluids.LIGHT_FUEL, 80);
        FluidFuelRegistry.register(MIFluids.HEAVY_FUEL, 120);
        FluidFuelRegistry.register(MIFluids.DIESEL, 200);
        FluidFuelRegistry.register(MIFluids.BOOSTED_DIESEL, 400);
    }

    private void setupWrench() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (player.method_7325() || !world.method_8505(player, hitResult.method_17777())) {
                return class_1269.field_5811;
            }
            boolean isWrench = player.method_5998(hand).method_31573(WRENCHES);
            boolean isScrewdriver = player.method_5998(hand).method_31573(SCREWDRIVERS);
            if (isWrench || isScrewdriver) {
                ScrewdriverableBlockEntity screwdriverable;
                WrenchableBlockEntity wrenchable;
                class_2586 entity = world.method_8321(hitResult.method_17777());
                if (isWrench && entity instanceof WrenchableBlockEntity && (wrenchable = (WrenchableBlockEntity)entity).useWrench(player, hand, hitResult)) {
                    return class_1269.method_29236((boolean)world.method_8608());
                }
                if (isScrewdriver && entity instanceof ScrewdriverableBlockEntity && (screwdriverable = (ScrewdriverableBlockEntity)entity).useScrewdriver(player, hand, hitResult)) {
                    return class_1269.method_29236((boolean)world.method_8608());
                }
            }
            return class_1269.field_5811;
        });
    }
}

