/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIFluidsRender;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.pipes.item.SpeedUpgrade;
import aztech.modern_industrialization.blocks.OreBlock;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerScreen;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelTooltipData;
import aztech.modern_industrialization.blocks.storage.barrel.client.BarrelTooltipComponent;
import aztech.modern_industrialization.blocks.storage.tank.CreativeTankClientSetup;
import aztech.modern_industrialization.client.model.MachineModelLoader;
import aztech.modern_industrialization.debug.MissingTranslationsCommand;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPacketHandlers;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPackets;
import aztech.modern_industrialization.items.SteamDrillItem;
import aztech.modern_industrialization.items.armor.ClientKeyHandler;
import aztech.modern_industrialization.items.armor.HudRenderer;
import aztech.modern_industrialization.items.armor.JetpackParticleAdder;
import aztech.modern_industrialization.machines.ClientMachinePackets;
import aztech.modern_industrialization.machines.MachineOverlay;
import aztech.modern_industrialization.machines.MachinePackets;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.models.MachineModels;
import aztech.modern_industrialization.machines.multiblocks.MultiblockErrorHighlight;
import aztech.modern_industrialization.misc.tooltips.FaqTooltips;
import aztech.modern_industrialization.misc.version.VersionEvents;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.MIPipesClient;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.fabricmc.fabric.impl.content.registry.FuelRegistryImpl;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;

public class ModernIndustrializationClient
implements ClientModInitializer {
    public void onInitializeClient() {
        this.setupScreens();
        MIFluidsRender.setupFluidRenders();
        this.setupPackets();
        CreativeTankClientSetup.setupClient();
        MachineModels.init();
        MachineModelLoader.init();
        MultiblockMachines.clientInit();
        MultiblockErrorHighlight.init();
        WorldRenderEvents.BLOCK_OUTLINE.register(MachineOverlay::onBlockOutline);
        new MIPipesClient().setupClient();
        ClientKeyHandler.setup();
        WorldRenderEvents.START.register(renderer -> JetpackParticleAdder.addJetpackParticles(class_310.method_1551()));
        ClientTickEvents.END_CLIENT_TICK.register(ClientKeyHandler::onEndTick);
        HudRenderCallback.EVENT.register(HudRenderer::onRenderHud);
        this.setupTooltips();
        this.setupClientCommands();
        VersionEvents.init();
        FaqTooltips.init();
        ModernIndustrialization.LOGGER.info("Modern Industrialization client setup done!");
    }

    private void setupScreens() {
        ScreenRegistry.register(ModernIndustrialization.SCREEN_HANDLER_MACHINE, MachineScreenHandlers.ClientScreen::new);
        ScreenRegistry.register(ModernIndustrialization.SCREEN_HANDLER_FORGE_HAMMER, ForgeHammerScreen::new);
    }

    private void setupPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.UPDATE_ITEM_SLOT, (ClientPlayNetworking.PlayChannelHandler)ConfigurableInventoryPacketHandlers.S2C.UPDATE_ITEM_SLOT);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.UPDATE_FLUID_SLOT, (ClientPlayNetworking.PlayChannelHandler)ConfigurableInventoryPacketHandlers.S2C.UPDATE_FLUID_SLOT);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MachinePackets.S2C.COMPONENT_SYNC, (ClientPlayNetworking.PlayChannelHandler)ClientMachinePackets.ON_COMPONENT_SYNC);
    }

    private void setupTooltips() {
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            class_1792 item;
            SpeedUpgrade upgrade = (SpeedUpgrade)SpeedUpgrade.LOOKUP.find(stack, null);
            if (upgrade != null) {
                lines.add(new class_2588("text.modern_industrialization.tooltip_speed_upgrade", new Object[]{upgrade.value()}).method_10862(TextHelper.UPGRADE_TEXT));
            }
            if ((item = stack.method_7909()) != null) {
                PipeItem pipe;
                if (item instanceof PipeItem && MIPipes.electricityPipeTier.containsKey((Object)(pipe = (PipeItem)item))) {
                    CableTier tier = MIPipes.electricityPipeTier.get((Object)pipe);
                    lines.add(new class_2588("text.modern_industrialization.eu_cable", new Object[]{new class_2588(tier.translationKey), TextHelper.getEuTextTick(tier.getMaxTransfer(), true)}));
                }
                if (item == class_1802.field_8054) {
                    lines.add(new class_2588("text.modern_industrialization.gunpowder_upgrade").method_10862(TextHelper.GRAY_TEXT));
                }
                if (item == MIFluids.LUBRICANT.bucketItem) {
                    lines.add(new class_2588("text.modern_industrialization.lubricant_tooltip", new Object[]{25}).method_10862(TextHelper.GRAY_TEXT));
                }
                if (UpgradeComponent.upgrades.containsKey(item)) {
                    lines.add(new class_2588("text.modern_industrialization.machine_upgrade", new Object[]{UpgradeComponent.upgrades.get(item)}).method_10862(TextHelper.UPGRADE_TEXT));
                }
                if (item instanceof class_1747) {
                    class_2248 block = ((class_1747)item).method_7711();
                    if (ElectricBlastFurnaceBlockEntity.coilsMaxBaseEU.containsKey(block)) {
                        lines.add(new class_2588("text.modern_industrialization.ebf_max_eu", new Object[]{ElectricBlastFurnaceBlockEntity.coilsMaxBaseEU.get(block)}).method_10862(TextHelper.UPGRADE_TEXT));
                    } else if (block instanceof OreBlock) {
                        OreBlock oreBlock = (OreBlock)block;
                        if (oreBlock.params.generate) {
                            MIConfig config = MIConfig.getConfig();
                            if (config.generateOres && !config.blacklistedOres.contains(oreBlock.materialName)) {
                                lines.add(TextHelper.formatWithNumber("text.modern_industrialization.ore_generation_tooltip_y", -64L, oreBlock.params.maxYLevel).method_10862(TextHelper.GRAY_TEXT_NOT_ITALIC));
                                lines.add(TextHelper.formatWithNumber("text.modern_industrialization.ore_generation_tooltip_vein_frequency", oreBlock.params.veinsPerChunk).method_10862(TextHelper.GRAY_TEXT_NOT_ITALIC));
                                lines.add(TextHelper.formatWithNumber("text.modern_industrialization.ore_generation_tooltip_vein_size", oreBlock.params.veinSize).method_10862(TextHelper.GRAY_TEXT_NOT_ITALIC));
                            }
                        }
                    }
                }
                if (class_310.method_1551().field_1687 != null && !MIConfig.getConfig().disableFuelTooltips) {
                    try {
                        Integer fuelTime = (Integer)FuelRegistryImpl.INSTANCE.get((class_1935)item);
                        if (fuelTime != null && fuelTime > 0) {
                            long totalEu = fuelTime * 20;
                            lines.add(TextHelper.getEuStorageTooltip(totalEu));
                        }
                    }
                    catch (Exception e) {
                        ModernIndustrialization.LOGGER.warn("Could not show MI fuel tooltip.", (Throwable)e);
                    }
                }
                if (context.method_8035() && !MIConfig.getConfig().disableItemTagTooltips) {
                    List ids = (List)class_3489.method_15106().method_30206((Object)item);
                    Collections.sort(ids);
                    for (class_2960 id : ids) {
                        lines.add(new class_2585("#" + id).method_10862(TextHelper.GRAY_TEXT));
                    }
                }
            }
        });
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof BarrelTooltipData) {
                BarrelTooltipData barrelData = (BarrelTooltipData)data;
                return new BarrelTooltipComponent(barrelData);
            }
            if (data instanceof SteamDrillItem.SteamDrillTooltipData) {
                SteamDrillItem.SteamDrillTooltipData steamDrillData = (SteamDrillItem.SteamDrillTooltipData)data;
                return new SteamDrillItem.SteamDrillTooltipComponent(steamDrillData);
            }
            return null;
        });
    }

    private void setupClientCommands() {
        ClientCommandManager.DISPATCHER.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"miclient").then(ClientCommandManager.literal((String)"dump_missing_translations").executes(MissingTranslationsCommand::run)));
    }
}

